/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.comp.beans;

import com.sun.star.awt.XSystemChildFactory;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XVclWindowPeer;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.NamedValue;
import com.sun.star.comp.beans.OSDetect;
import com.sun.star.comp.beans.OfficeConnection;
import com.sun.star.comp.beans.SwtWinOfficeWindow;
import com.sun.star.comp.beans.UnoCaller;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XEventListener;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Any;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import org.eclipse.swt.widgets.Composite;

public class SwtWinOfficeWindow
extends Composite
implements XEventListener {
    private transient OfficeConnection mConnection;
    private boolean bPeer = false;
    private transient XWindowPeer mWindow;
    private transient XWindow xWindow;

    protected SwtWinOfficeWindow(OfficeConnection connection, Composite parent) {
        super(parent, 20185088);
        this.mConnection = connection;
        this.mConnection.addEventListener((XEventListener)this);
    }

    public void dispose() {
        System.out.println("SwtOfficeWindow.dispose");
        try {
            this.releaseSystemWindow();
        }
        catch (Exception e) {
            System.err.println("LocaleOfficeWindow.dispose: Exception in releaseSystemWindow.");
            e.printStackTrace(System.err);
        }
        super.dispose();
    }

    public XWindowPeer getUNOWindowPeer() {
        if (this.mWindow == null) {
            try {
                UnoCaller.call((XComponentContext)this.mConnection.getComponentContext(), (Callable)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return this.mWindow;
    }

    public void disposing(EventObject source) {
        this.mWindow = null;
        this.xWindow = null;
        this.mConnection = null;
    }

    private XToolkit queryAWTToolkit() {
        XComponentContext xContext = this.mConnection.getComponentContext();
        if (xContext != null) {
            XMultiComponentFactory compfactory = xContext.getServiceManager();
            XMultiServiceFactory factory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)compfactory);
            try {
                Object object = factory.createInstance("com.sun.star.awt.Toolkit");
                return (XToolkit)UnoRuntime.queryInterface(XToolkit.class, (Object)object);
            }
            catch (com.sun.star.uno.Exception e) {
                throw new RuntimeException("Failed getting com.sun.star.awt.Toolkit:" + e.toString(), e);
            }
        }
        return null;
    }

    private synchronized void aquireSystemWindow() {
        if (!this.bPeer) {
            try {
                UnoCaller.call((XComponentContext)this.mConnection.getComponentContext(), (Callable)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private synchronized void releaseSystemWindow() {
        if (this.bPeer) {
            System.out.println("SwtOfficeWindow.releaseSystemWindow");
            try {
                UnoCaller.callOtherThread((Callable)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getCause());
            }
        }
    }

    public void setVisible(boolean b) {
        if (b) {
            this.getDisplay().syncExec((Runnable)new SwtVisibilitySetter(this, b));
            this.aquireSystemWindow();
        } else {
            this.releaseSystemWindow();
            this.getDisplay().syncExec((Runnable)new SwtVisibilitySetter(this, b));
        }
    }

    XWindowPeer unoInnerCreateUnoWindow2() {
        XToolkit xToolkit = this.queryAWTToolkit();
        this.getDisplay().syncExec((Runnable)new SwtVisibilitySetter(this, true));
        XSystemChildFactory xFac = (XSystemChildFactory)UnoRuntime.queryInterface(XSystemChildFactory.class, (Object)xToolkit);
        Integer nativeHandle = (int)this.getNativeWindow();
        byte[] lIgnoredProcessID = new byte[]{};
        this.mWindow = xFac.createSystemChild((Object)nativeHandle, lIgnoredProcessID, this.getNativeWindowSystemType());
        this.xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)this.mWindow);
        this.xWindow.setVisible(this.bPeer);
        return this.mWindow;
    }

    private long getNativeWindow() {
        if (OSDetect.isLinux()) {
            try {
                Object object = this.getClass().getField("embeddedHandle").get(this);
                if (object instanceof Integer) {
                    return ((Integer)object).intValue();
                }
                return (Long)object;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
        return this.handle;
    }

    private short getNativeWindowSystemType() {
        if (OSDetect.isWindows()) {
            return 1;
        }
        return 6;
    }

    protected Any getWrappedWindowHandle() {
        String vendor;
        NamedValue window = new NamedValue("WINDOW", (Object)new Any(new Type(Long.class), (Object)new Long(this.getNativeWindow())));
        NamedValue xembed = new NamedValue("XEMBED", (Object)new Any(Type.BOOLEAN, (Object)Boolean.FALSE));
        if (this.getNativeWindowSystemType() == 6 && ((vendor = System.getProperty("java.vendor")).equals("Sun Microsystems Inc.") || vendor.equals("Oracle Corporation")) && Boolean.valueOf(System.getProperty("sun.awt.xembedserver")).booleanValue()) {
            xembed = new NamedValue("XEMBED", (Object)new Any(Type.BOOLEAN, (Object)Boolean.TRUE));
        }
        return new Any(new Type("[]com.sun.star.beans.NamedValue"), (Object)new NamedValue[]{window, xembed});
    }

    final void unoInnerReleaseWindow() {
        XVclWindowPeer xVclWindowPeer;
        if (this.xWindow != null) {
            this.xWindow.setVisible(false);
        }
        if ((xVclWindowPeer = (XVclWindowPeer)UnoRuntime.queryInterface(XVclWindowPeer.class, (Object)this.mWindow)) != null) {
            xVclWindowPeer.setProperty("PluginParent", (Object)new Long(0L));
        }
        this.bPeer = false;
    }

    final void unoInnerAcquireSystemWindow() {
        XVclWindowPeer xVclWindowPeer = (XVclWindowPeer)UnoRuntime.queryInterface(XVclWindowPeer.class, (Object)this.mWindow);
        xVclWindowPeer.setProperty("PluginParent", (Object)this.getWrappedWindowHandle());
        this.bPeer = true;
        this.xWindow.setVisible(true);
    }

    static /* synthetic */ void access$0(SwtWinOfficeWindow swtWinOfficeWindow, boolean bl) {
        super.setVisible(bl);
    }
}

