/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.connections.pipe;

import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnectionBroadcaster;
import com.sun.star.io.XStreamListener;
import com.sun.star.lib.util.NativeLibraryLoader;
import com.sun.star.uno.RuntimeException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class PipeConnection
implements XConnection,
XConnectionBroadcaster {
    public static final boolean DEBUG = false;
    protected String _aDescription;
    protected long _nPipeHandle;
    protected boolean _bFirstRead = true;
    protected Vector<XStreamListener> _aListeners = new Vector();

    static {
        NativeLibraryLoader.loadLibrary((ClassLoader)PipeConnection.class.getClassLoader(), (String)"jpipe");
    }

    public PipeConnection(String description) throws IOException {
        String aPipeNameParam;
        String aPipeName = null;
        StringTokenizer aTokenizer = new StringTokenizer(description, ",");
        if (aTokenizer.hasMoreTokens()) {
            String aConnType = aTokenizer.nextToken();
            if (!aConnType.equals("pipe")) {
                throw new java.lang.RuntimeException("invalid pipe descriptor: does not start with 'pipe,'");
            }
            aPipeNameParam = aTokenizer.nextToken();
            if (!aPipeNameParam.substring(0, 5).equals("name=")) {
                throw new java.lang.RuntimeException("invalid pipe descriptor: no 'name=' parameter found");
            }
        } else {
            throw new java.lang.RuntimeException("invalid or empty pipe descriptor");
        }
        aPipeName = aPipeNameParam.substring(5);
        try {
            this.createJNI(aPipeName);
        }
        catch (NullPointerException aNPE) {
            throw new IOException(aNPE.getMessage());
        }
        catch (com.sun.star.io.IOException aIOE) {
            throw new IOException(aIOE.getMessage());
        }
        catch (Exception aE) {
            throw new IOException(aE.getMessage());
        }
    }

    public void addStreamListener(XStreamListener aListener) throws RuntimeException {
        this._aListeners.addElement(aListener);
    }

    public void removeStreamListener(XStreamListener aListener) throws RuntimeException {
        this._aListeners.removeElement(aListener);
    }

    private void notifyListeners_open() {
        Enumeration elements = this._aListeners.elements();
        while (elements.hasMoreElements()) {
            XStreamListener xStreamListener = (XStreamListener)elements.nextElement();
            xStreamListener.started();
        }
    }

    private void notifyListeners_close() {
        Enumeration elements = this._aListeners.elements();
        while (elements.hasMoreElements()) {
            XStreamListener xStreamListener = (XStreamListener)elements.nextElement();
            xStreamListener.closed();
        }
    }

    private void notifyListeners_error(com.sun.star.uno.Exception exception) {
        Enumeration elements = this._aListeners.elements();
        while (elements.hasMoreElements()) {
            XStreamListener xStreamListener = (XStreamListener)elements.nextElement();
            xStreamListener.error((Object)exception);
        }
    }

    private native int createJNI(String var1) throws com.sun.star.io.IOException, RuntimeException;

    private native int readJNI(byte[][] var1, int var2) throws com.sun.star.io.IOException, RuntimeException;

    private native void writeJNI(byte[] var1) throws com.sun.star.io.IOException, RuntimeException;

    private native void flushJNI() throws com.sun.star.io.IOException, RuntimeException;

    private native void closeJNI() throws com.sun.star.io.IOException, RuntimeException;

    public int read(byte[][] bytes, int nBytesToRead) throws com.sun.star.io.IOException, RuntimeException {
        if (this._bFirstRead) {
            this._bFirstRead = false;
            this.notifyListeners_open();
        }
        return this.readJNI(bytes, nBytesToRead);
    }

    public void write(byte[] aData) throws com.sun.star.io.IOException, RuntimeException {
        this.writeJNI(aData);
    }

    public void flush() throws com.sun.star.io.IOException, RuntimeException {
        this.flushJNI();
    }

    public void close() throws com.sun.star.io.IOException, RuntimeException {
        this.closeJNI();
        this.notifyListeners_close();
    }

    public String getDescription() throws RuntimeException {
        return this._aDescription;
    }
}

