/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.loader;

import com.sun.star.lib.loader.WinRegKey;
import com.sun.star.lib.loader.WinRegKeyException;
import com.sun.star.lib.loader.WinRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * Exception performing whole class analysis ignored.
 */
public final class InstallationFinder {
    public static final String SYSPROP_NAME = "com.sun.star.lib.loader.unopath";
    private static final String ENVVAR_NAME = "UNO_PATH";
    private static final String SOFFICE = "soffice";

    private InstallationFinder() {
    }

    public static String getPath() {
        String path = null;
        path = InstallationFinder.getPathFromProperty((String)"com.sun.star.lib.loader.unopath");
        if (path == null && (path = InstallationFinder.getPathFromEnvVar((String)"UNO_PATH")) == null) {
            if (InstallationFinder.isWindows()) {
                path = InstallationFinder.getPathFromWindowsRegistry();
            } else {
                path = InstallationFinder.getPathFromPathEnvVar();
                if (path == null && (path = InstallationFinder.getPathFromWhich()) == null) {
                    path = InstallationFinder.getPathFromSVersionFile();
                }
            }
        }
        return path;
    }

    private static String getPathFromProperty(String prop) {
        String path = null;
        try {
            path = System.getProperty(prop);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return path;
    }

    private static String getPathFromEnvVar(String var) {
        String path = null;
        try {
            path = System.getenv(var);
        }
        catch (SecurityException securityException) {
        }
        catch (Error error) {
            // empty catch block
        }
        return path;
    }

    private static String getPathFromWindowsRegistry() {
        String LIBREOKEYNAME = "Software\\LibreOffice\\UNO\\InstallPath";
        String OOOKEYNAME = "Software\\OpenOffice.org\\UNO\\InstallPath";
        String ret = InstallationFinder.getPathFromWindowsRegistry((String)"Software\\OpenOffice.org\\UNO\\InstallPath");
        if (ret != null && !ret.isEmpty()) {
            return ret;
        }
        return InstallationFinder.getPathFromWindowsRegistry((String)"Software\\LibreOffice\\UNO\\InstallPath");
    }

    private static String getPathFromPathEnvVar() {
        String PATH_ENVVAR_NAME = "PATH";
        String path = null;
        String str = null;
        try {
            str = System.getenv("PATH");
        }
        catch (SecurityException e) {
            return null;
        }
        catch (Error err) {
            return null;
        }
        if (str != null) {
            StringTokenizer tokens = new StringTokenizer(str, File.pathSeparator);
            while (tokens.hasMoreTokens()) {
                File file = new File(tokens.nextToken(), "soffice");
                try {
                    if (!file.exists()) continue;
                    try {
                        path = file.getCanonicalFile().getParent();
                        if (path == null) continue;
                        break;
                    }
                    catch (IOException e) {
                        System.err.println("com.sun.star.lib.loader.InstallationFinder::getPathFromEnvVar: bad path: " + e);
                    }
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
        return path;
    }

    /*
     * Exception decompiling
     */
    private static String getPathFromWhich() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 21[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String getPathFromSVersionFile() {
        String path;
        block21: {
            String SVERSION = ".sversionrc";
            String VERSIONS = "[Versions]";
            path = null;
            try {
                Vector<String> lines;
                block23: {
                    File fSVersion = new File(System.getProperty("user.home"), ".sversionrc");
                    if (!fSVersion.exists()) break block21;
                    lines = new Vector<String>();
                    BufferedReader br = null;
                    try {
                        try {
                            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fSVersion), "UTF-8"));
                            String line = null;
                            while ((line = br.readLine()) != null && !line.equals("[Versions]")) {
                            }
                            while ((line = br.readLine()) != null && line.length() != 0) {
                                if (line.startsWith(";")) continue;
                                lines.add(line);
                            }
                        }
                        catch (IOException e) {
                            System.err.println("com.sun.star.lib.loader.InstallationFinder::getPathFromSVersionFile: reading .sversionrc file failed: " + e);
                            if (br != null) {
                                try {
                                    br.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block23;
                        }
                    }
                    catch (Throwable throwable) {
                        if (br != null) {
                            try {
                                br.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                int i = lines.size() - 1;
                while (i >= 0) {
                    StringTokenizer tokens = new StringTokenizer((String)lines.elementAt(i), "=");
                    if (tokens.countTokens() == 2) {
                        String key = tokens.nextToken();
                        String url = tokens.nextToken();
                        path = InstallationFinder.getCanonicalPathFromFileURL((String)url);
                        if (path != null) break;
                    }
                    --i;
                }
            }
            catch (SecurityException e) {
                return null;
            }
        }
        return path;
    }

    /*
     * Unable to fully structure code
     */
    private static String getCanonicalPathFromFileURL(String oooUrl) {
        block21: {
            block22: {
                prefix = "file://";
                if (oooUrl.length() < prefix.length() || !oooUrl.substring(0, prefix.length()).toLowerCase().equals(prefix)) {
                    return null;
                }
                buf = new StringBuffer(prefix);
                n = oooUrl.indexOf(47, prefix.length());
                if (n < 0) {
                    n = oooUrl.length();
                }
                if ((host = oooUrl.substring(prefix.length(), n)).length() != 0 && !host.toLowerCase().equals("localhost")) {
                    return null;
                }
                buf.append(host);
                if (n != oooUrl.length()) ** GOTO lbl52
                buf.append('/');
                break block22;
lbl-1000:
                // 1 sources

                {
                    buf.append('/');
                    n2 = oooUrl.indexOf(47, ++n);
                    if (n2 < 0) {
                        n2 = oooUrl.length();
                    }
                    while (n < n2) {
                        c = oooUrl.charAt(n);
                        switch (c) {
                            case '%': {
                                bytes = new byte[(n2 - n) / 3];
                                len = 0;
                                while (oooUrl.length() - n > 2 && oooUrl.charAt(n) == '%') {
                                    d1 = Character.digit(oooUrl.charAt(n + 1), 16);
                                    d2 = Character.digit(oooUrl.charAt(n + 2), 16);
                                    if (d1 < 0 || d2 < 0) break;
                                    d = 16 * d1 + d2;
                                    if (d == 47) {
                                        return null;
                                    }
                                    bytes[len++] = (byte)d;
                                    n += 3;
                                }
                                try {
                                    s = new String(bytes, 0, len, "UTF-8");
                                }
                                catch (UnsupportedEncodingException e) {
                                    return null;
                                }
                                buf.append(s);
                                break;
                            }
                            case '#': {
                                break block12;
                            }
                            default: {
                                buf.append(c);
                                ++n;
                            }
                        }
                    }
lbl52:
                    // 2 sources

                    ** while (n < oooUrl.length())
                }
            }
            try {
                url = new URL(buf.toString());
            }
            catch (MalformedURLException e) {
                return null;
            }
            path = url.getFile();
            fragment = url.getRef();
            if (fragment != null) {
                path = String.valueOf(path) + '#' + fragment;
            }
            ret = null;
            file = new File(path, "soffice");
            try {
                if (!file.isAbsolute() || !file.exists()) break block21;
                try {
                    ret = file.getCanonicalFile().getParent();
                }
                catch (IOException e) {
                    return null;
                }
            }
            catch (SecurityException e) {
                return null;
            }
        }
        return ret;
    }

    private static String getPathFromWindowsRegistry2(String subKeyName) {
        String path = null;
        try {
            WinRegKey key = new WinRegKey("HKEY_CURRENT_USER", subKeyName);
            path = key.getStringValue("");
        }
        catch (WinRegKeyException e) {
            try {
                WinRegKey key = new WinRegKey("HKEY_LOCAL_MACHINE", subKeyName);
                path = key.getStringValue("");
            }
            catch (WinRegKeyException winRegKeyException) {}
        }
        catch (UnsatisfiedLinkError ex) {
            System.err.println("com.sun.star.lib.loader.InstallationFinder::getPathFromWindowsRegistry: reading key from Windows Registry failed: " + ex);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return path;
    }

    public static boolean isOooPathValid(File installDir) {
        return InstallationFinder.isProgramPathValid((File)new File(installDir, "program"));
    }

    public static boolean isProgramPathValid(File programDir) {
        File f = InstallationFinder.isWindows() ? new File(programDir, "soffice.exe") : new File(programDir, "soffice");
        return f.isFile();
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().startsWith("win");
    }

    private static String getPathFromWindowsRegistry(String subKeyName) {
        String path = null;
        try {
            path = WinRegistry.readString((int)-2147483647, (String)subKeyName, (String)"");
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        if (path == null) {
            try {
                path = WinRegistry.readString((int)-2147483646, (String)subKeyName, (String)"");
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return path;
    }
}

