/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.loader;

import com.modeliosoft.modelio.edition.libreoffice.plugin.LibreOfficeEditors;
import com.sun.star.lib.loader.InstallationFinder;
import com.sun.star.lib.loader.Loader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * Exception performing whole class analysis ignored.
 */
public final class Loader {
    private static List<URL> m_urls = null;

    private Loader() {
    }

    public static synchronized List<URL> getUnoClassPath() throws IOException {
        String CLASSESDIR = "classes";
        String JUHJAR = "juh.jar";
        if (m_urls == null) {
            String path;
            ArrayList<URL> urls = new ArrayList<URL>();
            String classpath = null;
            try {
                classpath = System.getProperty("java.class.path");
            }
            catch (SecurityException e) {
                LibreOfficeEditors.LOG.warning("com.sun.star.lib.loader.Loader::getUnoClassPath(): cannot get system property java.class.path: ");
                LibreOfficeEditors.LOG.warning((Throwable)e);
            }
            if (classpath != null) {
                Loader.addUrls(urls, (String)classpath, (String)File.pathSeparator);
            }
            if ((path = InstallationFinder.getPath()) != null) {
                File fClassesDir = new File(path, "classes");
                File fJuh = new File(fClassesDir, "juh.jar");
                if (fJuh.exists()) {
                    try {
                        URL[] clurls = new URL[]{fJuh.toURI().toURL()};
                        URLClassLoader cl = new URLClassLoader(clurls, ClassLoader.getSystemClassLoader());
                        Class<?> c = cl.loadClass("com.sun.star.comp.helper.UnoInfo");
                        Method m = c.getMethod("getJars", null);
                        URL[] jarurls = (URL[])m.invoke(null, null);
                        int i = 0;
                        while (i < jarurls.length) {
                            urls.add(jarurls[i]);
                            ++i;
                        }
                    }
                    catch (MalformedURLException e) {
                        LibreOfficeEditors.LOG.warning((Throwable)e);
                    }
                    catch (ClassNotFoundException e) {
                        LibreOfficeEditors.LOG.warning((Throwable)e);
                    }
                    catch (NoSuchMethodException e) {
                        LibreOfficeEditors.LOG.warning((Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        LibreOfficeEditors.LOG.warning((Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        LibreOfficeEditors.LOG.warning((Throwable)e);
                    }
                } else {
                    Loader.callUnoinfo((String)path, urls);
                }
            } else {
                LibreOfficeEditors.LOG.warning("No LibreOffice/OpenOffice installation found.");
                return null;
            }
            Loader.checkUrls(urls);
            m_urls = urls;
        }
        return m_urls;
    }

    private static void addUrls(List<URL> urls, String data, String delimiter) {
        StringTokenizer tokens = new StringTokenizer(data, delimiter);
        while (tokens.hasMoreTokens()) {
            String nextToken = tokens.nextToken();
            try {
                urls.add(new File(nextToken).toURI().toURL());
            }
            catch (MalformedURLException e) {
                LibreOfficeEditors.LOG.warning("com.sun.star.lib.loader.Loader::addUrls(): bad '" + nextToken + "' pathname: " + e);
            }
        }
    }

    private static void callUnoinfo(String path, List<URL> urls) throws IOException {
        String s;
        int ev;
        int code;
        Process p = Runtime.getRuntime().exec(new String[]{new File(path, "unoinfo").getPath(), "java"});
        new Drain(p.getErrorStream()).start();
        byte[] buf = new byte[1000];
        int n = 0;
        try {
            InputStream s2 = p.getInputStream();
            code = s2.read();
            while (true) {
                int k;
                if (n == buf.length) {
                    if (n > 0x3FFFFFFF) {
                        throw new IOException("too much unoinfo output");
                    }
                    byte[] buf2 = new byte[2 * n];
                    int i = 0;
                    while (i < n) {
                        buf2[i] = buf[i];
                        ++i;
                    }
                    buf = buf2;
                }
                if ((k = s2.read(buf, n, buf.length - n)) != -1) {
                    n += k;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new IOException("com.sun.star.lib.loader.Loader::callUnoinfo: reading unoinfo output: " + e, e);
        }
        try {
            ev = p.waitFor();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LibreOfficeEditors.LOG.error("com.sun.star.lib.loader.Loader::callUnoinfo: waiting for unoinfo: " + e);
            return;
        }
        if (ev != 0) {
            throw new IOException("com.sun.star.lib.loader.Loader::callUnoinfo: unoinfo exit value " + n);
        }
        if (code == 48) {
            s = new String(buf);
        } else if (code == 49) {
            try {
                s = new String(buf, "UTF-16LE");
            }
            catch (UnsupportedEncodingException e) {
                throw new IOException("com.sun.star.lib.loader.Loader::callUnoinfo(): transforming unoinfo output: " + e);
            }
        } else {
            throw new IOException("Bad unoinfo output code:" + code);
        }
        Loader.addUrls(urls, (String)s, (String)"\u0000");
    }

    private static void checkUrls(List<URL> vec) throws IOException {
        for (URL url : vec) {
            if (!url.getProtocol().equals("file")) continue;
            try {
                File f = new File(url.toURI());
                if (f.exists()) continue;
                String msg = f.getPath().contains("unoil.jar") ? LibreOfficeEditors.I18N.getMessage("unoilJarMissing", new String[]{f.getCanonicalPath()}) : LibreOfficeEditors.I18N.getMessage("classpathFileMissing", new String[]{f.getCanonicalPath()});
                throw new FileNotFoundException(msg);
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
    }
}

