/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.loader;

import com.sun.star.lib.loader.WinRegKeyException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;

/*
 * Exception performing whole class analysis ignored.
 */
final class WinRegKey {
    private String m_rootKeyName;
    private String m_subKeyName;

    static {
        try {
            ClassLoader cl = WinRegKey.class.getClassLoader();
            InputStream is = cl.getResourceAsStream("win/unowinreg.dll");
            if (is != null) {
                BufferedInputStream istream = new BufferedInputStream(is);
                File libfile = File.createTempFile("unowinreg", ".dll");
                libfile.deleteOnExit();
                BufferedOutputStream ostream = new BufferedOutputStream(new FileOutputStream(libfile));
                int bsize = 2048;
                int n = 0;
                byte[] buffer = new byte[bsize];
                while ((n = istream.read(buffer, 0, bsize)) != -1) {
                    ostream.write(buffer, 0, n);
                }
                istream.close();
                ostream.close();
                System.load(libfile.getPath());
            } else {
                System.loadLibrary("unowinreg");
            }
        }
        catch (Exception e) {
            System.err.println("com.sun.star.lib.loader.WinRegKey: loading of native library failed!" + e);
        }
    }

    private static native boolean winreg_RegOpenClassesRoot(long[] var0);

    private static native boolean winreg_RegOpenCurrentConfig(long[] var0);

    private static native boolean winreg_RegOpenCurrentUser(long[] var0);

    private static native boolean winreg_RegOpenLocalMachine(long[] var0);

    private static native boolean winreg_RegOpenUsers(long[] var0);

    private static native boolean winreg_RegOpenKeyEx(long var0, String var2, long[] var3);

    private static native boolean winreg_RegCloseKey(long var0);

    private static native boolean winreg_RegQueryValueEx(long var0, String var2, long[] var3, byte[] var4, long[] var5);

    private static native boolean winreg_RegQueryInfoKey(long var0, long[] var2, long[] var3, long[] var4, long[] var5, long[] var6, long[] var7);

    public WinRegKey(String rootKeyName, String subKeyName) {
        this.m_rootKeyName = rootKeyName;
        this.m_subKeyName = subKeyName;
    }

    public String getStringValue(String valueName) throws WinRegKeyException {
        byte[] data = this.getValue(valueName);
        return new String(data, 0, data.length - 1);
    }

    private byte[] getValue(String valueName) throws WinRegKeyException {
        byte[] result = null;
        long[] hkey = new long[1];
        boolean bRet = false;
        long[] hroot = new long[1];
        if (this.m_rootKeyName.equals("HKEY_CLASSES_ROOT")) {
            bRet = WinRegKey.winreg_RegOpenClassesRoot((long[])hroot);
        } else if (this.m_rootKeyName.equals("HKEY_CURRENT_CONFIG")) {
            bRet = WinRegKey.winreg_RegOpenCurrentConfig((long[])hroot);
        } else if (this.m_rootKeyName.equals("HKEY_CURRENT_USER")) {
            bRet = WinRegKey.winreg_RegOpenCurrentUser((long[])hroot);
        } else if (this.m_rootKeyName.equals("HKEY_LOCAL_MACHINE")) {
            bRet = WinRegKey.winreg_RegOpenLocalMachine((long[])hroot);
        } else if (this.m_rootKeyName.equals("HKEY_USERS")) {
            bRet = WinRegKey.winreg_RegOpenUsers((long[])hroot);
        } else {
            throw new WinRegKeyException("unknown root registry key!");
        }
        if (!bRet) {
            throw new WinRegKeyException("opening root registry key failed!");
        }
        if (!WinRegKey.winreg_RegOpenKeyEx((long)hroot[0], (String)this.m_subKeyName, (long[])hkey)) {
            if (!WinRegKey.winreg_RegCloseKey((long)hroot[0])) {
                throw new WinRegKeyException("opening registry key and releasing root registry key handle failed!");
            }
            throw new WinRegKeyException("opening registry key failed!");
        }
        long[] subkeys = new long[1];
        long[] maxSubkeyLen = new long[1];
        long[] values = new long[1];
        long[] maxValueNameLen = new long[1];
        long[] maxValueLen = new long[1];
        long[] secDescriptor = new long[1];
        if (!WinRegKey.winreg_RegQueryInfoKey((long)hkey[0], (long[])subkeys, (long[])maxSubkeyLen, (long[])values, (long[])maxValueNameLen, (long[])maxValueLen, (long[])secDescriptor)) {
            if (!WinRegKey.winreg_RegCloseKey((long)hkey[0]) || !WinRegKey.winreg_RegCloseKey((long)hroot[0])) {
                throw new WinRegKeyException("retrieving information about the registry key and releasing registry key handles failed!");
            }
            throw new WinRegKeyException("retrieving information about the registry key failed!");
        }
        long[] type = new long[]{0L};
        byte[] buffer = new byte[(int)maxValueLen[0]];
        long[] size = new long[]{buffer.length};
        if (!WinRegKey.winreg_RegQueryValueEx((long)hkey[0], (String)valueName, (long[])type, (byte[])buffer, (long[])size)) {
            if (!WinRegKey.winreg_RegCloseKey((long)hkey[0]) || !WinRegKey.winreg_RegCloseKey((long)hroot[0])) {
                throw new WinRegKeyException("retrieving data for the specified value name and releasing registry key handles failed!");
            }
            throw new WinRegKeyException("retrieving data for the specified value name failed!");
        }
        if (!WinRegKey.winreg_RegCloseKey((long)hkey[0]) || !WinRegKey.winreg_RegCloseKey((long)hroot[0])) {
            throw new WinRegKeyException("releasing registry key handles failed!");
        }
        result = new byte[(int)size[0]];
        System.arraycopy(buffer, 0, result, 0, (int)size[0]);
        return result;
    }
}

