/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.app.newProject;

import com.modeliosoft.modelio.api.model.analyst.IAnalystProject;
import com.modeliosoft.modelio.api.model.analyst.IDictionary;
import com.modeliosoft.modelio.api.model.analyst.IPropertyContainer;
import com.modeliosoft.modelio.api.model.analyst.IPropertySet;
import com.modeliosoft.modelio.api.model.analyst.IPropertyType;
import com.modeliosoft.modelio.api.model.analyst.IRequirementContainer;
import com.modeliosoft.modelio.api.model.analyst.IRequirementElement;
import com.modeliosoft.modelio.api.model.extension.IProject;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.utils.StereotypeNotFoundException;
import com.modeliosoft.modelio.app.plugin.AppModelio;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class AnalystModelFixer {
    private static final String BUSINESS_RULE_CONTAINER_STEREOTYPE = "business_rule_container";
    private static final String GOAL_CONTAINER_STEREOTYPE = "goal_container";
    private static final String REQUIREMENT_CONTAINER_STEREOTYPE = "requirement_container";
    private static final String BUSINESS_RULE_STEREOTYPE = "business_rule";
    private static final String GOAL_STEREOTYPE = "goal";
    private static final String REQUIREMENT_STEREOTYPE = "requirement";
    private static final String DICTIONARY_STEREOTYPE = "dictionary";

    public void execute(IProgressMonitor monitor, IModelingSession session) {
        ITransaction t = null;
        try {
            try {
                t = session.getTransactionManager().createTransaction("Migrate analyst model");
                session.getAccessManager().setUser(0);
                this.migrateModel(session);
                session.getTransactionManager().commit(t);
                t = null;
            }
            catch (InvalidTransactionException e) {
                t = null;
                if (session.isOpen()) {
                    session.getAccessManager().setUser(1);
                    if (t != null) {
                        session.getTransactionManager().rollback(t);
                    }
                }
            }
        }
        finally {
            if (session.isOpen()) {
                session.getAccessManager().setUser(1);
                if (t != null) {
                    session.getTransactionManager().rollback(t);
                }
            }
        }
    }

    private IAnalystProject createAnalystProject(IModelingSession session, IProject project) {
        IAnalystProject analystProject = session.getModelFactory().createAnalystProject();
        analystProject.setName(project.getName());
        project.setRootRequirement(analystProject);
        return analystProject;
    }

    private IRequirementContainer createBusinessRuleRoot(IModelingSession session, IAnalystProject analystProject) {
        IRequirementContainer c = session.getModelFactory().createRequirementContainer();
        c.setName(AppModelio.I18N.getMessage("ProjectMigrator.AnalystRootName.BusinessRule", new String[0]));
        analystProject.setBusinessRuleRoot(c);
        this.putStereotype(session, (IModelElement)c, BUSINESS_RULE_CONTAINER_STEREOTYPE);
        return c;
    }

    private IDictionary createDictionaryRoot(IModelingSession session, IAnalystProject analystProject) {
        IDictionary c = session.getModelFactory().createDictionary();
        c.setName(AppModelio.I18N.getMessage("ProjectMigrator.AnalystRootName.Dictionary", new String[0]));
        analystProject.setDictionaryRoot(c);
        this.putStereotype(session, (IModelElement)c, DICTIONARY_STEREOTYPE);
        return c;
    }

    private IRequirementContainer createGoalRoot(IModelingSession session, IAnalystProject analystProject) {
        IRequirementContainer c = session.getModelFactory().createRequirementContainer();
        c.setName(AppModelio.I18N.getMessage("ProjectMigrator.AnalystRootName.Goal", new String[0]));
        analystProject.setGoalRoot(c);
        this.putStereotype(session, (IModelElement)c, GOAL_CONTAINER_STEREOTYPE);
        return c;
    }

    private void createPropertyContainer(IModelingSession session, IAnalystProject analystProject) {
        IPropertyContainer c = session.getModelFactory().createPropertyContainer();
        c.setName(AppModelio.I18N.getMessage("ProjectMigrator.AnalystRootName.PropertyContainer", new String[0]));
        analystProject.setProperties(c);
    }

    private IRequirementContainer createRequirementRoot(IModelingSession session, IAnalystProject analystProject) {
        IRequirementContainer c = session.getModelFactory().createRequirementContainer();
        c.setName(AppModelio.I18N.getMessage("ProjectMigrator.AnalystRootName.Requirement", new String[0]));
        analystProject.setRequirementRoot(c);
        this.putStereotype(session, (IModelElement)c, REQUIREMENT_CONTAINER_STEREOTYPE);
        return c;
    }

    private void fixPropertyContainerContent(IModelingSession session, IAnalystProject analystProject) {
        IPropertyContainer container = analystProject.getProperties();
        List types = session.getModel().findByClass(IPropertyType.class);
        for (IElement el : types) {
            IPropertyType type = (IPropertyType)el;
            container.addDefinedType(type);
        }
        List propertySets = session.getModel().findByClass(IPropertySet.class);
        for (IElement el : propertySets) {
            IPropertySet type = (IPropertySet)el;
            container.addDefinedPropertySet(type);
        }
    }

    private void migrateModel(IModelingSession session) {
        IProject project = session.getModel().getProject();
        IAnalystProject analystProject = project.getRootRequirement();
        if (analystProject == null) {
            analystProject = this.createAnalystProject(session, project);
            this.createPropertyContainer(session, analystProject);
            this.createBusinessRuleRoot(session, analystProject);
            this.createGoalRoot(session, analystProject);
            this.createRequirementRoot(session, analystProject);
            this.createDictionaryRoot(session, analystProject);
        } else {
            if (analystProject.getProperties() == null) {
                this.createPropertyContainer(session, analystProject);
            }
            this.fixPropertyContainerContent(session, analystProject);
            this.sortAnalystContainers(session, analystProject);
        }
    }

    private void putStereotype(IModelingSession session, IModelElement c, String type) {
        try {
            c.addExtension(session.getModel().getMetamodelExtensions().getStereotype(c.getClass(), type));
        }
        catch (StereotypeNotFoundException e) {
            LOG.error((String)"org.modelio.app", (String)e.getLocalizedMessage());
        }
    }

    private void sortAnalystContainers(IModelingSession session, IAnalystProject analystProject) {
        IRequirementContainer hiddenRoot = analystProject.getRequirementRoot();
        IRequirementContainer newGoalRoot = analystProject.getGoalRoot();
        IRequirementContainer newRuleRoot = analystProject.getBusinessRuleRoot();
        IRequirementContainer newReqRoot = null;
        ArrayList<IRequirementContainer> oldRoots = new ArrayList<IRequirementContainer>();
        ArrayList<Object> reqElements = new ArrayList<Object>();
        ArrayList<IRequirementContainer> goalElements = new ArrayList<IRequirementContainer>();
        ArrayList<IRequirementContainer> ruleElements = new ArrayList<IRequirementContainer>();
        if (hiddenRoot != null) {
            hiddenRoot.setName(AppModelio.I18N.getMessage("ProjectMigrator.AnalystRootName.Requirement", new String[0]));
            oldRoots.addAll((Collection<IRequirementContainer>)hiddenRoot.getOwned());
        } else {
            for (IElement iElement : session.getModel().findByClass(IRequirementElement.class)) {
                IRequirementContainer rq;
                if (!(iElement instanceof IRequirementContainer) || (rq = (IRequirementContainer)iElement).getOwner() != null) continue;
                oldRoots.add(rq);
            }
        }
        for (IRequirementElement iRequirementElement : oldRoots) {
            if (iRequirementElement instanceof IRequirementContainer) {
                IRequirementContainer c = (IRequirementContainer)iRequirementElement;
                if (c.isStereotyped(BUSINESS_RULE_CONTAINER_STEREOTYPE)) {
                    if (newRuleRoot == null) {
                        c.setOwner(null);
                        analystProject.setBusinessRuleRoot(c);
                        newRuleRoot = c;
                        continue;
                    }
                    ruleElements.add(c);
                    continue;
                }
                if (c.isStereotyped(BUSINESS_RULE_STEREOTYPE)) {
                    ruleElements.add(c);
                    continue;
                }
                if (c.isStereotyped(GOAL_CONTAINER_STEREOTYPE)) {
                    if (newGoalRoot == null) {
                        c.setOwner(null);
                        analystProject.setGoalRoot(c);
                        newGoalRoot = c;
                        continue;
                    }
                    goalElements.add(c);
                    continue;
                }
                if (c.isStereotyped(GOAL_STEREOTYPE)) {
                    goalElements.add(c);
                    continue;
                }
                if (c.isStereotyped(REQUIREMENT_CONTAINER_STEREOTYPE)) {
                    if (newReqRoot == null) {
                        analystProject.setRequirementRoot(c);
                        c.setOwner(null);
                        newReqRoot = c;
                        continue;
                    }
                    reqElements.add(c);
                    continue;
                }
                if (c.isStereotyped(REQUIREMENT_STEREOTYPE)) {
                    reqElements.add(c);
                    continue;
                }
                reqElements.add(iRequirementElement);
                continue;
            }
            reqElements.add(iRequirementElement);
        }
        if (newGoalRoot == null) {
            newGoalRoot = this.createGoalRoot(session, analystProject);
        }
        if (newReqRoot == null) {
            newReqRoot = this.createRequirementRoot(session, analystProject);
        }
        if (newRuleRoot == null) {
            newRuleRoot = this.createBusinessRuleRoot(session, analystProject);
        }
        for (IRequirementElement iRequirementElement : reqElements) {
            newReqRoot.addOwned(iRequirementElement);
        }
        for (IRequirementElement iRequirementElement : goalElements) {
            newGoalRoot.addOwned(iRequirementElement);
        }
        for (IRequirementElement iRequirementElement : ruleElements) {
            newRuleRoot.addOwned(iRequirementElement);
        }
        if (newReqRoot != null && hiddenRoot != null) {
            session.getModelFactory().deleteElement((IElement)hiddenRoot);
        }
    }
}

