/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.app.newProject;

import com.modeliosoft.modelio.app.newProject.ProjectCreator;
import com.modeliosoft.modelio.app.newProject.gui.ProjectCreationDataModel;
import com.modeliosoft.modelio.app.newProject.gui.ProjectCreationDialog;
import com.modeliosoft.modelio.app.plugin.AppModelio;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.internal.app.IProject;
import com.modeliosoft.modelio.internal.app.IProjectSpace;
import com.modeliosoft.modelio.internal.app.services.App;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class NewProjectHandler
implements IHandler {
    public void addHandlerListener(IHandlerListener arg0) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell parentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        App app = App.getInstance();
        O.getDefault().getPickingProviderService().abortPicking();
        IProject openedProject = app.getOpenedProject();
        if (openedProject != null) {
            String[] buttonLabels = new String[]{AppModelio.I18N.getString("SaveAndClose"), AppModelio.I18N.getString("CloseNoSave"), AppModelio.I18N.getString("Cancel")};
            MessageDialog dlg = new MessageDialog(parentShell, AppModelio.I18N.getString("NewProjectCloseConfirmTitle"), null, AppModelio.I18N.getString("NewProjectCloseConfirmMsg"), 3, buttonLabels, 0);
            dlg.setBlockOnOpen(true);
            int answer = dlg.open();
            switch (answer) {
                case 0: {
                    openedProject.getSession().save();
                    app.closeProject();
                    break;
                }
                case 1: {
                    app.closeProject();
                    break;
                }
                case 2: {
                    return null;
                }
                default: {
                    return null;
                }
            }
        }
        this.closeIntroPart();
        ProjectCreationDataModel dataModel = this.promptUser();
        if (dataModel != null) {
            ProjectCreator projectCreator = new ProjectCreator(App.getInstance().getWorkspace(), dataModel);
            IProgressService service = PlatformUI.getWorkbench().getProgressService();
            try {
                service.run(false, false, (IRunnableWithProgress)projectCreator);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener arg0) {
    }

    private ProjectCreationDataModel promptUser() {
        Shell parentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ProjectCreationDataModel dataModel = new ProjectCreationDataModel();
        ProjectCreationDialog dialog = new ProjectCreationDialog(parentShell, dataModel);
        String defaultName = AppModelio.I18N.getString("ProjectDefaultName");
        int index = 1;
        while (App.getInstance().getWorkspace().getProjectSpace(String.valueOf(defaultName) + index) != null) {
            ++index;
        }
        dataModel.setProjectName(String.valueOf(defaultName) + index);
        dialog.setBlockOnOpen(true);
        int code = dialog.open();
        if (code == 0) {
            if (App.getInstance().getWorkspace().getProjectSpace(dataModel.getProjectName()) != null) {
                boolean answer = MessageDialog.openQuestion((Shell)parentShell, (String)AppModelio.I18N.getMessage("ProjectAlreadyExistsTitle", new String[0]), (String)AppModelio.I18N.getMessage("ProjectAlreadyExistsDesc", new String[0]));
                if (answer) {
                    IProjectSpace existingProject = App.getInstance().getWorkspace().getProjectSpace(dataModel.getProjectName());
                    App.getInstance().getWorkspace().deleteProjectSpace(existingProject);
                    return dataModel;
                }
                return this.promptUser();
            }
            String normalizedName = dataModel.getProjectName();
            while (normalizedName.endsWith(" ") || normalizedName.endsWith(".")) {
                normalizedName = normalizedName.substring(0, normalizedName.length() - 1);
            }
            dataModel.setProjectName(normalizedName);
            return dataModel;
        }
        return null;
    }

    private void closeIntroPart() {
        IViewReference[] refs;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        IViewReference[] iViewReferenceArray = refs = page.getViewReferences();
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference ref = iViewReferenceArray[n2];
            if (ref.getId().equals("org.eclipse.ui.internal.introview")) {
                page.hideView(ref);
            }
            ++n2;
        }
    }
}

