/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.app.newProject;

import com.modeliosoft.modelio.api.mdac.MdacException;
import com.modeliosoft.modelio.api.model.extension.IProject;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.statik.IPackage;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.api.utils.exceptions.InvalidModelManipulationException;
import com.modeliosoft.modelio.app.newProject.AnalystModelFixer;
import com.modeliosoft.modelio.app.newProject.gui.ModuleAdapter;
import com.modeliosoft.modelio.app.newProject.gui.ProjectCreationDataModel;
import com.modeliosoft.modelio.app.plugin.AppModelio;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.OfpFile;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.jni.CannotCopyRepairBaseException;
import com.modeliosoft.modelio.core.jni.CannotReadRepairBaseException;
import com.modeliosoft.modelio.core.jni.IProjectPropertiesService;
import com.modeliosoft.modelio.core.model.ModelServices;
import com.modeliosoft.modelio.core.transaction.CreateTransactionForbiddenException;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.core.transaction.NoTransactionOpenException;
import com.modeliosoft.modelio.core.transaction.NotCurrentTransactionException;
import com.modeliosoft.modelio.internal.app.IProjectSpace;
import com.modeliosoft.modelio.internal.app.IWorkspace;
import com.modeliosoft.modelio.internal.app.InvalidProjectSpaceException;
import com.modeliosoft.modelio.internal.app.ProjectException;
import com.modeliosoft.modelio.internal.app.services.App;
import com.modeliosoft.modelio.mdainfra.mdacs.core.IMdacManager;
import com.modeliosoft.modelio.mdainfra.mdacs.core.MdacManager;
import com.modeliosoft.modelio.mdainfra.mdacs.deployment.LocalModuleCreator;
import com.modeliosoft.modelio.mdainfra.mdacs.deployment.MdacDeployer;
import com.modeliosoft.modelio.mdainfra.mdacs.store.MdacArchiveInfo;
import com.modeliosoft.modelio.mdainfra.mdacs.store.MdacArchiveRepository;
import com.modeliosoft.modelio.mdainfra.mdacs.store.ModuleArchiveSorter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ProjectCreator
implements IRunnableWithProgress {
    private IWorkspace workspace = null;
    private ProjectCreationDataModel data = null;

    public ProjectCreator(IWorkspace workspace, ProjectCreationDataModel data) {
        this.data = data;
        this.workspace = workspace;
    }

    public void run(IProgressMonitor aMonitor) throws InvocationTargetException, InterruptedException {
        block11: {
            try {
                if (this.data.getProjectName() == null || this.data.getProjectName().isEmpty()) break block11;
                ArrayList<MdacArchiveInfo> adaptersToInstall = new ArrayList<MdacArchiveInfo>();
                for (ModuleAdapter adapter : this.data.getModuleAdapters()) {
                    if (!adapter.isDeploy()) continue;
                    adaptersToInstall.add(adapter.getMdac());
                }
                SubMonitor monitor = SubMonitor.convert((IProgressMonitor)aMonitor, (String)AppModelio.I18N.getMessage("NewProjectHandler.begintask", new String[]{this.data.getProjectName()}), (int)(5 + adaptersToInstall.size()));
                monitor.subTask(AppModelio.I18N.getMessage("NewProjectHandler.creatingProject", new String[0]));
                IProjectSpace projectSpace = this.createProjectSpace(this.workspace, this.data);
                this.createOfpFile(monitor, new File(projectSpace.getDataDirectory(), String.valueOf(projectSpace.getName()) + ".ofpx"));
                if (monitor.isCanceled()) {
                    this.workspace.deleteProjectSpace(projectSpace);
                    this.workspace.refreshProjects();
                    return;
                }
                monitor.worked(1);
                monitor.subTask(AppModelio.I18N.getString("NewProjectHandler.openingProject"));
                try {
                    App.getInstance().openProject(projectSpace);
                }
                catch (ProjectException e) {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)AppModelio.I18N.getMessage("OpenProjectHandler.OpenFailedTitle", new String[]{projectSpace.getName()}), (String)AppModelio.I18N.getMessage("OpenProjectHandler.OpenFailedMsg", new String[]{projectSpace.getName(), e.getLocalizedMessage()}));
                    return;
                }
                catch (IOException e) {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)AppModelio.I18N.getMessage("OpenProjectHandler.OpenFailedTitle", new String[]{projectSpace.getName()}), (String)AppModelio.I18N.getMessage("OpenProjectHandler.OpenFailedMsg", new String[]{projectSpace.getName(), e.getLocalizedMessage()}));
                }
                monitor.worked(1);
                monitor.subTask(AppModelio.I18N.getString("NewProjectHandler.configuringProject"));
                String installPath = Platform.getInstallLocation().getURL().getPath();
                IModelingSession sess = App.getInstance().getOpenedProject().getSession();
                LocalModuleCreator c = new LocalModuleCreator(sess);
                c.execute();
                monitor.worked(1);
                MdacManager mdacManager = new MdacManager(sess);
                File modulesPath = new File(installPath, "mdastore");
                this.deployCoreModule(sess, mdacManager, modulesPath, monitor);
                monitor.subTask(AppModelio.I18N.getString("NewProjectHandler.CreatingAnalystModel"));
                AnalystModelFixer analystProject = new AnalystModelFixer();
                analystProject.execute((IProgressMonitor)monitor, sess);
                this.deploySelectedModules(sess, mdacManager, adaptersToInstall, monitor);
                this.initializeModel(monitor, sess);
                sess.save();
                monitor.worked(1);
            }
            catch (CannotCopyRepairBaseException e) {
                this.workspace.refreshProjects();
                IProjectSpace projectSpace = this.workspace.getProjectSpace(this.data.getProjectName());
                if (projectSpace != null) {
                    this.workspace.deleteProjectSpace(projectSpace);
                }
                MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)AppModelio.I18N.getString("NewProjectHandler.CannotCreateProject"), (String)AppModelio.I18N.getMessage("NewProjectHandler.CannotCopyRepairBaseException", new String[]{this.data.getProjectName()}));
                AppModelio.LOG.error((Throwable)e);
            }
            catch (CannotReadRepairBaseException e) {
                this.workspace.refreshProjects();
                IProjectSpace projectSpace = this.workspace.getProjectSpace(this.data.getProjectName());
                if (projectSpace != null) {
                    this.workspace.deleteProjectSpace(projectSpace);
                }
                MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)AppModelio.I18N.getString("NewProjectHandler.CannotCreateProject"), (String)AppModelio.I18N.getMessage("NewProjectHandler.CannotreadRepairBaseException", new String[]{this.data.getProjectName()}));
                AppModelio.LOG.error((Throwable)e);
            }
            catch (InvalidProjectSpaceException e) {
                AppModelio.LOG.error((Throwable)e);
                this.workspace.refreshProjects();
                MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)AppModelio.I18N.getString("NewProjectHandler.CannotCreateProject"), (String)e.getLocalizedMessage());
            }
        }
    }

    private void createOfpFile(SubMonitor monitor, File projectFile) throws CannotCopyRepairBaseException, CannotReadRepairBaseException {
        OfpFile ofpFile = new OfpFile(projectFile);
        try {
            ofpFile.createBase(this.data.getProjectName());
        }
        catch (IOException e) {
            MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)AppModelio.I18N.getMessage("NewProjectHandler.creatingProject", new String[]{this.data.getOfpToMigrate()}), (String)e.getLocalizedMessage());
            monitor.setCanceled(true);
        }
    }

    private IProjectSpace createProjectSpace(IWorkspace aWorkspace, ProjectCreationDataModel params) throws InvalidProjectSpaceException {
        IProjectSpace createdProjectSpace = null;
        createdProjectSpace = params.changeProjectLocationPath() ? aWorkspace.createRedirectedProjectSpace(params.getProjectName(), new File(params.getProjectLocation(), params.getProjectName())) : aWorkspace.createProjectSpace(params.getProjectName());
        return createdProjectSpace;
    }

    private void deployCoreModule(IModelingSession sess, MdacManager mdacManager, File moduleStorePath, SubMonitor monitor) throws IllegalArgumentException {
        MdacArchiveRepository mdacRepository = new MdacArchiveRepository(moduleStorePath);
        MdacArchiveInfo coreMdac = mdacRepository.getLatestVersion("ModelerModule");
        monitor.subTask(AppModelio.I18N.getString("NewProjectHandler.deployModelerModule"));
        try {
            if (coreMdac != null) {
                MdacDeployer deployer = new MdacDeployer(sess, (IMdacManager)mdacManager);
                deployer.deployMdacs(Collections.singletonList(coreMdac.getArchive().getPath()), (IProgressMonitor)monitor.newChild(1));
                sess.save();
            }
        }
        catch (MdacException e) {
            String title = AppModelio.I18N.getMessage("DeployMdacHandler.FailedTitle", new String[]{coreMdac.getArchive().getPath().getName()});
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)title, (String)e.getLocalizedMessage());
        }
    }

    private void deploySelectedModules(IModelingSession sess, MdacManager mdacManager, List<MdacArchiveInfo> modulesToInstall, SubMonitor monitor) {
        List adaptersToInstall = ModuleArchiveSorter.sort(modulesToInstall);
        for (MdacArchiveInfo adapter : adaptersToInstall) {
            monitor.subTask(AppModelio.I18N.getMessage("NewProjectHandler.deployModule", new String[]{adapter.getName()}));
            try {
                MdacDeployer deployer = new MdacDeployer(sess, (IMdacManager)mdacManager);
                deployer.deployMdacs(Collections.singletonList(adapter.getArchive().getPath()), (IProgressMonitor)monitor.newChild(1));
                sess.save();
            }
            catch (MdacException e) {
                String title = AppModelio.I18N.getMessage("DeployMdacHandler.FailedTitle", new String[]{adapter.getArchive().getPath().getName()});
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)title, (String)e.getLocalizedMessage());
            }
        }
    }

    private void importQuickStartModel() {
        if (this.data.getCurrentProjectType().hasInitModel()) {
            File initFile = null;
            try {
                initFile = this.unzipInitProject();
            }
            catch (ZipException e1) {
                e1.printStackTrace();
                MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)AppModelio.I18N.getString("NewProjectHandler.ImportQuickStartError.Title"), (String)AppModelio.I18N.getMessage("NewProjectHandler.ImportQuickStartError.ZipException", new String[]{this.data.getCurrentProjectType().getLabel(), e1.getLocalizedMessage()}));
            }
            catch (IOException e1) {
                e1.printStackTrace();
                MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)AppModelio.I18N.getString("NewProjectHandler.ImportQuickStartError.Title"), (String)AppModelio.I18N.getMessage("NewProjectHandler.ImportQuickStartError.IOException", new String[]{this.data.getProjectName(), e1.getLocalizedMessage()}));
            }
            if (initFile != null && initFile.isFile()) {
                try {
                    IModelingSession srcSession = O.getDefault().openOfpBase(initFile);
                    IModelingSession dstSession = App.getInstance().getOpenedProject().getSession();
                    IProject srcProject = srcSession.getModel().getProject();
                    IProject dstProject = dstSession.getModel().getProject();
                    if (srcProject != null && dstProject != null) {
                        IPackage srcRoot = srcProject.getModel();
                        IPackage dstRoot = dstProject.getModel();
                        if (srcRoot != null && dstRoot != null) {
                            ObList modelTrees = srcRoot.getOwnedElement();
                            ObList elements = new ObList((IElement[])modelTrees.toArray((Object[])new IElement[modelTrees.size()]));
                            ModelServices.copyTo((Collection)elements, (IElement)dstRoot);
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)AppModelio.I18N.getString("NewProjectHandler.ImportQuickStartError.Title"), (String)AppModelio.I18N.getMessage("NewProjectHandler.ImportQuickStartError.IOException", new String[]{this.data.getProjectName(), e.getLocalizedMessage()}));
                }
                catch (InvalidModelManipulationException e) {
                    e.printStackTrace();
                    MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)AppModelio.I18N.getString("NewProjectHandler.ImportQuickStartError.Title"), (String)AppModelio.I18N.getMessage("NewProjectHandler.ImportQuickStartError.IOException", new String[]{this.data.getProjectName(), e.getLocalizedMessage()}));
                }
            }
        }
    }

    private void initMetadata(IModelingSession modelingSession) {
        IProjectPropertiesService propertiesService = modelingSession.getProjectPropertiesService();
        propertiesService.writeProperty("Modelio.Metadata", "ProjectAuthor", this.data.getProjectAuthor());
        propertiesService.writeProperty("Modelio.Metadata", "ProjectCreationDate", String.valueOf(this.data.getProjectDate().getTime()));
    }

    private void initModelioOptions(IModelingSession modelingSession) {
        IProjectPropertiesService propertiesService = modelingSession.getProjectPropertiesService();
        propertiesService.writeProperty("Modelio", "ParametersDlg.AttributeCreationDefaultType", "string");
        propertiesService.writeProperty("Modelio", "ParametersDlg.ParameterCreationDefaultType", "string");
        propertiesService.writeProperty("Modelio", "ParametersDlg.ReturnParameterCreationDefaultType", "boolean");
    }

    /*
     * Exception decompiling
     */
    private void initializeModel(SubMonitor monitor, IModelingSession sess) throws NoTransactionOpenException, InvalidTransactionException, NotCurrentTransactionException, CreateTransactionForbiddenException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private File unzipInitProject() throws IOException, ZipException {
        File archiveFile = this.data.getCurrentProjectType().getFile();
        File ofpFile = null;
        if (archiveFile.isFile()) {
            ZipFile zipFile = new ZipFile(archiveFile);
            ZipEntry entry = zipFile.getEntry("init.ofpx");
            ofpFile = File.createTempFile("init", ".ofpx");
            InputStream in = zipFile.getInputStream(entry);
            byte[] readBuffer = new byte[2156];
            FileOutputStream out = new FileOutputStream(ofpFile);
            try {
                int bytesIn;
                while ((bytesIn = in.read(readBuffer)) != -1) {
                    out.write(readBuffer, 0, bytesIn);
                }
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        return ofpFile;
    }
}

