/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.app.newProject.gui;

import com.modeliosoft.modelio.api.ui.UIColor;
import com.modeliosoft.modelio.app.newProject.gui.ICompositeTab;
import com.modeliosoft.modelio.app.newProject.gui.ImportController;
import com.modeliosoft.modelio.app.newProject.gui.ProjectCreationDataModel;
import com.modeliosoft.modelio.app.newProject.gui.ProjectType;
import com.modeliosoft.modelio.app.plugin.AppModelio;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class ImportComposite
extends Composite
implements ICompositeTab {
    private ProjectCreationDataModel dataModel;
    private Button noImportCheckbox = null;
    private Button quickStartModelCheckbox = null;
    private Image fileChooserImage = null;
    private Button projectLocationCheckbox = null;
    Label projectLocationPathLabel = null;
    Text projectLocationPathText = null;
    private Button projectLocationPathButton = null;
    private DirectoryDialog projectLocationPathChooser = null;

    public ImportComposite(Composite parent, ProjectCreationDataModel dataModel) {
        super(parent, 0);
        this.dataModel = dataModel;
        this.createContent();
    }

    public void addListener(ImportController listener) {
        this.projectLocationCheckbox.addSelectionListener((SelectionListener)listener);
        this.projectLocationPathText.addModifyListener((ModifyListener)listener);
    }

    public void dispose() {
        if (this.fileChooserImage != null) {
            this.fileChooserImage.dispose();
            this.fileChooserImage = null;
        }
        super.dispose();
    }

    public String getMessage() {
        return AppModelio.I18N.getString("NewProjectDialog.AdvancedOptions.Message");
    }

    public boolean isPredefinedStructure() {
        return this.quickStartModelCheckbox.getSelection();
    }

    public void refresh() {
        ProjectType currentProjectType = this.dataModel.getCurrentProjectType();
        if (currentProjectType != null) {
            boolean quickStartModelEnabled = currentProjectType.hasInitModel();
            this.quickStartModelCheckbox.setEnabled(quickStartModelEnabled);
        }
        this.projectLocationPathText.setText(this.dataModel.getProjectLocation().getAbsolutePath());
    }

    public void removeListener(ImportController listener) {
        this.projectLocationPathText.removeModifyListener((ModifyListener)listener);
        this.projectLocationCheckbox.removeSelectionListener((SelectionListener)listener);
    }

    public void setPredefinedStructure(boolean value) {
        this.quickStartModelCheckbox.setSelection(value);
    }

    void invalidateProjectLocation(boolean onOff) {
        if (onOff) {
            this.projectLocationPathText.setForeground(this.getDisplay().getSystemColor(3));
        } else {
            this.projectLocationPathText.setForeground(this.getDisplay().getSystemColor(6));
        }
    }

    private void createContent() {
        GridLayout gridLayout = new GridLayout(1, false);
        this.setLayout((Layout)gridLayout);
        this.createImportGroup();
        this.createProjectLocationGroup();
    }

    private void createImportGroup() {
        Group importGroup = new Group((Composite)this, 0);
        importGroup.setText(AppModelio.I18N.getString("NewProjectDialog.AdvancedOptions.Import.Group"));
        GridLayout gl_importGroup = new GridLayout(3, false);
        importGroup.setLayout((Layout)gl_importGroup);
        GridData gd_importGroup = new GridData(4, 16384, true, false, 1, 1);
        importGroup.setLayoutData((Object)gd_importGroup);
        this.createNoImportCheckbox(importGroup);
        this.createQuickStartModelCheckbox(importGroup);
    }

    private void createNoImportCheckbox(Group group) {
        this.noImportCheckbox = new Button((Composite)group, 16);
        this.noImportCheckbox.setText(AppModelio.I18N.getString("NoImport"));
        GridData gd_noImport = new GridData(4, 0x1000000, true, false, 3, 1);
        this.noImportCheckbox.setLayoutData((Object)gd_noImport);
        this.noImportCheckbox.setSelection(true);
    }

    private void createProjectLocationDescription(Group group) {
        Text redirectionDescriptionText = new Text((Composite)group, 72);
        redirectionDescriptionText.setText(AppModelio.I18N.getString("NewProjectDialog.AdvancedOptions.ProjectLocation.Description"));
        GridData gd_redirectionDescriptionText = new GridData(4, 16384, true, false, 3, 1);
        redirectionDescriptionText.setLayoutData((Object)gd_redirectionDescriptionText);
    }

    private void createProjectLocationField(Group group) {
        this.projectLocationCheckbox = new Button((Composite)group, 32);
        this.projectLocationCheckbox.setText(AppModelio.I18N.getString("NewProjectDialog.AdvancedOptions.ProjectLocation.ChangeProjectLocation"));
        GridData gd_projectLocationCheckbox = new GridData(4, 0x1000000, true, false, 3, 1);
        this.projectLocationCheckbox.setLayoutData((Object)gd_projectLocationCheckbox);
        this.projectLocationPathLabel = new Label((Composite)group, 0);
        this.projectLocationPathLabel.setText(AppModelio.I18N.getString("NewProjectDialog.AdvancedOptions.ProjectLocation.Path"));
        this.projectLocationPathLabel.setEnabled(false);
        this.projectLocationPathText = new Text((Composite)group, 2048);
        this.projectLocationPathText.setEditable(false);
        this.projectLocationPathText.setEnabled(false);
        this.projectLocationPathText.setBackground(UIColor.TEXT_READONLY_BG);
        this.projectLocationPathButton = new Button((Composite)group, 0);
        this.projectLocationPathButton.setText("...");
        this.projectLocationPathButton.setEnabled(false);
        this.projectLocationCheckbox.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.projectLocationPathChooser = new DirectoryDialog(group.getShell(), 0);
        this.projectLocationPathButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        GridData gd_projectLocationPathLabel = new GridData(16384, 0x1000000, false, false);
        this.projectLocationPathLabel.setLayoutData((Object)gd_projectLocationPathLabel);
        GridData gd_projectLocationPathText = new GridData(4, 0x1000000, true, false);
        this.projectLocationPathText.setLayoutData((Object)gd_projectLocationPathText);
        GridData gd_projectLocationPathButton = new GridData(131072, 0x1000000, false, false);
        this.projectLocationPathButton.setLayoutData((Object)gd_projectLocationPathButton);
    }

    private void createProjectLocationGroup() {
        Group projectLocationGroup = new Group((Composite)this, 0);
        projectLocationGroup.setText(AppModelio.I18N.getString("NewProjectDialog.AdvancedOptions.ProjectLocation.Group"));
        GridLayout gl_projectLocationGroup = new GridLayout(3, false);
        projectLocationGroup.setLayout((Layout)gl_projectLocationGroup);
        GridData gd_redirectionGroup = new GridData(4, 16384, true, false, 1, 1);
        projectLocationGroup.setLayoutData((Object)gd_redirectionGroup);
        this.createProjectLocationDescription(projectLocationGroup);
        this.createProjectLocationField(projectLocationGroup);
    }

    private void createQuickStartModelCheckbox(Group group) {
        this.quickStartModelCheckbox = new Button((Composite)group, 16);
        this.quickStartModelCheckbox.setText(AppModelio.I18N.getString("ImportPredefinedStructure"));
        this.quickStartModelCheckbox.setEnabled(false);
        GridData gd_quickStartModel = new GridData(4, 0x1000000, true, false, 3, 1);
        this.quickStartModelCheckbox.setLayoutData((Object)gd_quickStartModel);
        this.quickStartModelCheckbox.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ Button access$0(ImportComposite importComposite) {
        return importComposite.projectLocationPathButton;
    }

    static /* synthetic */ ProjectCreationDataModel access$1(ImportComposite importComposite) {
        return importComposite.dataModel;
    }

    static /* synthetic */ DirectoryDialog access$2(ImportComposite importComposite) {
        return importComposite.projectLocationPathChooser;
    }

    static /* synthetic */ Button access$3(ImportComposite importComposite) {
        return importComposite.quickStartModelCheckbox;
    }
}

