/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.app.newProject.gui;

import com.modeliosoft.modelio.app.newProject.gui.ImportComposite;
import com.modeliosoft.modelio.app.newProject.gui.ProjectCreationDataModel;
import com.modeliosoft.modelio.app.newProject.gui.ProjectCreationDialog;
import java.io.File;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;

public class ImportController
implements ModifyListener,
SelectionListener {
    private ProjectCreationDataModel dataModel = null;
    private ProjectCreationDialog dialog = null;
    private final ImportComposite importComposite;

    public ImportController(ProjectCreationDataModel dataModel, ProjectCreationDialog dialog, ImportComposite importTab) {
        this.dataModel = dataModel;
        this.dialog = dialog;
        this.importComposite = importTab;
    }

    public void modifyText(ModifyEvent event) {
        Object source = event.getSource();
        this.validate(source);
        boolean isValid = this.dialog.validateData();
        this.dialog.updateButtons(isValid);
    }

    public boolean validateData() {
        boolean projectLocationOk = this.validateProjectLocation(this.importComposite.projectLocationPathText.getText());
        return projectLocationOk;
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        Object source = event.getSource();
        this.validate(source);
        boolean isValid = this.dialog.validateData();
        this.dialog.updateButtons(isValid);
    }

    public void widgetSelected(SelectionEvent event) {
        Object source = event.getSource();
        this.validate(source);
        boolean isValid = this.dialog.validateData();
        this.dialog.updateButtons(isValid);
    }

    private void validate(Object source) {
        if (source == this.importComposite.projectLocationPathText) {
            String projectLocation = this.importComposite.projectLocationPathText.getText();
            boolean projectLocationOk = this.validateProjectLocation(projectLocation);
            if (projectLocationOk) {
                this.dataModel.setProjectLocation(new File(projectLocation));
            }
            this.importComposite.invalidateProjectLocation(!projectLocationOk);
        }
    }

    private boolean validateProjectLocation(String projectLocationPath) {
        if (this.dataModel.changeProjectLocationPath()) {
            File projectLocation = new File(projectLocationPath);
            return projectLocation.isDirectory() && projectLocation.canWrite();
        }
        return true;
    }
}

