/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.app.newProject.gui;

import com.modeliosoft.modelio.api.ui.UIColor;
import com.modeliosoft.modelio.app.newProject.gui.ICompositeTab;
import com.modeliosoft.modelio.app.newProject.gui.ModuleAdapter;
import com.modeliosoft.modelio.app.newProject.gui.ModulesComposite;
import com.modeliosoft.modelio.app.newProject.gui.ModulesController;
import com.modeliosoft.modelio.app.newProject.gui.ModulesListContentProvider;
import com.modeliosoft.modelio.app.newProject.gui.ModulesListLabelProvider;
import com.modeliosoft.modelio.app.newProject.gui.ProjectCreationDataModel;
import com.modeliosoft.modelio.app.plugin.AppModelio;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

class ModulesComposite
extends Composite
implements ICompositeTab {
    private ProjectCreationDataModel dataModel;
    private LicenceUpdateThread initModulesThread = null;
    private CheckboxTableViewer viewer = null;
    private Text moduleDescriptionText = null;
    protected ScrolledComposite scrolledComposite = null;

    public ModulesComposite(Composite parent, ProjectCreationDataModel dataModel) {
        super(parent, 0);
        this.dataModel = dataModel;
        this.createContent();
    }

    public void addListener(ModulesController listener) {
        this.viewer.addCheckStateListener((ICheckStateListener)listener);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)listener);
    }

    public String getMessage() {
        return AppModelio.I18N.getString("ChooseModulesMessage");
    }

    public void refresh() {
        for (ModuleAdapter adapter : this.dataModel.getModuleAdapters()) {
            this.viewer.setChecked((Object)adapter, adapter.isDeploy());
            TableItem item = this.getItem(adapter);
            if (adapter.canBeDeployed() && !adapter.isMandatory()) {
                item.setForeground(this.getDisplay().getSystemColor(2));
                continue;
            }
            item.setForeground(this.getDisplay().getSystemColor(15));
        }
        this.viewer.refresh();
    }

    public void removeListener(ModulesController listener) {
        this.viewer.removeCheckStateListener((ICheckStateListener)listener);
        this.viewer.removeSelectionChangedListener((ISelectionChangedListener)listener);
    }

    public void setDescription(String description) {
        this.moduleDescriptionText.setText(description);
        Point point = this.moduleDescriptionText.computeSize(this.moduleDescriptionText.getParent().getSize().x, -1, true);
        this.scrolledComposite.setMinSize(point);
    }

    private void createContent() {
        FormLayout layout = new FormLayout();
        this.setLayout((Layout)layout);
        Composite viewerComposite = new Composite((Composite)this, 2048);
        viewerComposite.setLayout((Layout)new FillLayout());
        String[] columnNames = new String[]{AppModelio.I18N.getString("Name"), AppModelio.I18N.getString("Version"), AppModelio.I18N.getString("LicensingTerms")};
        this.viewer = CheckboxTableViewer.newCheckList((Composite)viewerComposite, (int)65570);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.setSorter(new ViewerSorter());
        this.viewer.setContentProvider((IContentProvider)new ModulesListContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ModulesListLabelProvider());
        this.viewer.setInput((Object)this.dataModel);
        TableColumn column0 = new TableColumn(this.viewer.getTable(), 16384, 0);
        column0.setText(AppModelio.I18N.getString("Name"));
        column0.setWidth(200);
        TableColumn column1 = new TableColumn(this.viewer.getTable(), 16384, 1);
        column1.setText(AppModelio.I18N.getString("Version"));
        column1.setWidth(80);
        TableColumn column2 = new TableColumn(this.viewer.getTable(), 16384, 2);
        column2.setText(AppModelio.I18N.getString("LicensingTerms"));
        column2.setWidth(220);
        this.viewer.setColumnProperties(columnNames);
        FormData fd_viewerComposite = new FormData();
        fd_viewerComposite.left = new FormAttachment(0, 0);
        fd_viewerComposite.right = new FormAttachment(100, 0);
        fd_viewerComposite.top = new FormAttachment(0, 0);
        fd_viewerComposite.bottom = new FormAttachment(70, 0);
        viewerComposite.setLayoutData((Object)fd_viewerComposite);
        this.scrolledComposite = new ScrolledComposite((Composite)this, 512);
        GridLayout gl_scrolledComposite = new GridLayout(1, false);
        this.scrolledComposite.setLayout((Layout)gl_scrolledComposite);
        this.moduleDescriptionText = new Text((Composite)this.scrolledComposite, 72);
        GridData gd_moduleDescription = new GridData(4, 4, true, true);
        this.moduleDescriptionText.setLayoutData((Object)gd_moduleDescription);
        this.moduleDescriptionText.setForeground(UIColor.LABEL_TIP_FG);
        this.scrolledComposite.setContent((Control)this.moduleDescriptionText);
        Point point = this.moduleDescriptionText.computeSize(-1, -1);
        this.scrolledComposite.setMinSize(point);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setExpandHorizontal(true);
        FormData fd_scrolledComposite = new FormData();
        fd_scrolledComposite.left = new FormAttachment(0, 3);
        fd_scrolledComposite.right = new FormAttachment(100, -3);
        fd_scrolledComposite.top = new FormAttachment(70, 3);
        fd_scrolledComposite.bottom = new FormAttachment(100, -3);
        this.scrolledComposite.setLayoutData((Object)fd_scrolledComposite);
        this.initModulesLicenceInfos();
    }

    private TableItem getItem(ModuleAdapter adapter) {
        TableItem[] tableItemArray = this.viewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ModuleAdapter currentAdapter;
            TableItem item = tableItemArray[n2];
            Object data = item.getData();
            if (data instanceof ModuleAdapter && (currentAdapter = (ModuleAdapter)data).getName().equals(adapter.getName())) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    private void initModulesLicenceInfos() {
        this.initModulesThread = new LicenceUpdateThread(this);
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.initModulesThread.start();
    }

    static /* synthetic */ ProjectCreationDataModel access$0(ModulesComposite modulesComposite) {
        return modulesComposite.dataModel;
    }

    static /* synthetic */ CheckboxTableViewer access$1(ModulesComposite modulesComposite) {
        return modulesComposite.viewer;
    }

    static /* synthetic */ LicenceUpdateThread access$2(ModulesComposite modulesComposite) {
        return modulesComposite.initModulesThread;
    }
}

