/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.app.newProject.gui;

import com.modeliosoft.modelio.api.mdac.IMdacDescriptor;
import com.modeliosoft.modelio.app.newProject.gui.ModuleAdapter;
import com.modeliosoft.modelio.app.newProject.gui.ProjectCreationDataModel;
import com.modeliosoft.modelio.app.newProject.gui.ProjectCreationDialog;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;

class ModulesController
implements ICheckStateListener,
ISelectionChangedListener {
    private ProjectCreationDataModel dataModel = null;
    private ProjectCreationDialog dialog = null;

    public ModulesController(ProjectCreationDataModel dataModel, ProjectCreationDialog dialog) {
        this.dataModel = dataModel;
        this.dialog = dialog;
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        ModuleAdapter adapter = (ModuleAdapter)event.getElement();
        boolean checked = event.getChecked();
        if (checked) {
            List otherVersions = this.getOtherVersions(adapter);
            for (ModuleAdapter otherAdapter : otherVersions) {
                otherAdapter.setDeploy(false);
            }
            this.checkRequiredMdacs(adapter);
        } else {
            this.uncheckDependentMdacs(adapter, (CheckboxTableViewer)event.getSource());
        }
        if (adapter.canBeDeployed()) {
            adapter.setDeploy(checked);
        }
        if (adapter.isMandatory()) {
            adapter.setDeploy(true);
        }
        this.dialog.refresh();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() == 1) {
                Object obj = structuredSelection.getFirstElement();
                if (obj instanceof ModuleAdapter) {
                    ModuleAdapter adapter = (ModuleAdapter)obj;
                    this.dialog.modulesComposite.setDescription(adapter.getDescription());
                }
            } else {
                this.dialog.modulesComposite.setDescription("");
            }
        }
    }

    public boolean validateData() {
        return true;
    }

    private boolean checkRequiredMdacs(ModuleAdapter adapter) {
        List requiredMdacs = adapter.getRequiredMdacs();
        for (IMdacDescriptor requiredMdac : requiredMdacs) {
            ModuleAdapter latestVersion = this.getLatestVersion(requiredMdac.getName());
            if (latestVersion.getVersion().isOlderThan(requiredMdac.getVersion())) continue;
            latestVersion.setDeploy(true);
            this.checkRequiredMdacs(latestVersion);
        }
        return true;
    }

    private ModuleAdapter getLatestVersion(String name) {
        ModuleAdapter latestVersion = null;
        for (ModuleAdapter adapter : this.dataModel.getModuleAdapters()) {
            if (!name.equals(adapter.getName())) continue;
            if (latestVersion == null) {
                latestVersion = adapter;
                continue;
            }
            if (!latestVersion.getVersion().isOlderThan(adapter.getVersion())) continue;
            latestVersion = adapter;
        }
        return latestVersion;
    }

    private List<ModuleAdapter> getOtherVersions(ModuleAdapter adapter) {
        ArrayList<ModuleAdapter> otherVersions = new ArrayList<ModuleAdapter>();
        List mdacsList = this.dataModel.getModuleAdapters();
        for (ModuleAdapter mdac : mdacsList) {
            if (!adapter.getName().equals(mdac.getName()) || adapter.getVersion().equals((Object)mdac.getVersion())) continue;
            otherVersions.add(mdac);
        }
        return otherVersions;
    }

    private void uncheckDependentMdacs(ModuleAdapter parentMdac, CheckboxTableViewer viewer) {
        if (!parentMdac.isMandatory()) {
            List adapters = this.dataModel.getModuleAdapters();
            for (ModuleAdapter adapter : adapters) {
                List requiredMdacs = adapter.getRequiredMdacs();
                for (IMdacDescriptor requiredMdac : requiredMdacs) {
                    if (!requiredMdac.getName().equals(parentMdac.getName())) continue;
                    adapter.setDeploy(false);
                    this.uncheckDependentMdacs(adapter, viewer);
                }
            }
        }
    }
}

