/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.app.newProject.gui;

import com.modeliosoft.modelio.api.ui.UIColor;
import com.modeliosoft.modelio.app.newProject.gui.ICompositeTab;
import com.modeliosoft.modelio.app.newProject.gui.ProjectController;
import com.modeliosoft.modelio.app.newProject.gui.ProjectCreationDataModel;
import com.modeliosoft.modelio.app.newProject.gui.ProjectTypeProvider;
import com.modeliosoft.modelio.app.newProject.gui.ProjectTypeSelectionListener;
import com.modeliosoft.modelio.app.plugin.AppModelio;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

class ProjectComposite
extends Composite
implements ICompositeTab {
    private ProjectCreationDataModel dataModel;
    private ProjectTypeProvider projectTypeProvider = null;
    private Text projectNameText = null;
    private Text projectDescriptionText = null;
    private Text projectAuthorText = null;
    private TableViewer projectTypeList = null;
    private Text projectTypeDescriptionText = null;

    public ProjectComposite(Composite parent, ProjectCreationDataModel dataModel) {
        super(parent, 0);
        this.dataModel = dataModel;
        this.createContent();
    }

    public void addListener(ProjectController listener) {
        this.projectNameText.addListener(24, (Listener)listener);
        this.projectDescriptionText.addListener(24, (Listener)listener);
        this.projectTypeList.addSelectionChangedListener((ISelectionChangedListener)listener);
    }

    public String getMessage() {
        return AppModelio.I18N.getString("ChooseProjectMessage");
    }

    public String getProjectAuthor() {
        return this.projectAuthorText.getText();
    }

    public String getProjectDescription() {
        return this.projectDescriptionText.getText();
    }

    public String getProjectName() {
        return this.projectNameText.getText();
    }

    public void invalidateProjectNameField(boolean onOff) {
        if (onOff) {
            this.projectNameText.setForeground(this.getDisplay().getSystemColor(3));
        } else {
            this.projectNameText.setForeground(this.getDisplay().getSystemColor(6));
        }
    }

    public void refresh() {
        this.setProjectName(this.dataModel.getProjectName());
        this.setProjectAuthor(this.dataModel.getProjectAuthor());
        this.setProjectDescription(this.dataModel.getProjectDescription());
        this.projectTypeList.refresh();
    }

    public void removeListener(ProjectController listener) {
        this.projectNameText.removeListener(24, (Listener)listener);
        this.projectDescriptionText.removeListener(24, (Listener)listener);
        this.projectTypeList.removeSelectionChangedListener((ISelectionChangedListener)listener);
    }

    public void setProjectAuthor(String value) {
        this.projectAuthorText.setText(value);
    }

    public void setProjectDescription(String projectDescription) {
        this.projectDescriptionText.setText(projectDescription);
    }

    public void setProjectName(String projectName) {
        this.projectNameText.setText(projectName);
        this.projectNameText.setSelection(0, projectName.length());
        this.projectNameText.setFocus();
    }

    public void setProjectTypeDescription(String description) {
        this.projectTypeDescriptionText.setText(description);
    }

    public void updateDataModel() {
        this.dataModel.setProjectName(this.projectNameText.getText());
        this.dataModel.setProjectAuthor(this.projectAuthorText.getText());
        this.dataModel.setProjectDescription(this.projectDescriptionText.getText());
    }

    private void createContent() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        this.setLayout((Layout)gridLayout);
        this.createProjectNameField();
        this.createProjectAuthorField();
        this.createProjectDescriptionField();
        this.createProjectTypeField();
    }

    private void createProjectAuthorField() {
        Label projectAuthorLabel = new Label((Composite)this, 0);
        projectAuthorLabel.setText(AppModelio.I18N.getString("AuthorName"));
        this.projectAuthorText = new Text((Composite)this, 2048);
        GridData gd_projectAuthorText = new GridData(4, 0x1000000, true, false);
        this.projectAuthorText.setLayoutData((Object)gd_projectAuthorText);
    }

    private void createProjectDescriptionField() {
        Label descriptionLabel = new Label((Composite)this, 0);
        GridData gd_descriptionLabel = new GridData(16384, 128, false, false);
        descriptionLabel.setLayoutData((Object)gd_descriptionLabel);
        descriptionLabel.setText(AppModelio.I18N.getString("Description"));
        this.projectDescriptionText = new Text((Composite)this, 2626);
        GridData gd_descriptionText = new GridData(4, 4, true, true);
        this.projectDescriptionText.setLayoutData((Object)gd_descriptionText);
    }

    private void createProjectNameField() {
        Label projectNameLabel = new Label((Composite)this, 0);
        projectNameLabel.setText(AppModelio.I18N.getString("ProjectName"));
        this.projectNameText = new Text((Composite)this, 2048);
        GridData gd_projectNameText = new GridData(4, 0x1000000, true, false);
        this.projectNameText.setLayoutData((Object)gd_projectNameText);
    }

    private void createProjectTypeField() {
        Label projectTypeLabel = new Label((Composite)this, 0);
        projectTypeLabel.setText(AppModelio.I18N.getString("ProjectType"));
        GridData fd_projectTypeLabel = new GridData(16384, 128, false, false);
        projectTypeLabel.setLayoutData((Object)fd_projectTypeLabel);
        this.projectTypeList = new TableViewer((Composite)this, 67584);
        String[] columnNames = new String[]{"Selected", "Name", "Mdacs"};
        TableColumn column0 = new TableColumn(this.projectTypeList.getTable(), 16384, 0);
        TableColumn column1 = new TableColumn(this.projectTypeList.getTable(), 16384, 1);
        new TableColumn(this.projectTypeList.getTable(), 16384, 2);
        column1.setWidth(250);
        column1.setText(AppModelio.I18N.getString("NewProjectDialog.ProjectType.Mdacs"));
        this.projectTypeList.setColumnProperties(columnNames);
        CellEditor[] cellEditorArray = new CellEditor[3];
        cellEditorArray[0] = new CheckboxCellEditor();
        CellEditor[] editors = cellEditorArray;
        this.projectTypeList.setCellEditors(editors);
        this.projectTypeList.setCellModifier((ICellModifier)new /* Unavailable Anonymous Inner Class!! */);
        this.projectTypeList.getTable().addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
        GridData fd_projectTypeList = new GridData(4, 0x1000000, true, false);
        this.projectTypeList.getTable().setLayoutData((Object)fd_projectTypeList);
        this.projectTypeProvider = new ProjectTypeProvider(this.dataModel);
        this.projectTypeList.setContentProvider((IContentProvider)this.projectTypeProvider);
        this.projectTypeList.setLabelProvider((IBaseLabelProvider)this.projectTypeProvider);
        this.projectTypeList.setInput((Object)this.dataModel.getProjectTypes());
        column0.pack();
        column1.pack();
        Composite emptyComposite = new Composite((Composite)this, 0);
        GridData fd_emptyComposite = new GridData(16384, 128, false, false);
        fd_emptyComposite.heightHint = 2;
        emptyComposite.setLayoutData((Object)fd_emptyComposite);
        this.projectTypeDescriptionText = new Text((Composite)this, 72);
        this.projectTypeDescriptionText.setForeground(UIColor.LABEL_TIP_FG);
        GridData fg_projectTypeDescription = new GridData(4, 0x1000000, true, false);
        fg_projectTypeDescription.heightHint = 80;
        this.projectTypeDescriptionText.setLayoutData((Object)fg_projectTypeDescription);
        this.projectTypeList.addSelectionChangedListener((ISelectionChangedListener)new ProjectTypeSelectionListener(this, this.dataModel));
    }

    static /* synthetic */ ProjectCreationDataModel access$0(ProjectComposite projectComposite) {
        return projectComposite.dataModel;
    }
}

