/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.app.newProject.gui;

import com.modeliosoft.modelio.app.newProject.gui.ProjectComposite;
import com.modeliosoft.modelio.app.newProject.gui.ProjectCreationDataModel;
import com.modeliosoft.modelio.app.newProject.gui.ProjectCreationDialog;
import com.modeliosoft.modelio.internal.app.services.App;
import com.modeliosoft.modelio.internal.app.services.ui.ProjectNameValidator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ProjectController
implements Listener,
ISelectionChangedListener {
    private ProjectCreationDataModel dataModel = null;
    private ProjectCreationDialog dialog = null;
    private ProjectComposite projectComposite;

    public ProjectController(ProjectCreationDataModel dataModel, ProjectCreationDialog dialog, ProjectComposite projectComposite) {
        this.dataModel = dataModel;
        this.dialog = dialog;
        this.projectComposite = projectComposite;
    }

    public void handleEvent(Event event) {
        boolean isValid = this.validateData();
        this.dataModel.setProjectName(this.projectComposite.getProjectName());
        this.dataModel.setProjectDescription(this.projectComposite.getProjectDescription());
        if (isValid && !this.dataModel.changeProjectLocationPath()) {
            this.dataModel.setProjectLocation(App.getInstance().getWorkspace().getDirectory());
            this.dialog.getImportComposite().refresh();
        }
        this.projectComposite.invalidateProjectNameField(!isValid);
        this.dialog.updateButtons(isValid);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.dialog.refresh();
    }

    public boolean validateData() {
        boolean projectNameOk = this.validateProjectName(this.projectComposite.getProjectName());
        boolean descriptionOk = true;
        return projectNameOk && descriptionOk;
    }

    protected boolean validateProjectName(String name) {
        return ProjectNameValidator.PROJECT_NAME_PATTERN.matcher(name).matches();
    }
}

