/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.app.newProject.gui;

import com.modeliosoft.modelio.app.newProject.gui.ModuleAdapter;
import com.modeliosoft.modelio.app.newProject.gui.ProjectCreationDataModel;
import com.modeliosoft.modelio.app.newProject.gui.ProjectType;
import com.modeliosoft.modelio.app.plugin.AppModelio;
import com.modeliosoft.modelio.internal.app.services.App;
import com.modeliosoft.modelio.mdainfra.mdacs.store.MdacArchiveInfo;
import com.modeliosoft.modelio.mdainfra.mdacs.store.MdacArchiveRepository;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.MissingResourceException;
import org.eclipse.core.runtime.Platform;

public class ProjectCreationDataModel {
    private String projectName = "";
    private String projectDescription = "";
    private String projectAuthor = "";
    private List<ProjectType> projectTypes = new ArrayList();
    private ProjectType currentProjectType = null;
    private List<ModuleAdapter> moduleAdapters = new ArrayList();
    private String moduleDescription = "";
    private boolean importQuickStartModel = false;
    private boolean importMigratedProject = false;
    private String ofpToMigrate = null;
    private boolean changeProjectLocationPath = false;
    private File projectLocation = null;
    private Date projectDate = null;
    private static final String CORE_MODULE_NAME = "ModelerModule";

    public ProjectCreationDataModel(String projectType) {
        this.initProject();
        this.initModules();
        this.initProjectTypes(projectType);
        this.initImport();
    }

    public boolean changeProjectLocationPath() {
        File testFile = new File(App.getInstance().getWorkspace().getDirectory(), this.getProjectName());
        return this.changeProjectLocationPath && !this.projectLocation.equals(testFile);
    }

    public ProjectType getCurrentProjectType() {
        return this.currentProjectType;
    }

    public List<ModuleAdapter> getModuleAdapters() {
        return this.moduleAdapters;
    }

    public String getModuleDescription() {
        return this.moduleDescription;
    }

    public String getOfpToMigrate() {
        return this.ofpToMigrate;
    }

    public String getProjectAuthor() {
        return this.projectAuthor;
    }

    public Date getProjectDate() {
        return this.projectDate;
    }

    public String getProjectDescription() {
        return this.projectDescription;
    }

    public File getProjectLocation() {
        return this.projectLocation;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectTypeDescription() {
        if (this.currentProjectType != null) {
            return this.currentProjectType.getDescription();
        }
        return "";
    }

    public List<ProjectType> getProjectTypes() {
        return this.projectTypes;
    }

    public boolean importMigratedProject() {
        return this.importMigratedProject;
    }

    public boolean isImportQuickStartModel() {
        return this.importQuickStartModel;
    }

    public void setChangeProjectLocationPath(boolean value) {
        this.changeProjectLocationPath = value;
    }

    public void setCurrentProjectType(ProjectType currentProjectType) {
        this.currentProjectType = currentProjectType;
        if (this.currentProjectType == null) {
            return;
        }
        List mdacs = currentProjectType.getMdacs();
        for (ModuleAdapter adapter : this.moduleAdapters) {
            String moduleName = adapter.getName();
            if (mdacs.contains(moduleName)) {
                adapter.setDeploy(true);
                adapter.setMandatory(true);
                continue;
            }
            adapter.setDeploy(false);
            adapter.setMandatory(false);
        }
    }

    public void setImportMigratedProject(boolean value) {
        this.importMigratedProject = value;
    }

    public void setImportQuickStartModel(boolean value) {
        this.importQuickStartModel = value;
    }

    public void setModuleDescription(String moduleDescription) {
        this.moduleDescription = moduleDescription;
    }

    public void setOfpToMigrate(String fileName) {
        this.ofpToMigrate = fileName;
    }

    public void setProjectAuthor(String projectAuthor) {
        this.projectAuthor = projectAuthor;
    }

    public void setProjectDate(Date projectDate) {
        this.projectDate = projectDate;
    }

    public void setProjectDescription(String projectDescription) {
        this.projectDescription = projectDescription;
    }

    public void setProjectLocation(File projectLocation) {
        this.projectLocation = projectLocation;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    private List<ModuleAdapter> filterMostRecentVersions(List<ModuleAdapter> adapters) {
        ArrayList<ModuleAdapter> filteredList = new ArrayList<ModuleAdapter>();
        HashMap<String, ModuleAdapter> sortedAdapters = new HashMap<String, ModuleAdapter>();
        ModuleAdapter currentModuleAdapter = null;
        for (ModuleAdapter adapter : adapters) {
            currentModuleAdapter = (ModuleAdapter)sortedAdapters.get(adapter.getName());
            if (currentModuleAdapter == null) {
                sortedAdapters.put(adapter.getName(), adapter);
                continue;
            }
            if (!currentModuleAdapter.getVersion().isOlderThan(adapter.getVersion())) continue;
            sortedAdapters.put(adapter.getName(), adapter);
        }
        filteredList.addAll(sortedAdapters.values());
        return filteredList;
    }

    private void initImport() {
        this.projectLocation = App.getInstance().getWorkspace().getDirectory();
    }

    private void initModules() {
        File mdacStoreDir = new File(Platform.getInstallLocation().getURL().getPath(), "mdastore");
        if (mdacStoreDir.isDirectory()) {
            MdacArchiveRepository mdastore = new MdacArchiveRepository(mdacStoreDir);
            for (MdacArchiveInfo mdac : mdastore.getModules()) {
                if (CORE_MODULE_NAME.equals(mdac.name)) continue;
                String label = "";
                String description = "";
                try {
                    MdacArchiveRepository.LocalizedData data = mdastore.getLocalization(mdac);
                    if (data != null) {
                        label = data.getLabel();
                        description = data.getDescription();
                    }
                }
                catch (IOException e) {
                    description = e.getLocalizedMessage();
                    AppModelio.LOG.warning((Throwable)e);
                }
                catch (MissingResourceException e) {
                    label = mdac.name;
                    description = "";
                }
                this.moduleAdapters.add(new ModuleAdapter(mdac, label, description));
            }
            this.moduleAdapters = this.filterMostRecentVersions(this.moduleAdapters);
        }
    }

    private void initProject() {
        this.projectAuthor = System.getProperty("user.name");
        this.projectDate = new Date();
    }

    private void initProjectTypes(String projectTypeName) {
        File templatesDir = new File(Platform.getInstallLocation().getURL().getPath(), "templates");
        if (templatesDir.isDirectory()) {
            List templateFiles = this.listTemplateFiles(templatesDir);
            boolean found = false;
            for (File templateFile : templateFiles) {
                ProjectType projectType = new ProjectType(templateFile);
                this.projectTypes.add(projectType);
                if (!projectType.getName().equals(projectTypeName)) continue;
                this.setCurrentProjectType(projectType);
                found = true;
            }
            if (!found) {
                for (ProjectType type : this.projectTypes) {
                    if (!type.getName().equals("Default")) continue;
                    this.setCurrentProjectType(type);
                    return;
                }
            }
        }
    }

    private List<File> listTemplateFiles(File templatesDir) {
        File[] files = templatesDir.listFiles((FileFilter)new TemplateFilter());
        ArrayList<File> fileList = new ArrayList<File>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                fileList.add(file);
            } else if (file.isDirectory()) {
                fileList.addAll(this.listTemplateFiles(file));
            }
            ++n2;
        }
        return fileList;
    }

    public ProjectCreationDataModel() {
        this(null);
    }
}

