/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.app.newProject.gui;

import com.modeliosoft.modelio.api.ui.ModelioDialog;
import com.modeliosoft.modelio.app.newProject.gui.ICompositeTab;
import com.modeliosoft.modelio.app.newProject.gui.ImportComposite;
import com.modeliosoft.modelio.app.newProject.gui.ImportController;
import com.modeliosoft.modelio.app.newProject.gui.ModulesComposite;
import com.modeliosoft.modelio.app.newProject.gui.ModulesController;
import com.modeliosoft.modelio.app.newProject.gui.ProjectComposite;
import com.modeliosoft.modelio.app.newProject.gui.ProjectController;
import com.modeliosoft.modelio.app.newProject.gui.ProjectCreationDataModel;
import com.modeliosoft.modelio.app.plugin.AppModelio;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class ProjectCreationDialog
extends ModelioDialog
implements SelectionListener {
    ProjectCreationDataModel dataModel;
    private List<ICompositeTab> compositesList = new ArrayList();
    private ProjectComposite projectComposite = null;
    ModulesComposite modulesComposite = null;
    private ImportComposite importComposite = null;
    ProjectController projectController = null;
    ModulesController modulesController = null;
    private ImportController importController = null;
    private Button createButton = null;
    private Button cancelButton = null;
    private TabFolder tabFolder = null;
    private Button previousButton = null;
    private Button nextButton = null;

    public ProjectCreationDialog(Shell parentShell, ProjectCreationDataModel dataModel) {
        super(parentShell);
        this.dataModel = dataModel;
    }

    public void addButtonsInButtonBar(Composite parent) {
        this.previousButton = this.createButton(parent, 14, AppModelio.I18N.getString("Previous"), false);
        this.previousButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.nextButton = this.createButton(parent, 15, AppModelio.I18N.getString("Next"), false);
        this.nextButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createButton = this.createButton(parent, 0, AppModelio.I18N.getString("Create"), false);
        this.cancelButton = this.createButton(parent, 1, AppModelio.I18N.getString("Cancel"), true);
        this.updateButtons(true);
    }

    public boolean close() {
        this.projectComposite.removeListener(this.projectController);
        this.modulesComposite.removeListener(this.modulesController);
        this.importComposite.removeListener(this.importController);
        if (this.tabFolder != null) {
            this.tabFolder.removeSelectionListener((SelectionListener)this);
        }
        return super.close();
    }

    public Control createContentArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setLayout((Layout)new GridLayout());
        area.setLayoutData((Object)new GridData(1808));
        this.tabFolder = new TabFolder(area, 0);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        TabItem projectTab = new TabItem(this.tabFolder, 0);
        projectTab.setText(AppModelio.I18N.getString("Project"));
        this.projectComposite = new ProjectComposite((Composite)this.tabFolder, this.dataModel);
        projectTab.setControl((Control)this.projectComposite);
        this.compositesList.add(this.projectComposite);
        this.projectController = new ProjectController(this.dataModel, this, this.projectComposite);
        this.projectComposite.addListener(this.projectController);
        TabItem modulesTab = new TabItem(this.tabFolder, 0);
        modulesTab.setText(AppModelio.I18N.getString("Modules"));
        this.modulesComposite = new ModulesComposite((Composite)this.tabFolder, this.dataModel);
        modulesTab.setControl((Control)this.modulesComposite);
        this.compositesList.add(this.modulesComposite);
        this.modulesController = new ModulesController(this.dataModel, this);
        this.modulesComposite.addListener(this.modulesController);
        TabItem importTab = new TabItem(this.tabFolder, 0);
        importTab.setText(AppModelio.I18N.getString("NewProjectDialog.AdvancedOptions"));
        this.importComposite = new ImportComposite((Composite)this.tabFolder, this.dataModel);
        importTab.setControl((Control)this.importComposite);
        this.compositesList.add(this.importComposite);
        this.importController = new ImportController(this.dataModel, this, this.importComposite);
        this.importComposite.addListener(this.importController);
        this.refresh();
        this.tabFolder.addSelectionListener((SelectionListener)this);
        return area;
    }

    public ImportComposite getImportComposite() {
        return this.importComposite;
    }

    public void init() {
        this.setLogoImage(null);
        this.getShell().setText(AppModelio.I18N.getString("CreateProjectDialogTitle"));
        this.setTitle(AppModelio.I18N.getString("CreateProjectDialogTitle"));
        this.setMessage(AppModelio.I18N.getString("ChooseProjectTypeMessage"));
        this.getShell().setSize(550, 500);
        this.getShell().setMinimumSize(550, 500);
    }

    public void refresh() {
        this.projectComposite.refresh();
        this.modulesComposite.refresh();
        this.importComposite.refresh();
    }

    public void setErrorMessage(String newErrorMessage) {
        super.setErrorMessage(newErrorMessage);
    }

    public void updateButtons(boolean dataOk) {
        if (this.cancelButton == null || this.createButton == null || this.previousButton == null || this.nextButton == null) {
            return;
        }
        int index = this.tabFolder.getSelectionIndex();
        if (index == 0) {
            if (this.projectController.validateData()) {
                this.previousButton.setEnabled(false);
                this.nextButton.setEnabled(true);
            } else {
                this.previousButton.setEnabled(false);
                this.nextButton.setEnabled(false);
            }
            if (dataOk) {
                this.createButton.setEnabled(true);
                this.getShell().setDefaultButton(this.createButton);
            } else {
                this.createButton.setEnabled(false);
                this.getShell().setDefaultButton(this.cancelButton);
            }
        } else if (index == 1) {
            if (this.projectController.validateData() && this.modulesController.validateData()) {
                this.previousButton.setEnabled(true);
                this.nextButton.setEnabled(true);
            } else {
                this.previousButton.setEnabled(true);
                this.nextButton.setEnabled(false);
            }
            if (dataOk) {
                this.createButton.setEnabled(true);
                this.getShell().setDefaultButton(this.createButton);
            } else {
                this.createButton.setEnabled(false);
                this.getShell().setDefaultButton(this.cancelButton);
            }
        } else if (index == 2) {
            this.previousButton.setEnabled(true);
            this.nextButton.setEnabled(false);
            if (dataOk) {
                this.createButton.setEnabled(true);
                this.getShell().setDefaultButton(this.createButton);
            } else {
                this.createButton.setEnabled(false);
                this.getShell().setDefaultButton(this.cancelButton);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent event) {
        if (this.tabFolder.equals(event.getSource())) {
            ICompositeTab tab;
            int index = this.tabFolder.getSelectionIndex();
            if (index < this.tabFolder.getItemCount() && (tab = (ICompositeTab)this.compositesList.get(index)) != null) {
                this.setMessage(tab.getMessage());
            }
            this.updateButtons(this.validateData());
        }
    }

    protected String getHelpId() {
        return "/com.modeliosoft.modelio.documentation.modeler/html/Modeler-_modeler_managing_projects_create_project.html";
    }

    protected void okPressed() {
        this.projectComposite.updateDataModel();
        super.okPressed();
    }

    protected boolean validateData() {
        return this.projectController.validateData() && this.modulesController.validateData() && this.importController.validateData();
    }

    static /* synthetic */ TabFolder access$0(ProjectCreationDialog projectCreationDialog) {
        return projectCreationDialog.tabFolder;
    }

    static /* synthetic */ List access$1(ProjectCreationDialog projectCreationDialog) {
        return projectCreationDialog.compositesList;
    }

    static /* synthetic */ void access$2(ProjectCreationDialog projectCreationDialog, String string) {
        projectCreationDialog.setMessage(string);
    }
}

