/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.app.newProject.gui;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ProjectType {
    private String description = "";
    private boolean hasInitModel = false;
    private String label = null;
    private String name = null;
    private String summary = "";
    private File file = null;
    private List<String> mdacs = new ArrayList();

    public ProjectType(String name, String[] mdacs) {
        this.name = name;
        this.description = "";
        this.hasInitModel = false;
        this.file = null;
        this.label = name;
        this.summary = "";
        String[] stringArray = mdacs;
        int n = mdacs.length;
        int n2 = 0;
        while (n2 < n) {
            String mdacName = stringArray[n2];
            this.mdacs.add(mdacName);
            ++n2;
        }
    }

    public ProjectType(File file) {
        this.file = file;
        try {
            Element projectTypeNode;
            ZipFile zipFile = new ZipFile(file);
            ZipEntry manifestEntry = zipFile.getEntry("template.xml");
            ZipEntry initEntry = zipFile.getEntry("init.ofpx");
            InputStream input = zipFile.getInputStream(manifestEntry);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setXIncludeAware(false);
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document xmlDoc = db.parse(input);
            Element projectTypeElement = projectTypeNode = xmlDoc.getDocumentElement();
            this.name = projectTypeElement.getAttribute("name");
            this.label = projectTypeElement.getAttribute("label");
            this.summary = projectTypeElement.getAttribute("summary");
            this.hasInitModel = initEntry != null;
            NodeList descriptionNodes = xmlDoc.getDocumentElement().getElementsByTagName("description");
            if (descriptionNodes.getLength() == 1) {
                StringBuffer descriptionBuffer = new StringBuffer();
                Node descriptionNode = descriptionNodes.item(0);
                NodeList childrenNodes = descriptionNode.getChildNodes();
                int i = 0;
                while (i < childrenNodes.getLength()) {
                    Node item = childrenNodes.item(i);
                    descriptionBuffer.append(item.getNodeValue());
                    if (i > 0) {
                        descriptionBuffer.append("\n");
                    }
                    ++i;
                }
                this.description = descriptionBuffer.toString();
            }
            NodeList mdacsNodes = xmlDoc.getDocumentElement().getElementsByTagName("mdac");
            int i = 0;
            while (i < mdacsNodes.getLength()) {
                Element mdacElement;
                String mdacName;
                Node mdacNode = mdacsNodes.item(i);
                if (mdacNode instanceof Element && (mdacName = (mdacElement = (Element)mdacNode).getAttribute("name")) != null && !mdacName.equals("")) {
                    this.mdacs.add(mdacName);
                }
                ++i;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getDescription() {
        return this.description;
    }

    public File getFile() {
        return this.file;
    }

    public String getLabel() {
        return this.label;
    }

    public List<String> getMdacs() {
        return this.mdacs;
    }

    public String getName() {
        return this.name;
    }

    public String getSummary() {
        return this.summary;
    }

    public boolean hasInitModel() {
        return this.hasInitModel;
    }
}

