/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.app.newProject.gui;

import com.modeliosoft.modelio.app.newProject.gui.ProjectCreationDataModel;
import com.modeliosoft.modelio.app.newProject.gui.ProjectType;
import java.util.Collection;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

class ProjectTypeProvider
implements IStructuredContentProvider,
ITableLabelProvider {
    private ProjectType[] projectTypes = null;
    private ProjectCreationDataModel dataModel = null;
    private Image selectedImage = null;
    private Image notSelectedImage = null;

    public ProjectTypeProvider(ProjectCreationDataModel dataModel) {
        this.dataModel = dataModel;
        this.selectedImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.app", (String)"icons/radio_true.png").createImage();
        this.notSelectedImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.app", (String)"icons/radio_false.png").createImage();
    }

    protected void finalize() throws Throwable {
        if (this.selectedImage != null) {
            this.selectedImage.dispose();
            this.selectedImage = null;
        }
        if (this.notSelectedImage != null) {
            this.notSelectedImage.dispose();
            this.notSelectedImage = null;
        }
        super.finalize();
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0 && element instanceof ProjectType) {
            if (element.equals(this.dataModel.getCurrentProjectType())) {
                return this.selectedImage;
            }
            return this.notSelectedImage;
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        ProjectType projectType = (ProjectType)element;
        if (columnIndex == 0) {
            return null;
        }
        if (columnIndex == 1) {
            return projectType.getLabel();
        }
        if (columnIndex == 2) {
            return projectType.getSummary();
        }
        return null;
    }

    public Object[] getElements(Object inputElement) {
        return this.projectTypes;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput != null) {
            Collection theAdapters = (Collection)newInput;
            this.projectTypes = theAdapters.toArray(new ProjectType[theAdapters.size()]);
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

