/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.app.openProject;

import com.modeliosoft.modelio.api.mdac.MdacException;
import com.modeliosoft.modelio.app.plugin.AppModelio;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.mdainfra.mdacs.core.IMdacManager;
import com.modeliosoft.modelio.mdainfra.mdacs.core.MdacManager;
import com.modeliosoft.modelio.mdainfra.mdacs.deployment.MdacDeployer;
import com.modeliosoft.modelio.mdainfra.mdacs.store.MdacArchiveInfo;
import com.modeliosoft.modelio.mdainfra.mdacs.store.MdacArchiveRepository;
import com.modeliosoft.modelio.mdainfra.mdacs.store.ModuleArchiveSorter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ModulesUpdater
implements IRunnableWithProgress {
    private IModelingSession modelingSession = null;
    private List<MdacArchiveInfo> modulesToDeploy = null;
    private MdacArchiveRepository moduleArchiveRepository = null;

    public ModulesUpdater(IModelingSession modelingSession, MdacArchiveRepository mdacArchiveRepository, List<MdacArchiveInfo> modulesToDeploy) {
        this.modelingSession = modelingSession;
        this.moduleArchiveRepository = mdacArchiveRepository;
        this.modulesToDeploy = modulesToDeploy;
    }

    public void run(IProgressMonitor aMonitor) throws InvocationTargetException, InterruptedException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)aMonitor, (String)AppModelio.I18N.getMessage("ModuleUpdater.BeginTask", new String[0]), (int)this.modulesToDeploy.size());
        List orderedModules = ModuleArchiveSorter.sort((Collection)this.modulesToDeploy);
        for (MdacArchiveInfo archivedMdac : orderedModules) {
            monitor.subTask(AppModelio.I18N.getMessage("ModuleUpdater.DeployModule", new String[]{this.getModuleLabel(archivedMdac)}));
            MdacManager mdacManager = new MdacManager(this.modelingSession);
            MdacDeployer deployer = new MdacDeployer(this.modelingSession, (IMdacManager)mdacManager);
            try {
                deployer.deployMdacs(Collections.singletonList(archivedMdac.getArchive().getPath()), (IProgressMonitor)monitor.newChild(1));
            }
            catch (MdacException e) {
                AppModelio.LOG.warning((Throwable)e);
            }
        }
        this.modelingSession.save();
    }

    private String getModuleLabel(MdacArchiveInfo archivedMdac) {
        try {
            MdacArchiveRepository.LocalizedData localizedData = this.moduleArchiveRepository.getLocalization(archivedMdac);
            if (localizedData != null) {
                return localizedData.getLabel();
            }
            return archivedMdac.getName();
        }
        catch (IOException e) {
            return "";
        }
    }
}

