/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.app.openProject;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.app.plugin.AppModelio;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.internal.app.IProjectSpace;
import com.modeliosoft.modelio.internal.app.IWorkspace;
import com.modeliosoft.modelio.internal.app.services.App;
import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenProjectHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.openProject();
        return null;
    }

    public boolean isEnabled() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && App.getInstance().getOpenedProject() == null;
    }

    public boolean isHandled() {
        return true;
    }

    public void execute() {
        this.openProject();
    }

    private void openProject() {
        App app = App.getInstance();
        IWorkspace workspace = app.getWorkspace();
        IProjectSpace projectSpace = workspace.getSelectedProjectSpace();
        if (projectSpace != null) {
            try {
                app.openProject(projectSpace);
                try {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    page.showView("com.modeliosoft.modelio.explorer.UmlNavigatorContentID", null, 1);
                }
                catch (PartInitException page) {
                    // empty catch block
                }
                IModelingSession modelingSession = app.getOpenedProject().getSession();
                O.getDefault().getNavigateService().fireNavigate((IElement)modelingSession.getModel().getProject().getModel());
            }
            catch (IOException e) {
                AppModelio.LOG.error((Throwable)e);
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)AppModelio.I18N.getMessage("OpenProjectHandler.OpenFailedTitle", new String[]{projectSpace.getName()}), (String)AppModelio.I18N.getMessage("OpenProjectHandler.OpenFailedMsg", new String[]{projectSpace.getName(), e.getLocalizedMessage()}));
            }
            catch (Exception e) {
                AppModelio.LOG.error((Throwable)e);
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)AppModelio.I18N.getMessage("OpenProjectHandler.OpenFailedTitle", new String[]{projectSpace.getName()}), (String)AppModelio.I18N.getMessage("OpenProjectHandler.OpenFailedMsg", new String[]{projectSpace.getName(), e.getLocalizedMessage()}));
            }
        }
    }
}

