/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.ui;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.ui.dnd.EditorDropListener;
import com.modeliosoft.modelio.api.ui.dnd.IEditorDropClient;
import com.modeliosoft.modelio.api.ui.dnd.ModelElementTransfer;
import com.modeliosoft.modelio.api.utils.UMLMetaclassName;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.app.events.IPickingClient;
import com.modeliosoft.modelio.core.model.ElementFinder;
import com.modeliosoft.modelio.core.model.IElementFilter;
import com.modeliosoft.modelio.ui.IElementChangeListener;
import com.modeliosoft.modelio.ui.Messages;
import com.modeliosoft.modelio.ui.ResultsProposalPopup;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class TextWrapperForIElement
implements IPickingClient,
IEditorDropClient {
    private IElement selectedElement;
    private EditorDropListener dropListener;
    private IElementFilter elementFilter = null;
    private boolean acceptNullValue;
    private Set<IElementChangeListener> listeners;
    private List<Class<? extends IElement>> allowedMetaclasses;
    protected Text textField;
    private KeyAdapter keyListener = new /* Unavailable Anonymous Inner Class!! */;
    private FocusListener selectionListener = new /* Unavailable Anonymous Inner Class!! */;
    protected static Image indicatorImage;

    static {
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.ui", (String)"icons/indicator.png");
        indicatorImage = imageDescriptor != null ? imageDescriptor.createImage() : null;
    }

    public TextWrapperForIElement(Composite parent, IElement initialElement, boolean acceptNullValue, List<Class<? extends IElement>> allowedMetaclasses) {
        this.selectedElement = initialElement;
        this.acceptNullValue = acceptNullValue;
        this.allowedMetaclasses = allowedMetaclasses;
        this.createContent(parent);
    }

    protected void onKeyPressed(KeyEvent e) {
        if (e.character == '\r') {
            ElementFinder finder = new ElementFinder(O.getDefault().getModelingSession());
            List elements = finder.findByName(this.allowedMetaclasses, this.textField.getText(), this.elementFilter);
            if (elements.isEmpty()) {
                String filter = String.valueOf(this.textField.getText()) + ".*";
                elements = finder.search(this.allowedMetaclasses, filter, this.elementFilter);
                if (elements.isEmpty()) {
                    this.setContent(null);
                } else if (elements.size() == 1) {
                    this.setContent((IElement)elements.get(0));
                } else {
                    ResultsProposalPopup rp = new ResultsProposalPopup((Control)this.textField, elements, this.acceptNullValue);
                    IModelElement selected = (IModelElement)rp.getChoice();
                    this.setContent((IElement)selected);
                }
            } else if (elements.size() == 1) {
                this.setContent((IElement)elements.get(0));
            } else {
                ResultsProposalPopup rp = new ResultsProposalPopup((Control)this.textField, elements, this.acceptNullValue);
                IModelElement selected = (IModelElement)rp.getChoice();
                this.setContent((IElement)selected);
            }
            return;
        }
        if (e.character == ' ' && (e.stateMask & 0x40000) != 0) {
            String filter = String.valueOf(this.textField.getText()) + ".*";
            ElementFinder finder = new ElementFinder(O.getDefault().getModelingSession());
            List elements = finder.search(this.allowedMetaclasses, filter, this.elementFilter);
            if (elements.isEmpty()) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString((String)"HybridNotFoundTitle"), (String)Messages.getString((String)"HybridNotFoundMessage"));
                this.validate(false);
            } else if (elements.size() == 1 && !this.acceptNullValue) {
                this.setContent((IElement)elements.get(0));
            } else {
                ResultsProposalPopup rp = new ResultsProposalPopup((Control)this.textField, elements, this.acceptNullValue);
                IModelElement selected = (IModelElement)rp.getChoice();
                this.setContent((IElement)selected);
            }
        } else if (e.character == '\u001b') {
            this.validate(false);
        }
    }

    protected void startPickingSession() {
        if (this.selectedElement != null) {
            String initialValue = this.selectedElement.getName();
            this.textField.setText(initialValue);
        }
        this.textField.selectAll();
        O.getDefault().getPickingClientService().beginPicking((IPickingClient)this);
    }

    public void createContent(Composite parent) {
        this.textField = new Text(parent, 2048);
        StringBuffer helpTooltip = new StringBuffer();
        if (this.allowedMetaclasses.size() > 1) {
            helpTooltip.append(Messages.getString((String)"AcceptedTypes"));
        } else if (this.allowedMetaclasses.size() == 1) {
            helpTooltip.append(Messages.getString((String)"AcceptedType"));
        }
        helpTooltip.append("\n");
        for (Class clazz : this.allowedMetaclasses) {
            helpTooltip.append("    ");
            if (clazz == String.class) {
                helpTooltip.append(Messages.getString((String)"AnyStringValue"));
            } else {
                helpTooltip.append(clazz.getAnnotation(UMLMetaclassName.class).value());
            }
            helpTooltip.append("\n");
        }
        helpTooltip.append("\n");
        helpTooltip.append(Messages.getString((String)"HybridCellEditorTootip"));
        this.textField.setToolTipText(helpTooltip.toString());
        this.textField.addPaintListener((PaintListener)new /* Unavailable Anonymous Inner Class!! */);
        if (this.selectedElement != null) {
            String text = this.selectedElement.getName();
            if (this.selectedElement.getCompositionOwner() != null) {
                text = String.valueOf(text) + "  (from " + ((IModelElement)this.selectedElement.getCompositionOwner()).getName() + ")";
            }
            this.textField.setData((Object)this.selectedElement);
            this.textField.setText(text);
        }
        this.textField.addKeyListener((KeyListener)this.keyListener);
        this.textField.addFocusListener(this.selectionListener);
        this.initDropTarget();
    }

    private void setContent(IElement content) {
        if (content != null) {
            IModelElement me = (IModelElement)content;
            String text = me.getName();
            if (me.getCompositionOwner() != null) {
                text = String.valueOf(text) + "  (from " + ((IModelElement)me.getCompositionOwner()).getName() + ")";
            }
            this.textField.setData((Object)content);
            this.textField.setText(text);
            this.validate(true);
        } else {
            this.textField.setData(null);
            this.validate(true);
        }
    }

    public boolean acceptElement(IElement target) {
        for (Class c : this.allowedMetaclasses) {
            if (!c.isAssignableFrom(target.getClass())) continue;
            return true;
        }
        return target == null && this.acceptNullValue;
    }

    public boolean setElement(IElement target) {
        if (this.acceptElement(target)) {
            this.setContent(target);
            return true;
        }
        return false;
    }

    private void validate(boolean save) {
        this.endPickingSession();
        if (save) {
            IElement oldElement = this.selectedElement;
            this.selectedElement = (IModelElement)this.textField.getData();
            this.fireSelectedElementChanged(oldElement, this.selectedElement);
        }
    }

    private void initDropTarget() {
        this.dropListener = new EditorDropListener((IEditorDropClient)this);
        int operations = 3;
        Transfer[] types = new Transfer[]{ModelElementTransfer.getInstance(), PluginTransfer.getInstance()};
        DropTarget target = new DropTarget((Control)this.textField, operations);
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)this.dropListener);
    }

    public boolean acceptDroppedElements(IElement[] target) {
        if (target.length != 1) {
            return false;
        }
        for (Class c : this.allowedMetaclasses) {
            if (!c.isAssignableFrom(target[0].getClass())) continue;
            return true;
        }
        return false;
    }

    public void setDroppedElements(IElement[] dropedElement) {
        if (this.acceptElement(dropedElement[0])) {
            this.setContent(dropedElement[0]);
        }
    }

    public void pickingAborted() {
        this.endPickingSession();
    }

    public void setElementFilter(IElementFilter elementFilter) {
        this.elementFilter = elementFilter;
    }

    public void addListener(IElementChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        this.listeners.add(listener);
    }

    public void removeListener(IElementChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    private void fireSelectedElementChanged(IElement oldElement, IElement newElement) {
        if (this.listeners != null) {
            for (IElementChangeListener listener : this.listeners) {
                listener.selectedElementChanged(oldElement, newElement);
            }
        }
    }

    public Text getTextField() {
        return this.textField;
    }

    protected void endPickingSession() {
        try {
            O.getDefault().getPickingClientService().endPicking((IPickingClient)this);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

