/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.ui.i18n;

import com.modeliosoft.modelio.core.log.LOG;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class BundledMessages {
    private ResourceBundle bundle;
    private String pluginId;

    public BundledMessages(String pluginId, ResourceBundle bundle) {
        this.pluginId = pluginId;
        this.bundle = bundle;
    }

    public String getMessage(String key, String ... strings) {
        String pattern;
        try {
            pattern = this.bundle.getString(key);
        }
        catch (MissingResourceException e) {
            LOG.error((String)this.pluginId, (String)"No I18n message for '%s'", (Object[])new Object[]{key});
            pattern = "!" + key + "!";
        }
        return MessageFormat.format(pattern, strings);
    }

    public String getString(String key) {
        String pattern;
        try {
            pattern = this.bundle.getString(key);
        }
        catch (MissingResourceException e) {
            LOG.error((String)this.pluginId, (String)"No I18n message for '%s'", (Object[])new Object[]{key});
            pattern = "!" + key + "!";
        }
        return pattern;
    }
}

