/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.ui.menu.contextual;

import com.modeliosoft.modelio.core.app.StandardImageService;
import com.modeliosoft.modelio.ui.menu.contextual.CommandModel;
import com.modeliosoft.modelio.ui.menu.contextual.ItemModel;
import com.modeliosoft.modelio.ui.menu.contextual.MenuModel;
import com.modeliosoft.modelio.ui.menu.contextual.SeparatorModel;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ContextMenuModel {
    protected Map<String, List<ItemModel>> itemsMetaclassMap = new HashMap();
    private final ResourceBundle propertiesBundle;

    public ContextMenuModel(URL definitions, ResourceBundle propertiesBundle) {
        this.propertiesBundle = propertiesBundle;
        this.loadXML(definitions);
    }

    public void loadXML(URL url) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setXIncludeAware(false);
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputStream xmlStream = url.openStream();
            Document xmlDoc = db.parse(xmlStream);
            Element rootElement = xmlDoc.getDocumentElement();
            this.parseMenus(rootElement);
            xmlStream.close();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<ItemModel> getItems(String metaclass, String stereotype) {
        String key = String.valueOf(metaclass) + (stereotype != null ? stereotype : "");
        List actions = (List)this.itemsMetaclassMap.get(key);
        if (actions != null) {
            return actions;
        }
        return new ArrayList<ItemModel>();
    }

    @Deprecated
    public List<ItemModel> getItems(String metaclass) {
        return this.getItems(metaclass, null);
    }

    private void parseMenus(Element rootElement) {
        NodeList childNodes = rootElement.getChildNodes();
        int nNodes = childNodes.getLength();
        int i = 0;
        while (i < nNodes) {
            Node node = childNodes.item(i);
            if (node.getNodeName().equals("popup")) {
                this.parsePopupNode(node);
            }
            ++i;
        }
    }

    private void parsePopupNode(Node popupNode) {
        NamedNodeMap attributes = popupNode.getAttributes();
        String metaclassName = "";
        String stereotypeName = "";
        if (attributes != null) {
            Node stereotypeNode;
            Node metaclassNode = attributes.getNamedItem("metaclass");
            if (metaclassNode != null) {
                metaclassName = metaclassNode.getTextContent();
            }
            if ((stereotypeNode = attributes.getNamedItem("stereotype")) != null) {
                stereotypeName = stereotypeNode.getTextContent();
            }
        }
        ArrayList<Object> entriesList = new ArrayList<Object>();
        this.itemsMetaclassMap.put(String.valueOf(metaclassName) + stereotypeName, entriesList);
        NodeList menuNodes = popupNode.getChildNodes();
        int nNodes = menuNodes.getLength();
        int i = 0;
        while (i < nNodes) {
            Node node = menuNodes.item(i);
            if (node.getNodeName().equals("item")) {
                CommandModel commandModel = this.parseItemNode(node);
                if (commandModel != null) {
                    entriesList.add(commandModel);
                }
            } else if (node.getNodeName().equals("menu")) {
                MenuModel menuModel = this.parseMenuNode(node);
                if (menuModel != null) {
                    entriesList.add(menuModel);
                }
            } else if (node.getNodeName().equals("separator")) {
                entriesList.add(this.parseSeparatorNode(node));
            }
            ++i;
        }
    }

    private CommandModel parseItemNode(Node itemNode) {
        CommandModel commandModel = this.createCommandModel(itemNode);
        NodeList childNodes = itemNode.getChildNodes();
        int nNodes = childNodes.getLength();
        int i = 0;
        while (i < nNodes) {
            Node node = childNodes.item(i);
            if (node.getNodeName().equals("parameter")) {
                this.parseParameterNode(node, commandModel);
            }
            ++i;
        }
        return commandModel;
    }

    private MenuModel parseMenuNode(Node menuNode) {
        MenuModel menuModel = this.createMenu(menuNode);
        if (menuModel != null) {
            NodeList subMenusNodes = menuNode.getChildNodes();
            int i = 0;
            while (i < subMenusNodes.getLength()) {
                Node node = subMenusNodes.item(i);
                if (node.getNodeName().equals("item")) {
                    CommandModel commandModel = this.parseItemNode(node);
                    if (commandModel != null) {
                        menuModel.add((ItemModel)commandModel);
                    }
                } else if (node.getNodeName().equals("menu")) {
                    MenuModel submenuModel = this.parseMenuNode(node);
                    if (submenuModel != null) {
                        menuModel.add((ItemModel)submenuModel);
                    }
                } else if (node.getNodeName().equals("separator")) {
                    menuModel.add((ItemModel)this.parseSeparatorNode(node));
                }
                ++i;
            }
        }
        return menuModel;
    }

    private CommandModel createCommandModel(Node itemNode) {
        String symbolicName;
        String tooltip;
        String label;
        NamedNodeMap itemAttributes = itemNode.getAttributes();
        String commandId = "";
        String labelId = "";
        String tooltipId = "";
        String iconId = "";
        if (itemAttributes != null) {
            Node iconNode;
            Node tooltipNode;
            Node labelNode;
            Node commandIdNode = itemAttributes.getNamedItem("commandId");
            if (commandIdNode != null) {
                commandId = commandIdNode.getTextContent();
            }
            if ((labelNode = itemAttributes.getNamedItem("label")) != null) {
                labelId = labelNode.getTextContent();
            }
            if ((tooltipNode = itemAttributes.getNamedItem("tooltip")) != null) {
                tooltipId = tooltipNode.getTextContent();
            }
            if ((iconNode = itemAttributes.getNamedItem("icon")) != null) {
                iconId = iconNode.getTextContent();
            }
        }
        try {
            label = this.propertiesBundle.getString(labelId);
        }
        catch (MissingResourceException e) {
            label = labelId;
        }
        try {
            tooltip = this.propertiesBundle.getString(tooltipId);
        }
        catch (MissingResourceException e) {
            tooltip = tooltipId;
        }
        try {
            symbolicName = this.propertiesBundle.getString(iconId);
        }
        catch (MissingResourceException e) {
            symbolicName = iconId;
        }
        ImageDescriptor image = null;
        if (!symbolicName.equals("")) {
            image = StandardImageService.getImageDescriptor((String)symbolicName);
        }
        CommandModel commandModel = new CommandModel(commandId, label, tooltip, image);
        return commandModel;
    }

    private MenuModel createMenu(Node menuNode) {
        Node idNode;
        NamedNodeMap menuAttributes = menuNode.getAttributes();
        String id = "";
        if (menuAttributes != null && (idNode = menuAttributes.getNamedItem("id")) != null) {
            id = idNode.getTextContent();
        }
        if (id != null && !id.equals("")) {
            String label;
            String labelId = String.valueOf(id) + ".label";
            String bitmapId = String.valueOf(id) + ".bitmap";
            try {
                label = this.propertiesBundle.getString(labelId);
            }
            catch (MissingResourceException e) {
                label = labelId;
            }
            try {
                String bitmap = this.propertiesBundle.getString(bitmapId);
            }
            catch (MissingResourceException e) {
                String bitmap = "";
            }
            ImageDescriptor image = null;
            MenuModel subMenu = new MenuModel(label, id, image);
            return subMenu;
        }
        return null;
    }

    private SeparatorModel parseSeparatorNode(Node separatorNode) {
        return this.createSeparator(separatorNode);
    }

    private SeparatorModel createSeparator(Node separatorNode) {
        Node commandIdNode;
        NamedNodeMap itemAttributes = separatorNode.getAttributes();
        String id = "";
        if (itemAttributes != null && (commandIdNode = itemAttributes.getNamedItem("id")) != null) {
            id = commandIdNode.getTextContent();
        }
        SeparatorModel model = new SeparatorModel(id);
        return model;
    }

    private void parseParameterNode(Node parameterNode, CommandModel commandModel) {
        NamedNodeMap attributes = parameterNode.getAttributes();
        String name = "";
        String value = "";
        if (attributes != null) {
            Node valueNode;
            Node nameNode = attributes.getNamedItem("name");
            if (nameNode != null) {
                name = nameNode.getTextContent();
            }
            if ((valueNode = attributes.getNamedItem("value")) != null) {
                value = valueNode.getTextContent();
            }
            commandModel.getParameters().put(name, value);
        }
    }
}

