/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mda.services.addStereotypeService.gui;

import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.mda.services.addStereotypeService.gui.StereotypeChooserContentProvider;
import com.modeliosoft.modelio.mda.services.addStereotypeService.gui.StereotypeChooserDriver;
import com.modeliosoft.modelio.mda.services.addStereotypeService.gui.StereotypeChooserLabelProvider;
import com.modeliosoft.modelio.mda.services.addStereotypeService.gui.StereotypeChooserMdacAdapter;
import com.modeliosoft.modelio.mda.services.addStereotypeService.gui.StereotypeChooserModel;
import com.modeliosoft.modelio.mda.services.addStereotypeService.gui.StereotypeChooserSorter;
import com.modeliosoft.modelio.mda.services.addStereotypeService.gui.StereotypeChooserStereotypeAdapter;
import com.modeliosoft.modelio.mda.services.elementChooser.IElementChooserDriver;
import com.modeliosoft.modelio.mda.services.utils.Messages;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;

public class StereotypeChooserDriver
implements IElementChooserDriver {
    IModelingSession session;
    private TreeViewer leftViewer;
    private StereotypeChooserModel leftModel;
    private IModelElement element;
    private IStereotype createdStereotype;
    private StereotypeChooserSelectionListener stereotypeSelectionListener = null;
    private IModule selectedModule = null;

    public StereotypeChooserDriver(IModelingSession session, IModule selectedModule) {
        this.session = session;
        this.selectedModule = selectedModule;
        this.createdStereotype = null;
        this.stereotypeSelectionListener = new StereotypeChooserSelectionListener(this);
    }

    protected void finalize() throws Throwable {
        this.leftViewer.removeSelectionChangedListener((ISelectionChangedListener)this.stereotypeSelectionListener);
        super.finalize();
    }

    public StructuredViewer createViewer(Composite parent) {
        this.leftViewer = new TreeViewer(parent, 2050);
        this.leftViewer.setContentProvider((IContentProvider)new StereotypeChooserContentProvider());
        this.leftViewer.setLabelProvider((IBaseLabelProvider)new StereotypeChooserLabelProvider(this.session));
        this.leftViewer.setSorter((ViewerSorter)new StereotypeChooserSorter());
        this.leftViewer.setAutoExpandLevel(-1);
        this.leftViewer.addSelectionChangedListener((ISelectionChangedListener)this.stereotypeSelectionListener);
        return this.leftViewer;
    }

    public IStereotype getCreatedStereotype() {
        return this.createdStereotype;
    }

    public String getLeftLabel() {
        return Messages.getString((String)"StereotypeChooser.AddStereotypeLeftLabel");
    }

    public String getMessage() {
        return Messages.getString((String)"StereotypeChooser.Message");
    }

    public String getShellTitle() {
        return Messages.getString((String)"StereotypeChooser.ShellTitle");
    }

    public String getTitle() {
        return Messages.getString((String)"StereotypeChooser.Title");
    }

    public void init(IElement theElement) {
        if (theElement instanceof IModelElement) {
            this.element = (IModelElement)theElement;
            this.leftModel = new StereotypeChooserModel(this.session, this.element);
            this.leftViewer.setInput((Object)this.leftModel);
            this.setExpandedState();
        }
    }

    public void performCancel() {
    }

    public void performFinish(StructuredViewer theViewer, List<Object> selection) {
        ITransactionManager manager = this.session.getTransactionManager();
        ITransaction transaction = manager.createTransaction(Messages.getString((String)"StereotypeChooser.AddStereotype"));
        try {
            try {
                for (Object obj : selection) {
                    StereotypeChooserStereotypeAdapter adapter = (StereotypeChooserStereotypeAdapter)obj;
                    this.createdStereotype = adapter.getStereotype();
                    ObList ownedStereotypes = this.element.getExtension();
                    if (!ownedStereotypes.contains((Object)this.createdStereotype)) {
                        this.element.addExtension(this.createdStereotype);
                        continue;
                    }
                    this.createdStereotype = null;
                }
                manager.commit(transaction);
                transaction = null;
            }
            catch (InvalidTransactionException e) {
                this.createdStereotype = null;
                transaction = null;
                if (transaction != null) {
                    this.createdStereotype = null;
                    manager.rollback(transaction);
                }
            }
        }
        finally {
            if (transaction != null) {
                this.createdStereotype = null;
                manager.rollback(transaction);
            }
        }
    }

    private void setExpandedState() {
        StereotypeChooserMdacAdapter adapter = this.leftModel.getMdacAdapter(this.selectedModule);
        if (adapter != null) {
            Object[] adapters = new StereotypeChooserMdacAdapter[]{adapter};
            this.leftViewer.setExpandedElements(adapters);
        } else {
            this.leftViewer.setAutoExpandLevel(2);
        }
    }

    static /* synthetic */ TreeViewer access$0(StereotypeChooserDriver stereotypeChooserDriver) {
        return stereotypeChooserDriver.leftViewer;
    }
}

