/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mda.services.addStereotypeService.gui;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.StandardImageService;
import com.modeliosoft.modelio.core.mdacs.IMdacRegistry;
import com.modeliosoft.modelio.core.model.IMetamodelExtensions;
import com.modeliosoft.modelio.mda.services.addStereotypeService.gui.StereotypeChooserMdacAdapter;
import com.modeliosoft.modelio.mda.services.addStereotypeService.gui.StereotypeChooserStereotypeAdapter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class StereotypeChooserLabelProvider
extends LabelProvider {
    private IModelingSession modelingSession = null;

    public Image getImage(Object element) {
        if (element instanceof StereotypeChooserMdacAdapter) {
            StereotypeChooserMdacAdapter adapter = (StereotypeChooserMdacAdapter)element;
            IModule module = adapter.getMdac();
            return this.getModuleImage(module);
        }
        if (element instanceof StereotypeChooserStereotypeAdapter) {
            ImageDescriptor desc;
            StereotypeChooserStereotypeAdapter stereotypeAdapter = (StereotypeChooserStereotypeAdapter)element;
            Image image = this.getStereotypeImage(stereotypeAdapter.getStereotype());
            if (image == null && (image = StandardImageService.getImage((String)"dot.blue")) == null && (desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.mda.services", (String)"icons/dot_16.png")) != null) {
                StandardImageService.declareImage((String)"dot.blue", (ImageDescriptor)desc);
                image = StandardImageService.getImage((String)"dot.blue");
            }
            return image;
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof StereotypeChooserMdacAdapter) {
            IMdacRegistry mdacRegistry;
            IMdac module;
            StereotypeChooserMdacAdapter adapter = (StereotypeChooserMdacAdapter)element;
            if (this.modelingSession != null && (module = (mdacRegistry = this.modelingSession.getMdacRegistry()).getLoadedMdac(adapter.getMdac())) != null) {
                return module.getLabel();
            }
            return adapter.getMdac().getName();
        }
        if (element instanceof StereotypeChooserStereotypeAdapter) {
            StringBuffer stereotypeLabel = new StringBuffer();
            StereotypeChooserStereotypeAdapter adapter = (StereotypeChooserStereotypeAdapter)element;
            stereotypeLabel.append("\u00ab ");
            String label = adapter.getStereotype().getLabel();
            if (!label.isEmpty()) {
                stereotypeLabel.append(label);
            } else {
                stereotypeLabel.append(adapter.getStereotype().getName());
            }
            stereotypeLabel.append(" \u00bb");
            return stereotypeLabel.toString();
        }
        return element.toString();
    }

    private Image getStereotypeImage(IStereotype stereotype) {
        IMdac mdac;
        IMetamodelExtensions metamodelExtensions = this.modelingSession.getModel().getMetamodelExtensions();
        IModule module = metamodelExtensions.getModule(stereotype);
        if (module != null && (mdac = this.modelingSession.getMdacRegistry().getLoadedMdac(module)) != null) {
            return mdac.getImage(stereotype, IMdac.ImageType.ICON);
        }
        return null;
    }

    public StereotypeChooserLabelProvider(IModelingSession modelingSession) {
        this.modelingSession = modelingSession;
    }

    private Image getModuleImage(IModule moduleModel) {
        ImageDescriptor defaultModuleDescriptor;
        IMdacRegistry mdacRegistry;
        IMdac module;
        String key = "MDAC." + moduleModel.getName();
        Image moduleImage = StandardImageService.getImage((String)key);
        if (moduleImage != null) {
            return moduleImage;
        }
        if (this.modelingSession != null && (module = (mdacRegistry = this.modelingSession.getMdacRegistry()).getLoadedMdac(moduleModel)) != null) {
            ImageDescriptor moduleImageDescriptor = module.getMdacImageDescriptor();
            if (moduleImageDescriptor != null) {
                StandardImageService.declareImage((String)key, (ImageDescriptor)moduleImageDescriptor);
                moduleImage = StandardImageService.getImage((String)key);
            }
            if (moduleImage != null) {
                return moduleImage;
            }
        }
        if ((moduleImage = StandardImageService.getImage((String)"DefaultModuleImage")) == null && (defaultModuleDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.mda.services", (String)"icons/mdacomponent_16.png")) != null) {
            StandardImageService.declareImage((String)"DefaultModuleImage", (ImageDescriptor)defaultModuleDescriptor);
            moduleImage = StandardImageService.getImage((String)"DefaultModuleImage");
        }
        return moduleImage;
    }
}

