/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mda.services.addStereotypeService.gui;

import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.model.IMetamodelExtensions;
import com.modeliosoft.modelio.mda.services.addStereotypeService.gui.StereotypeChooserMdacAdapter;
import com.modeliosoft.modelio.mda.services.addStereotypeService.gui.StereotypeChooserStereotypeAdapter;
import java.util.HashMap;
import java.util.Map;

public class StereotypeChooserModel {
    private IModelingSession session;
    private IModelElement element;
    Map<IModule, StereotypeChooserMdacAdapter> mdacAdapters;

    public StereotypeChooserModel(IModelingSession session, IModelElement element) {
        this.session = session;
        this.element = element;
        this.mdacAdapters = new HashMap();
        this.init();
    }

    private void init() {
        if (this.session == null) {
            return;
        }
        IMetamodelExtensions extensions = this.session.getModel().getMetamodelExtensions();
        ObList existingStereotypes = this.element.getExtension();
        for (IStereotype stereotype : extensions.getStereotypes(this.element.getClass())) {
            IModule module;
            if (stereotype.isHidden() || existingStereotypes.contains((Object)stereotype) || (module = extensions.getModule(stereotype)) == null || this.session.getMdacRegistry().getStartedMdac(module) == null) continue;
            this.addStereotype(module, stereotype);
        }
    }

    private StereotypeChooserStereotypeAdapter addStereotype(IModule mdac, IStereotype stereotype) {
        StereotypeChooserMdacAdapter adapter = (StereotypeChooserMdacAdapter)this.mdacAdapters.get(mdac);
        if (adapter == null) {
            adapter = new StereotypeChooserMdacAdapter(mdac);
            this.mdacAdapters.put(mdac, adapter);
        }
        return adapter.addStereotype(stereotype, this.element);
    }

    public Map<IModule, StereotypeChooserMdacAdapter> getMdacAdapters() {
        return this.mdacAdapters;
    }

    public StereotypeChooserMdacAdapter getMdacAdapter(IModule module) {
        return (StereotypeChooserMdacAdapter)this.mdacAdapters.get(module);
    }
}

