/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.mda.services.elementChooser;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.ui.ModelioDialog;
import com.modeliosoft.modelio.mda.services.elementChooser.IElementChooserDriver;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ElementChooserDlg
extends ModelioDialog {
    private Label leftViewerLabel;
    private StructuredViewer leftViewer;
    private IElement input;
    private IElementChooserDriver driver;

    public ElementChooserDlg(Shell parentShell, IElementChooserDriver chooserDriver, IModelElement input) {
        super(parentShell);
        this.driver = chooserDriver;
        this.input = input;
    }

    public void addButtonsInButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public Control createContentArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        GridLayout compositeLayout = new GridLayout(3, false);
        compositeLayout.marginWidth = 3;
        compositeLayout.marginHeight = 3;
        compositeLayout.verticalSpacing = 0;
        compositeLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)compositeLayout);
        Composite leftViewerComposite = new Composite(composite, 0);
        GridData leftViewerCompositeData = new GridData(1808);
        leftViewerComposite.setLayoutData((Object)leftViewerCompositeData);
        FormLayout leftViewerLayout = new FormLayout();
        leftViewerComposite.setLayout((Layout)leftViewerLayout);
        this.leftViewerLabel = new Label(leftViewerComposite, 0);
        this.leftViewerLabel.setText(this.driver.getLeftLabel());
        this.leftViewer = this.driver.createViewer(leftViewerComposite);
        FormData leftViewerData = new FormData();
        leftViewerData.left = new FormAttachment(0, 0);
        leftViewerData.right = new FormAttachment(100, 0);
        leftViewerData.top = new FormAttachment((Control)this.leftViewerLabel, 3);
        leftViewerData.bottom = new FormAttachment(100, 0);
        this.leftViewer.getControl().setLayoutData((Object)leftViewerData);
        this.leftViewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        return composite;
    }

    public void init() {
        this.getShell().setText(this.driver.getShellTitle());
        this.setTitle(this.driver.getTitle());
        this.setMessage(this.driver.getMessage());
        Shell parentShell = this.getShell().getParent().getShell();
        Point shellLocation = parentShell.getLocation();
        this.getShell().setSize(500, 500);
        this.getShell().setLocation(shellLocation.x + 300, shellLocation.y + 300);
        this.setLogoImage(null);
        this.driver.init(this.input);
    }

    public void setLeftLabel(String label) {
        this.leftViewerLabel.setText(label);
    }

    protected void cancelPressed() {
        this.driver.performCancel();
        super.cancelPressed();
    }

    protected void okPressed() {
        ISelection selection = this.leftViewer.getSelection();
        List selectedElements = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            selectedElements = structuredSelection.toList();
        }
        this.driver.performFinish(this.leftViewer, selectedElements);
        super.okPressed();
    }

    public Label getLeftViewerLabel() {
        return this.leftViewerLabel;
    }

    public StructuredViewer getLeftViewer() {
        return this.leftViewer;
    }

    public IElement getInput() {
        return this.input;
    }

    public IElementChooserDriver getDriver() {
        return this.driver;
    }
}

