/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.common.abstractdiagram;

import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.AbstractDiagramFigure;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.ConstraintFinalizationEditPolicy;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.DiagramElementDropEditPolicy;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagramStyleKeys;
import com.modeliosoft.modelio.diagram.elements.common.linktovoid.LinkToVoidFinishCreationEditPolicy;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeEditPart;
import com.modeliosoft.modelio.diagram.styles.core.IStyle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.XYAnchor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class AbstractDiagramEditPart
extends GmNodeEditPart {
    public static final String PROPERTY_GRID_COLOR = "AbstractDiagramEditPart.GridColor";
    public static final String PROPERTY_GRID_ALPHA = "AbstractDiagramEditPart.GridAlpha";
    public static final String PROPERTY_FILL_COLOR = "AbstractDiagramEditPart.FillColor";
    public static final String PROPERTY_FILL_IMAGE = "AbstractDiagramEditPart.FillImage";
    public static final String PROPERTY_FILL_ALPHA = "AbstractDiagramEditPart.FillAlpha";
    public static final String PROPERTY_FILL_TILE_SIZE = "AbstractDiagramEditPart.FillTileSize";

    public void activate() {
        super.activate();
    }

    public Object getAdapter(Class type) {
        boolean snap;
        if (type == SnapToHelper.class && (snap = this.getModelStyle().getBoolean(GmAbstractDiagramStyleKeys.SNAPTOGRID))) {
            return new SnapToGrid((GraphicalEditPart)this);
        }
        return super.getAdapter(type);
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        if (request instanceof ReconnectRequest) {
            Point p = ((ReconnectRequest)request).getLocation();
            return new XYAnchor(p);
        }
        if (request instanceof DropRequest) {
            Point p = ((DropRequest)request).getLocation();
            return new XYAnchor(p);
        }
        throw new IllegalArgumentException(request + " not handled.");
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy((Object)"DROPELEMENT", (EditPolicy)new DiagramElementDropEditPolicy());
        this.installEditPolicy((Object)"DirectEditPolicy", null);
        LinkToVoidFinishCreationEditPolicy linkTovoidEditPolicy = new LinkToVoidFinishCreationEditPolicy();
        this.installEditPolicy((Object)"Link to void end", (EditPolicy)linkTovoidEditPolicy);
        this.installEditPolicy((Object)"Constraint", (EditPolicy)new ConstraintFinalizationEditPolicy());
    }

    protected void refreshFromStyle(IFigure aFigure, IStyle style) {
        PrecisionDimension inchPageSize;
        AbstractDiagramFigure diagramFigure = (AbstractDiagramFigure)aFigure;
        boolean viewGrid = style.getBoolean(GmAbstractDiagramStyleKeys.VIEWGRID);
        boolean snapToGrid = style.getBoolean(GmAbstractDiagramStyleKeys.SNAPTOGRID);
        Color gridColor = style.getColor(GmAbstractDiagramStyleKeys.GRIDCOLOR);
        int gridAlpha = style.getInteger(GmAbstractDiagramStyleKeys.GRIDALPHA);
        int gridSpacing = style.getInteger(GmAbstractDiagramStyleKeys.GRIDSPACING);
        Color fillColor = style.getColor(GmAbstractDiagramStyleKeys.FILLCOLOR);
        String fillImage = (String)style.getProperty(GmAbstractDiagramStyleKeys.FILLIMAGE);
        int fillAlpha = style.getInteger(GmAbstractDiagramStyleKeys.FILLALPHA);
        String pageSize = (String)style.getProperty(GmAbstractDiagramStyleKeys.PAGE_SIZE);
        PrecisionDimension pixelPageSize = null;
        if (pageSize != null && !pageSize.isEmpty() && (inchPageSize = this.parsePageSize(pageSize)) != null) {
            pixelPageSize = this.convertToPixel(inchPageSize);
        }
        EditPartViewer v = this.getRoot().getViewer();
        v.setProperty("SnapToGrid.isVisible", (Object)new Boolean(viewGrid));
        v.setProperty("SnapToGrid.isEnabled", (Object)new Boolean(snapToGrid));
        v.setProperty("SnapToGrid.GridSpacing", (Object)new Dimension(gridSpacing, gridSpacing));
        v.setProperty(PROPERTY_GRID_COLOR, (Object)gridColor);
        v.setProperty(PROPERTY_GRID_ALPHA, (Object)new Integer(gridAlpha));
        v.setProperty(PROPERTY_FILL_COLOR, (Object)fillColor);
        v.setProperty(PROPERTY_FILL_IMAGE, (Object)fillImage);
        v.setProperty(PROPERTY_FILL_ALPHA, (Object)new Integer(fillAlpha));
        diagramFigure.showPageBoundaries(style.getBoolean(GmAbstractDiagramStyleKeys.SHOW_PAGES));
        v.setProperty(PROPERTY_FILL_TILE_SIZE, (Object)pixelPageSize);
        diagramFigure.setPageBoundaries((Dimension)pixelPageSize);
    }

    private PrecisionDimension convertMmToInch(PrecisionDimension d) {
        if (d == null) {
            return null;
        }
        float factor = 25.4f;
        return new PrecisionDimension(d.preciseWidth() / (double)25.4f, d.preciseHeight() / (double)25.4f);
    }

    private PrecisionDimension convertToPixel(PrecisionDimension d) {
        org.eclipse.swt.graphics.Point dpi = Display.getCurrent().getDPI();
        return new PrecisionDimension(d.preciseWidth() * (double)dpi.x, d.preciseHeight() * (double)dpi.y);
    }

    private PrecisionDimension parsePageSize(String value) {
        float oneInch = 25.4f;
        String s = value.replaceAll(" ", "");
        if ("A0H".equals(s)) {
            return this.convertMmToInch(new PrecisionDimension(1189.0, 841.0));
        }
        if ("A0V".equals(s)) {
            return this.convertMmToInch(new PrecisionDimension(841.0, 1189.0));
        }
        if ("A1H".equals(s)) {
            return this.convertMmToInch(new PrecisionDimension(841.0, 594.0));
        }
        if ("A1V".equals(s)) {
            return this.convertMmToInch(new PrecisionDimension(594.0, 841.0));
        }
        if ("A2H".equals(s)) {
            return this.convertMmToInch(new PrecisionDimension(594.0, 420.0));
        }
        if ("A2V".equals(s)) {
            return this.convertMmToInch(new PrecisionDimension(420.0, 594.0));
        }
        if ("A3H".equals(s)) {
            return this.convertMmToInch(new PrecisionDimension(420.0, 297.0));
        }
        if ("A3V".equals(s)) {
            return this.convertMmToInch(new PrecisionDimension(297.0, 420.0));
        }
        if ("A4H".equals(s)) {
            return this.convertMmToInch(new PrecisionDimension(297.0, 210.0));
        }
        if ("A4V".equals(s)) {
            return this.convertMmToInch(new PrecisionDimension(210.0, 297.0));
        }
        if ("A5H".equals(s)) {
            return this.convertMmToInch(new PrecisionDimension(210.0, 148.0));
        }
        if ("A5V".equals(s)) {
            return this.convertMmToInch(new PrecisionDimension(148.0, 210.0));
        }
        Pattern whR = Pattern.compile("(\\d+\\.?\\d*.*)(x|X)(\\d+\\.?\\d*.*)", 2);
        Matcher whM = whR.matcher(s);
        if (whM.matches()) {
            String widthString = whM.group(1);
            String heightString = whM.group(3);
            float width = widthString.endsWith("\"") ? Float.parseFloat(widthString.replaceAll("[^0-9\\.]", "")) : Float.parseFloat(widthString.replaceAll("[^0-9\\.]", "")) / 25.4f;
            float height = heightString.endsWith("\"") ? Float.parseFloat(heightString.replaceAll("[^0-9\\.]", "")) : Float.parseFloat(heightString.replaceAll("[^0-9\\.]", "")) / 25.4f;
            return new PrecisionDimension((double)width, (double)height);
        }
        return null;
    }
}

