/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.common.abstractdiagram;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class AbstractDiagramFigure
extends FreeformLayer {
    private boolean showPageBoundaries = false;
    private Dimension pageBoundaries = new Dimension(800, 600);
    private Rectangle workarea;

    public AbstractDiagramFigure() {
        this.setBounds(new Rectangle(new Point(0, 0), this.pageBoundaries));
        this.setLayoutManager((LayoutManager)new FreeformLayout());
        this.setBackgroundColor(null);
        this.setOpaque(false);
    }

    public Rectangle getFreeformExtent() {
        Rectangle r = super.getFreeformExtent();
        return r.union(this.workarea);
    }

    public void setPageBoundaries(Dimension size) {
        this.pageBoundaries = size;
        this.repaint();
    }

    public void setWorkArea(Rectangle r) {
        if (r.equals((Object)this.workarea)) {
            return;
        }
        this.workarea = r;
        this.fireExtentChanged();
    }

    public void showPageBoundaries(boolean onOff) {
        if (this.showPageBoundaries != onOff) {
            this.showPageBoundaries = onOff;
            this.repaint();
        }
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        if (this.showPageBoundaries && this.pageBoundaries != null) {
            graphics.setBackgroundColor(ColorConstants.blue);
            graphics.setLineStyle(2);
            Rectangle r = this.getBounds();
            if (this.pageBoundaries.width > 0) {
                int i = r.x;
                while (i < r.width) {
                    graphics.drawLine(i, r.y, i, r.y + r.height);
                    i += this.pageBoundaries.width;
                }
            }
            if (this.pageBoundaries.height > 0) {
                int j = r.y;
                while (j < r.height) {
                    graphics.drawLine(r.x, j, r.x + r.width, j);
                    j += this.pageBoundaries.height;
                }
            }
        }
    }
}

