/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.common.abstractdiagram;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IConstraint;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.core.factory.IElementInitializer;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.helpers.AuthHelper;
import com.modeliosoft.modelio.diagram.elements.core.link.ModelioLinkCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import java.util.List;
import org.eclipse.gef.commands.Command;

public class CreateConstraintCommand
extends Command {
    private ModelioLinkCreationContext context;
    private List<GmModel> sourceModels;
    private Object constraint;
    private GmCompositeNode parentNode;

    public CreateConstraintCommand(List<GmModel> sourceModels, GmCompositeNode parentNode, ModelioLinkCreationContext context, Object constraint) {
        this.sourceModels = sourceModels;
        this.parentNode = parentNode;
        this.context = context;
        this.constraint = constraint;
    }

    public boolean canExecute() {
        if (!AuthHelper.canModifyDiagram((GmAbstractDiagram)this.parentNode.getDiagram())) {
            return false;
        }
        for (GmModel sourceModel : this.sourceModels) {
            if (AuthHelper.canModify((IElement)sourceModel.getRelatedIElement())) continue;
            return false;
        }
        return true;
    }

    public void execute() {
        GmAbstractDiagram diagram = this.parentNode.getDiagram();
        IConstraint newElement = (IConstraint)this.context.getElementToUnmask();
        if (newElement == null) {
            IModelFactory modelFactory = diagram.getModelFactory();
            newElement = modelFactory.createConstraint();
            for (GmModel sourceModel : this.sourceModels) {
                newElement.addConstrainedElement((IModelElement)sourceModel.getRelatedIElement());
            }
            if (this.context.getStereotype() != null) {
                newElement.addExtension(this.context.getStereotype());
            }
            IElementInitializer elementInitializer = diagram.getElementInitializer();
            elementInitializer.initialize((IElement)newElement, this.context.getProperties());
        }
        diagram.unmask(this.parentNode, (IElement)newElement, this.constraint);
    }
}

