/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.common.abstractdiagram;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.AbstractDiagramEditPart;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.commands.ModelioCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;

public class DeferredUnmaskCommand
extends Command {
    private final IElement parent;
    private final IElement child;
    private final AbstractDiagramEditPart diagramEditPart;
    private final Point dropLocation;

    public DeferredUnmaskCommand(IElement parent, IElement child, Point dropLocation, AbstractDiagramEditPart diagramEditPart) {
        this.parent = parent;
        this.child = child;
        this.dropLocation = dropLocation;
        this.diagramEditPart = diagramEditPart;
    }

    public boolean canExecute() {
        return true;
    }

    public void execute() {
        Command command = this.createCommand();
        if (command != null && command.canExecute()) {
            command.execute();
        }
    }

    private Command createCommand() {
        CreateRequest req = new CreateRequest();
        req.setLocation(this.dropLocation);
        req.setSize(new Dimension(-1, -1));
        req.setFactory((CreationFactory)new ModelioCreationContext(this.child));
        GmAbstractDiagram gmDiagram = (GmAbstractDiagram)this.diagramEditPart.getModel();
        List parentModels = gmDiagram.getAllGMRelatedTo(new ObRef(this.parent));
        for (GmModel parentModel : parentModels) {
            EditPart parentEditPart = (EditPart)this.diagramEditPart.getViewer().getEditPartRegistry().get(parentModel);
            if (parentEditPart == null) continue;
            IFigure parentFigure = ((GraphicalEditPart)parentEditPart).getFigure();
            parentFigure.revalidate();
            parentFigure.getUpdateManager().performValidation();
            EditPart targetPart = parentEditPart.getTargetEditPart((Request)req);
            if (targetPart == null) continue;
            return targetPart.getCommand((Request)req);
        }
        return null;
    }
}

