/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.common.abstractdiagram;

import com.modeliosoft.modelio.api.model.analyst.IRequirement;
import com.modeliosoft.modelio.api.model.analyst.ITerm;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnBehavior;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnProcess;
import com.modeliosoft.modelio.api.model.uml.behavior.activity.IActivity;
import com.modeliosoft.modelio.api.model.uml.behavior.communication.ICommunicationInteraction;
import com.modeliosoft.modelio.api.model.uml.behavior.interaction.IInteraction;
import com.modeliosoft.modelio.api.model.uml.behavior.state.IStateMachine;
import com.modeliosoft.modelio.api.model.uml.information.IInformationItem;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.statik.IBindableInstance;
import com.modeliosoft.modelio.api.model.uml.statik.ICollaboration;
import com.modeliosoft.modelio.api.model.uml.statik.IEnumeration;
import com.modeliosoft.modelio.api.model.uml.statik.IInstance;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.AbstractDiagramEditPart;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.DeferredUnmaskCommand;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.DiagramElementDropEditPolicy;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.UnmaskLinkCommand;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLink;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.policies.DefaultElementDropEditPolicy;
import com.modeliosoft.modelio.diagram.elements.core.requests.ModelElementDropRequest;
import java.util.ArrayDeque;
import java.util.Deque;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class DiagramElementDropEditPolicy
extends DefaultElementDropEditPolicy {
    private DropCommandProvider dropCommandProvider;

    public void createDropCommandForNode(CompoundCommand command, Point p, IElement toUnmask) {
        IElement child;
        AbstractDiagramEditPart host = (AbstractDiagramEditPart)this.getHost();
        GmAbstractDiagram gmDiagram = (GmAbstractDiagram)host.getModel();
        Point dropLocation = p;
        IElement element = toUnmask;
        ArrayDeque<IElement> elementHierarchy = new ArrayDeque<IElement>();
        while (element != null && this.getVisibleModelFor(element, gmDiagram) == null && gmDiagram.canUnmask(element) && this.shouldUnmask(element, elementHierarchy)) {
            elementHierarchy.push(element);
            element = this.getComposition(element);
        }
        CompoundCommand hierarchyUnmaskCommand = new CompoundCommand();
        if (element != null && this.getVisibleModelFor(element, gmDiagram) != null) {
            child = element;
        } else {
            child = (IElement)elementHierarchy.pop();
            super.createDropCommandForNode(hierarchyUnmaskCommand, dropLocation, child);
            dropLocation = dropLocation.getCopy();
            dropLocation.x = 0;
            dropLocation.y = 0;
        }
        while (!elementHierarchy.isEmpty()) {
            IElement parent = child;
            child = (IElement)elementHierarchy.pop();
            hierarchyUnmaskCommand.add((Command)new DeferredUnmaskCommand(parent, child, dropLocation, host));
            dropLocation = dropLocation.getCopy();
            dropLocation.x = 0;
            dropLocation.y = 0;
        }
        command.add(hierarchyUnmaskCommand.unwrap());
    }

    public void setHost(EditPart host) {
        super.setHost(host);
        this.dropCommandProvider = new DropCommandProvider(this);
    }

    public void showTargetFeedback(Request request) {
        if (request.getType().equals("DROPELEMENT")) {
            if (this.highlight == null) {
                super.showTargetFeedback(request);
                this.highlight.setOpaque(false);
                this.highlight.setBackgroundColor(null);
            } else {
                super.showTargetFeedback(request);
            }
        }
    }

    void createDropCommandForLink(CompoundCommand command, Point dropLocation, GmLink link) {
        command.add((Command)new UnmaskLinkCommand(link, (AbstractDiagramEditPart)this.getHost(), dropLocation));
    }

    protected Command getDropCommand(ModelElementDropRequest request) {
        CompoundCommand command = new CompoundCommand();
        Point dropLocation = request.getDropLocation();
        GmModel hostModel = (GmModel)this.getHost().getModel();
        GmAbstractDiagram gmDiagram = hostModel.getDiagram();
        IElement[] iElementArray = request.getDroppedElements();
        int n = iElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IElement toUnmask = iElementArray[n2];
            GmModel previousUnmask = this.getVisibleModelFor(toUnmask, gmDiagram);
            if (previousUnmask == null) {
                command.add(this.dropCommandProvider.getDropCommandFor(toUnmask, dropLocation));
                dropLocation = dropLocation.getTranslated(20, 20);
            } else {
                this.createSelectionCommand(command, previousUnmask);
            }
            ++n2;
        }
        return command.unwrap();
    }

    protected EditPart getDropTargetEditPart(ModelElementDropRequest request) {
        IElement[] iElementArray = request.getDroppedElements();
        int n = iElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean canUnmaskAsLink;
            IElement droppedElement = iElementArray[n2];
            boolean canUnmaskAsNode = ((GmModel)this.getHost().getModel()).canUnmask(droppedElement);
            GmLink gmLink = ((GmAbstractDiagram)this.getHost().getModel()).unmaskLink(droppedElement);
            boolean bl = canUnmaskAsLink = gmLink != null;
            if (gmLink != null) {
                gmLink.delete();
            }
            if (!canUnmaskAsNode && !canUnmaskAsLink) {
                return null;
            }
            ++n2;
        }
        return this.getHost();
    }

    protected boolean shouldUnmask(IElement element, Deque<IElement> hierarchy) {
        IElement lastInHierarchy = hierarchy.peek();
        boolean isCurrentCollaboration = false;
        boolean isCurrentInstance = false;
        boolean isCurrentCmsNode = false;
        boolean isCurrentEnumeration = false;
        boolean isInformationItem = false;
        boolean isRequirement = false;
        boolean isTerm = false;
        boolean isActivity = false;
        boolean isInteraction = false;
        boolean isBpmnProcess = false;
        boolean isBpmnBehavior = false;
        boolean isCommunicationInteraction = false;
        boolean isStateMachine = false;
        if (lastInHierarchy != null) {
            isCurrentCmsNode = lastInHierarchy.getElementStatus().isCmsNode();
            isCurrentInstance = lastInHierarchy instanceof IInstance && !(lastInHierarchy instanceof IBindableInstance);
            isCurrentCollaboration = lastInHierarchy instanceof ICollaboration;
            isCurrentEnumeration = lastInHierarchy instanceof IEnumeration;
            isInformationItem = lastInHierarchy instanceof IInformationItem;
            isRequirement = lastInHierarchy instanceof IRequirement;
            isTerm = lastInHierarchy instanceof ITerm;
            isActivity = lastInHierarchy instanceof IActivity;
            isInteraction = lastInHierarchy instanceof IInteraction;
            isBpmnProcess = lastInHierarchy instanceof IBpmnProcess;
            isBpmnBehavior = lastInHierarchy instanceof IBpmnBehavior;
            isCommunicationInteraction = lastInHierarchy instanceof ICommunicationInteraction;
            isStateMachine = lastInHierarchy instanceof IStateMachine;
        }
        return !isStateMachine && !isCommunicationInteraction && !isActivity && !isInteraction && !isBpmnProcess && !isBpmnBehavior && !isCurrentCmsNode && !isCurrentInstance && !isCurrentCollaboration && !isCurrentEnumeration && !isInformationItem && !isRequirement && !isTerm;
    }

    protected IElement getComposition(IElement element) {
        return element.getCompositionOwner();
    }

    static /* synthetic */ void access$0(DiagramElementDropEditPolicy diagramElementDropEditPolicy, CompoundCommand compoundCommand, Point point, IElement iElement) {
        super.createDropCommandForNode(compoundCommand, point, iElement);
    }
}

