/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.common.abstractdiagram;

import com.modeliosoft.modelio.api.model.diagrams.IAbstractDiagram;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.api.utils.exceptions.ObElementNotFoundException;
import com.modeliosoft.modelio.core.model.Meta;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.persistence.ExtReferenceResolver;
import com.modeliosoft.modelio.diagram.elements.persistence.InstanceFactory;
import com.modeliosoft.modelio.diagram.persistence.IExtReferenceResolver;
import com.modeliosoft.modelio.diagram.persistence.IInstanceFactory;
import com.modeliosoft.modelio.diagram.persistence.IPersistent;
import com.modeliosoft.modelio.diagram.persistence.XmlDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.XmlDiagramWriter;

public class DiagramPersistence {
    public static void loadDiagram(GmAbstractDiagram diagram) throws ObElementNotFoundException {
        ObRef diagramRef = diagram.getRepresentedRef();
        IAbstractDiagram obDiagram = (IAbstractDiagram)diagram.getModelManager().resolveRef(diagramRef);
        if (obDiagram == null) {
            throw new ObElementNotFoundException("{" + diagramRef.uuid + "} " + diagramRef.mc + " not found, it may have been deleted.");
        }
        String data = (String)new Meta((IElement)obDiagram).getAttributeValue("uiData");
        diagram.clear();
        if (data != null && !data.isEmpty()) {
            XmlDiagramReader reader = new XmlDiagramReader((IInstanceFactory)new InstanceFactory(), (IExtReferenceResolver)new ExtReferenceResolver());
            reader.readDiagram(data, (IPersistent)diagram);
        }
        diagram.updateLastSaveDate();
        diagram.refreshAllFromObModel();
        diagram.refreshFromObModel();
    }

    public static void saveDiagram(GmAbstractDiagram diagram) {
        XmlDiagramWriter writer = new XmlDiagramWriter();
        writer.save((IPersistent)diagram);
        IAbstractDiagram obDiagram = (IAbstractDiagram)diagram.getRelatedIElement();
        if (obDiagram.isValid()) {
            new Meta((IElement)obDiagram).setAttributeValue("uiData", (Object)writer.getOutput());
            diagram.updateLastSaveDate();
        }
    }
}

