/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.common.abstractdiagram;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.core.factory.IElementInitializer;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.core.model.change.IModelChangeHandler;
import com.modeliosoft.modelio.core.model.change.IModelChangeListener;
import com.modeliosoft.modelio.core.utils.MultiHashMap;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.DiagramPersistence;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.IDiagramRefresher;
import com.modeliosoft.modelio.diagram.elements.common.label.base.GmElementLabel;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLink;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLink;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLinkFactory;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLinkable;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmNodeFactory;
import com.modeliosoft.modelio.diagram.elements.core.model.IImageServices;
import com.modeliosoft.modelio.diagram.elements.core.model.ImageServices;
import com.modeliosoft.modelio.diagram.elements.core.model.ModelManager;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import com.modeliosoft.modelio.diagram.styles.core.IStyle;
import com.modeliosoft.modelio.diagram.styles.core.NamedStyle;
import com.modeliosoft.modelio.diagram.styles.core.Style;
import com.modeliosoft.modelio.diagram.styles.plugin.DiagramStyles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class GmAbstractDiagram
extends GmCompositeNode {
    protected ModelManager modelManager;
    protected MultiHashMap<ObRef, GmModel> models = new MultiHashMap();
    protected IDiagramRefresher modelChangeHandler = new ModelChangeListener(this);
    private IGmNodeFactory gmNodeFactory;
    private IGmLinkFactory gmLinkCreationFactory;
    private IImageServices imageServices;
    private final List<GmLink> links = new ArrayList();
    private IElementInitializer elementInitializer;
    protected int lastSaveDate = -1;
    private final IDiagramRefresher hiddenModelChangeHandler = new HiddenModelChangeListener(this);
    private final int minorVersion = 0;
    private static final int MAJOR_VERSION = 0;
    private transient boolean visible = true;

    public GmAbstractDiagram() {
    }

    public GmAbstractDiagram(ModelManager modelManager, ObRef diagramRef) {
        super(null, diagramRef);
        this.modelManager = modelManager;
        this.init();
    }

    protected final void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public final void addGraphicModel(GmModel model) {
        if (model != this) {
            this.models.putValue((Object)model.getRepresentedRef(), (Object)model);
        }
        if (model instanceof GmLink) {
            this.links.add((GmLink)model);
        }
    }

    public boolean canContain(Class<? extends GmNodeModel> nodeClass) {
        return !GmElementLabel.class.isAssignableFrom(nodeClass);
    }

    public final void clear() {
        GmLink gmLink;
        for (GmNodeModel child : this.getChildren()) {
            child.delete();
        }
        for (IGmLink l : new ArrayList(this.getStartingLinks())) {
            l.delete();
        }
        for (IGmLink l : new ArrayList(this.getEndingLinks())) {
            l.delete();
        }
        GmCompositeNode gmParent = this.getParentNode();
        if (gmParent != null) {
            gmParent.removeChild((GmNodeModel)this);
        }
        if ((gmLink = this.getParentLink()) != null) {
            gmLink.removeExtension((GmNodeModel)this);
        }
    }

    public void dispose() {
        if (this.modelChangeHandler != null) {
            this.modelManager.getModelingSession().getModel().removeModelHandler((IModelChangeHandler)this.modelChangeHandler);
            this.modelManager.getModelingSession().getModel().removeModelListener((IModelChangeListener)this.modelChangeHandler);
            this.modelManager.getModelingSession().getModel().removeModelHandler((IModelChangeHandler)this.hiddenModelChangeHandler);
            this.modelManager.getModelingSession().getModel().removeModelListener((IModelChangeListener)this.hiddenModelChangeHandler);
            this.modelChangeHandler = null;
            this.modelManager = null;
            this.delete();
        }
    }

    public final List<GmModel> getAllGMRelatedTo(ObRef representedElementRef) {
        return this.models.getList((Object)representedElementRef);
    }

    public final List<GmModel> getAllGMRepresenting(ObRef representedElementRef) {
        ArrayList<GmModel> modelsRepresenting = new ArrayList<GmModel>();
        for (GmModel model : this.models.getList((Object)representedElementRef)) {
            if (model.getRepresentedIElement() == null) continue;
            modelsRepresenting.add(model);
        }
        return modelsRepresenting;
    }

    public final Collection<GmModel> getAllModels() {
        ArrayList<GmModel> ret = new ArrayList<GmModel>(this.models.size() * 5);
        for (List l : this.models.values()) {
            ret.addAll(l);
        }
        return ret;
    }

    public final GmAbstractDiagram getDiagram() {
        return this;
    }

    public IElementInitializer getElementInitializer() {
        return this.elementInitializer;
    }

    public IImageServices getImageServices() {
        return this.imageServices;
    }

    public int getMajorVersion() {
        return 0;
    }

    public final IModelFactory getModelFactory() {
        return this.modelManager.getModelingSession().getModelFactory();
    }

    public final ModelManager getModelManager() {
        return this.modelManager;
    }

    public boolean isDisposed() {
        return this.modelManager == null;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void read(IDiagramReader in) {
        Object versionProperty = in.readProperty("GmAbstractDiagram.version");
        int readVersion = versionProperty == null ? 0 : (Integer)versionProperty;
        switch (readVersion) {
            case 0: {
                this.read_0(in);
                break;
            }
            default: {
                assert (false) : "version number not covered!";
                this.read_0(in);
            }
        }
    }

    public void refreshAllFromObModel() {
        ArrayList toUpdate = new ArrayList(this.models.size() * 5);
        for (List list : this.models.values()) {
            toUpdate.addAll(list);
        }
        for (GmModel m : toUpdate) {
            m.obElementsUpdated();
        }
    }

    public void removeGraphicModel(GmModel model) {
        this.models.remove((Object)model.getRepresentedRef(), (Object)model);
        if (model instanceof GmLink) {
            this.links.remove(model);
        }
    }

    public void setElementInitializer(IElementInitializer elementInitializer) {
        this.elementInitializer = elementInitializer;
    }

    public void setGmLinkCreationFactory(IGmLinkFactory gmLinkCreationFactory) {
        this.gmLinkCreationFactory = gmLinkCreationFactory;
    }

    public void setGmNodeFactory(IGmNodeFactory gmNodeFactory) {
        this.gmNodeFactory = gmNodeFactory;
    }

    public final GmNodeModel unmask(GmCompositeNode parentNode, IElement newElement, Object initialLayoutData) {
        List allGMRepresenting = this.getAllGMRepresenting(new ObRef(newElement));
        for (GmModel gmModel : allGMRepresenting) {
            GmNodeModel gmNodeModel;
            if (!(gmModel instanceof GmNodeModel) || !parentNode.equals((gmNodeModel = (GmNodeModel)gmModel).getParentNode())) continue;
            return gmNodeModel;
        }
        try {
            return this.getGmNodeFactory().create(this, parentNode, newElement, initialLayoutData);
        }
        catch (UnsupportedOperationException e) {
            LOG.warning((String)"org.modelio.diagram.elements", (String)e.getMessage());
            return null;
        }
    }

    public final GmLink unmaskLink(IElement createdLinkElement, IGmLinkable fromNode, IGmLinkable toNode, Object initialLayoutData) {
        if (fromNode == null || toNode == null) {
            throw new IllegalArgumentException("Source and destination nodes must not be null.");
        }
        List allGMRepresenting = this.getAllGMRepresenting(new ObRef(createdLinkElement));
        for (GmModel gmModel : allGMRepresenting) {
            GmLink gmLink;
            if (!(gmModel instanceof GmLink) || !fromNode.equals((gmLink = (GmLink)gmModel).getFrom()) || !toNode.equals(gmLink.getTo())) continue;
            return gmLink;
        }
        GmLink newLink = this.unmaskLink(createdLinkElement);
        fromNode.addStartingLink((IGmLink)newLink);
        toNode.addEndingLink((IGmLink)newLink);
        newLink.setLayoutData(initialLayoutData);
        return newLink;
    }

    public final GmLink unmaskLink(IElement linkElement) {
        return this.getGmLinkFactory().create(this, linkElement);
    }

    public final void updateLastSaveDate() {
        this.lastSaveDate = this.getRelatedIElement().getmodifDate();
    }

    public void write(IDiagramWriter out) {
        super.write(out);
        out.writeProperty("Links", this.links);
        if (false) {
            out.writeProperty("GmAbstractDiagram.version", (Object)0);
        }
    }

    IGmNodeFactory getGmNodeFactory() {
        return this.gmNodeFactory;
    }

    protected IStyle createStyle(GmAbstractDiagram aDiagram) {
        NamedStyle defaultStyle = DiagramStyles.getInstance().getStyleManager().getDefaultStyle();
        return new Style((IStyle)defaultStyle);
    }

    protected void doSetVisible(boolean newVisible) {
        if (this.visible == newVisible) {
            return;
        }
        this.visible = newVisible;
        super.doSetVisible(newVisible);
        if (newVisible) {
            this.modelManager.getModelingSession().getModel().removeModelHandler((IModelChangeHandler)this.hiddenModelChangeHandler);
            this.modelManager.getModelingSession().getModel().removeModelListener((IModelChangeListener)this.hiddenModelChangeHandler);
            this.modelManager.getModelingSession().getModel().addModelHandler((IModelChangeHandler)this.modelChangeHandler);
            this.modelManager.getModelingSession().getModel().addModelListener((IModelChangeListener)this.modelChangeHandler);
            IElement relatedIElement = this.getRelatedIElement();
            if (relatedIElement != null && relatedIElement.isValid()) {
                DiagramPersistence.loadDiagram((GmAbstractDiagram)this);
            }
        } else {
            this.modelManager.getModelingSession().getModel().removeModelHandler((IModelChangeHandler)this.modelChangeHandler);
            this.modelManager.getModelingSession().getModel().removeModelListener((IModelChangeListener)this.modelChangeHandler);
            this.modelManager.getModelingSession().getModel().addModelHandler((IModelChangeHandler)this.hiddenModelChangeHandler);
            this.modelManager.getModelingSession().getModel().addModelListener((IModelChangeListener)this.hiddenModelChangeHandler);
        }
    }

    private final IGmLinkFactory getGmLinkFactory() {
        return this.gmLinkCreationFactory;
    }

    private void init() {
        this.modelManager.getModelingSession().getModel().addModelHandler((IModelChangeHandler)this.modelChangeHandler);
        this.modelManager.getModelingSession().getModel().addModelListener((IModelChangeListener)this.modelChangeHandler);
        this.imageServices = new ImageServices(this.modelManager.getModelingSession());
        this.models.putValue((Object)this.getRepresentedRef(), (Object)this);
    }

    private void read_0(IDiagramReader in) {
        super.read(in);
        ObRef newId = new ObRef(this.getRelatedIElement());
        this.getRepresentedRef().mc = newId.mc;
        this.getRepresentedRef().uuid = newId.uuid;
        in.readListProperty("Links");
    }

    public final boolean isEditable() {
        IElement relatedIElement = this.getRelatedIElement();
        return relatedIElement != null && relatedIElement.isValid() && relatedIElement.getElementStatus().isModifiable();
    }
}

