/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.common.abstractdiagram;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.AbstractDiagramEditPart;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.helpers.AuthHelper;
import com.modeliosoft.modelio.diagram.elements.core.link.CreateBendedConnectionRequest;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLink;
import com.modeliosoft.modelio.diagram.elements.core.link.ModelioLinkCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.requests.ModelElementDropRequest;
import com.modeliosoft.modelio.diagram.styles.core.MetaKey;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreationFactory;

public class UnmaskLinkCommand
extends Command {
    private Point dropLocation;
    private AbstractDiagramEditPart host;
    private IElement linkElement;
    private IElement fromElement;
    private IElement toElement;
    private StyleKey routerKey;

    public UnmaskLinkCommand(GmLink link, AbstractDiagramEditPart host, Point dropLocation) {
        this.linkElement = link.getRepresentedIElement();
        this.fromElement = link.getFromElement();
        this.toElement = link.getToElement();
        link.delete();
        this.dropLocation = dropLocation;
        this.host = host;
        this.routerKey = link.getStyleKey(MetaKey.CONNECTIONROUTER);
    }

    public boolean canExecute() {
        if (this.fromElement == null || this.toElement == null) {
            return false;
        }
        return AuthHelper.canModifyDiagram((GmAbstractDiagram)((GmAbstractDiagram)this.host.getModel()));
    }

    public void execute() {
        CreateBendedConnectionRequest req = new CreateBendedConnectionRequest();
        req.setLocation(this.dropLocation);
        req.setSize(new Dimension(-1, -1));
        req.setFactory((CreationFactory)new ModelioLinkCreationContext(this.linkElement));
        req.setType((Object)"connection start");
        if (this.routerKey != null) {
            req.getData().setRoutingMode((StyleKey.ConnectionRouterId)((GmAbstractDiagram)this.host.getModel()).getStyle().getProperty(this.routerKey));
        } else {
            req.getData().setRoutingMode(StyleKey.ConnectionRouterId.ORTHOGONAL);
        }
        EditPart sourceEditPart = this.getEditPartFor(this.fromElement, (CreateConnectionRequest)req);
        boolean sourceMissing = false;
        if (sourceEditPart == null) {
            sourceMissing = true;
            this.unmaskElement(this.fromElement, this.dropLocation.getTranslated(-50, 0));
            sourceEditPart = this.getEditPartFor(this.fromElement, (CreateConnectionRequest)req);
            if (sourceEditPart == null) {
                return;
            }
        }
        req.setSourceEditPart(sourceEditPart);
        req.setLocation(this.getAbsoluteFigureCenter(sourceEditPart));
        req.getData().setSrcPoint(this.getAbsoluteFigureCenter(sourceEditPart));
        req.setStartCommand(sourceEditPart.getCommand((Request)req));
        req.setType((Object)"connection end");
        EditPart targetEditPart = this.getEditPartFor(this.toElement, (CreateConnectionRequest)req);
        if (targetEditPart == null) {
            Point loc = this.dropLocation;
            if (sourceMissing) {
                loc = this.dropLocation.getTranslated(50, 0);
            }
            this.unmaskElement(this.toElement, loc);
            targetEditPart = this.getEditPartFor(this.toElement, (CreateConnectionRequest)req);
            if (targetEditPart == null) {
                return;
            }
        }
        req.setTargetEditPart(targetEditPart);
        req.setLocation(this.getAbsoluteFigureCenter(targetEditPart));
        Command connectionCreationCommand = targetEditPart.getCommand((Request)req);
        if (connectionCreationCommand != null && connectionCreationCommand.canExecute()) {
            connectionCreationCommand.execute();
        }
    }

    private EditPart getEditPartFor(IElement element, CreateConnectionRequest req) {
        List models = ((GmAbstractDiagram)this.getHost().getModel()).getAllGMRelatedTo(new ObRef(element));
        for (GmModel model : models) {
            EditPart targetEditPart;
            EditPart editPart = (EditPart)this.getHost().getViewer().getEditPartRegistry().get(model);
            if (editPart == null || (targetEditPart = editPart.getTargetEditPart((Request)req)) == null) continue;
            return targetEditPart;
        }
        return null;
    }

    private AbstractDiagramEditPart getHost() {
        return this.host;
    }

    private void unmaskElement(IElement element, Point location) {
        Command command;
        ModelElementDropRequest dropRequest = new ModelElementDropRequest();
        dropRequest.setDroppedElements(new IElement[]{element});
        dropRequest.setLocation(location);
        EditPart targetEditPart = this.getHost().getTargetEditPart((Request)dropRequest);
        if (targetEditPart != null && (command = targetEditPart.getCommand((Request)dropRequest)) != null && command.canExecute()) {
            command.execute();
        }
    }

    private Point getAbsoluteFigureCenter(EditPart editPart) {
        IFigure fig = ((AbstractGraphicalEditPart)editPart).getFigure();
        fig.getUpdateManager().performValidation();
        Point ret = fig.getBounds().getCenter();
        fig.translateToAbsolute((Translatable)ret);
        return ret;
    }
}

