/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.common.abstractdiagram;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.AbstractDiagramEditPart;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.helpers.AuthHelper;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLink;
import com.modeliosoft.modelio.diagram.elements.core.link.ModelioLinkCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLink;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLinkable;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import com.modeliosoft.modelio.diagram.elements.core.requests.ModelElementDropRequest;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreationFactory;

public class UnmaskLinkedNodeCommand
extends Command {
    private final IElement theElement;
    private final Object constraint;
    private final GmAbstractDiagram diagram;
    private final AbstractDiagramEditPart host;
    private final Point dropLocation;

    public UnmaskLinkedNodeCommand(IElement theElement, AbstractDiagramEditPart host, Object initialLayoutData, Point dropLocation) {
        this.theElement = theElement;
        this.host = host;
        this.diagram = (GmAbstractDiagram)host.getModel();
        this.constraint = initialLayoutData;
        this.dropLocation = dropLocation;
    }

    public boolean canExecute() {
        return AuthHelper.canModifyDiagram((GmAbstractDiagram)((GmAbstractDiagram)this.host.getModel()));
    }

    public void execute() {
        GmNodeModel targetModel = this.diagram.unmask((GmCompositeNode)this.diagram, this.theElement, this.constraint);
        GmLink link = this.diagram.unmaskLink(this.theElement);
        CreateConnectionRequest req = new CreateConnectionRequest();
        req.setLocation(this.dropLocation);
        req.setSize(new Dimension(-1, -1));
        req.setFactory((CreationFactory)new ModelioLinkCreationContext(this.theElement));
        req.setType((Object)"connection start");
        IElement srcElement = link.getFromElement();
        EditPart sourceEditPart = this.getEditPartFor(srcElement, req);
        if (sourceEditPart == null) {
            this.unmaskElement(srcElement, this.dropLocation.getTranslated(-50, 0));
            sourceEditPart = this.getEditPartFor(srcElement, req);
            if (sourceEditPart == null) {
                targetModel.delete();
                link.delete();
                return;
            }
        }
        IGmLinkable sourceModel = (IGmLinkable)sourceEditPart.getModel();
        targetModel.addEndingLink((IGmLink)link);
        sourceModel.addStartingLink((IGmLink)link);
    }

    private EditPart getEditPartFor(IElement element, CreateConnectionRequest req) {
        List models = this.diagram.getAllGMRelatedTo(new ObRef(element));
        for (GmModel model : models) {
            EditPart targetEditPart;
            EditPart editPart = (EditPart)this.host.getViewer().getEditPartRegistry().get(model);
            if (editPart == null || (targetEditPart = editPart.getTargetEditPart((Request)req)) == null) continue;
            return targetEditPart;
        }
        return null;
    }

    private void unmaskElement(IElement element, Point location) {
        ModelElementDropRequest dropRequest = new ModelElementDropRequest();
        dropRequest.setDroppedElements(new IElement[]{element});
        dropRequest.setLocation(location);
        EditPart targetEditPart = this.host.getTargetEditPart((Request)dropRequest);
        Command command = targetEditPart.getCommand((Request)dropRequest);
        if (command != null && command.canExecute()) {
            command.execute();
        }
    }
}

