/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.common.freezone;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.model.MetaModelExpert;
import com.modeliosoft.modelio.core.model.expert.CreationExpertRegistry;
import com.modeliosoft.modelio.diagram.elements.core.commands.DefaultCloneElementCommand;
import com.modeliosoft.modelio.diagram.elements.core.commands.DefaultCreateElementCommand;
import com.modeliosoft.modelio.diagram.elements.core.commands.DefaultReparentElementCommand;
import com.modeliosoft.modelio.diagram.elements.core.commands.ModelioCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.commands.NodeChangeLayoutCommand;
import com.modeliosoft.modelio.diagram.elements.core.figures.FigureUtilities2;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeEditPart;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import com.modeliosoft.modelio.diagram.elements.core.policies.DefaultNodeResizableEditPolicy;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.SelectionEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

public class BaseFreeZoneLayoutEditPolicy
extends XYLayoutEditPolicy {
    protected IFigure highlight = null;

    public void eraseTargetFeedback(Request request) {
        if (("add children".equals(request.getType()) || "create child".equals(request.getType())) && this.highlight != null) {
            this.removeFeedback(this.highlight);
            this.highlight = null;
        }
        super.eraseTargetFeedback(request);
    }

    public EditPart getTargetEditPart(Request request) {
        if ("create child".equals(request.getType())) {
            CreateRequest createRequest = (CreateRequest)request;
            return this.getTargetEditPart(createRequest);
        }
        if ("move".equals(request.getType()) || "add children".equals(request.getType()) || "clone".equals(request.getType())) {
            ChangeBoundsRequest changeBoundsRequest = (ChangeBoundsRequest)request;
            if (this.isMove(changeBoundsRequest)) {
                return this.getHost();
            }
            return this.getTargetEditPart(changeBoundsRequest);
        }
        return null;
    }

    public void showTargetFeedback(Request request) {
        if ("add children".equals(request.getType()) || "create child".equals(request.getType())) {
            Command c = this.getHost().getCommand(request);
            FigureUtilities2.HighlightType hightlightType = null;
            hightlightType = c == null ? FigureUtilities2.HighlightType.ERROR : (c.canExecute() ? FigureUtilities2.HighlightType.SUCCESS : FigureUtilities2.HighlightType.WARNING);
            if (this.highlight == null) {
                this.highlight = FigureUtilities2.createHighlightFigure((IFigure)this.getFeedbackLayer(), (IFigure)this.getHostFigure(), (FigureUtilities2.HighlightType)hightlightType);
                this.getFeedbackLayer().add(this.highlight);
            }
            FigureUtilities2.updateHighlightType((IFigure)this.highlight, (FigureUtilities2.HighlightType)hightlightType);
        }
        super.showTargetFeedback(request);
    }

    protected boolean canHandle(Class<? extends IElement> metaclass) {
        IElement hostElement = this.getHostElement();
        if (hostElement == null) {
            return false;
        }
        Class<?> hostMetaclass = hostElement.getClass();
        return CreationExpertRegistry.getExpert(hostMetaclass).canOwn(metaclass) && ((GmCompositeNode)this.getHost().getModel()).canCreate(metaclass);
    }

    protected Command createAddCommand(EditPart child, Object constraint) {
        return new DefaultReparentElementCommand(this.getHostElement(), this.getHostCompositeNode(), (GmNodeModel)child.getModel(), constraint);
    }

    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        if (child instanceof GmNodeEditPart) {
            NodeChangeLayoutCommand command = new NodeChangeLayoutCommand();
            command.setModel(child.getModel());
            command.setConstraint(constraint);
            return command;
        }
        return null;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        GmNodeEditPart childNode;
        SelectionEditPolicy childPolicy;
        if (child instanceof GmNodeEditPart && (childPolicy = (childNode = (GmNodeEditPart)child).getPreferredDragRolePolicy("resize")) != null) {
            return childPolicy;
        }
        return new DefaultNodeResizableEditPolicy();
    }

    protected Command getCloneCommand(ChangeBoundsRequest request) {
        if (this.getHost().getModel() instanceof GmCompositeNode) {
            GmCompositeNode hostModel = this.getHostCompositeNode();
            CompoundCommand command = new CompoundCommand();
            for (Object editPartObj : request.getEditParts()) {
                EditPart editPart = (EditPart)editPartObj;
                if (!(editPart.getModel() instanceof GmModel)) continue;
                GmModel gmModel = (GmModel)editPart.getModel();
                if (!CreationExpertRegistry.getExpert(this.getHostElement().getClass()).canOwn(this.getHostElement(), gmModel.getRelatedIElement(), null)) continue;
                Object requestConstraint = this.getConstraintForClone((GraphicalEditPart)editPart, request);
                command.add((Command)new DefaultCloneElementCommand(hostModel, this.getHostElement(), gmModel.getRelatedIElement(), requestConstraint));
            }
            return command.unwrap();
        }
        return null;
    }

    protected Command getCreateCommand(CreateRequest request) {
        IElement hostElement = this.getHostElement();
        ModelioCreationContext ctx = (ModelioCreationContext)request.getNewObject();
        IElement elementToUnmask = ctx.getElementToUnmask();
        GmCompositeNode gmParentNode = this.getHostCompositeNode();
        if (elementToUnmask != null) {
            if (gmParentNode.canUnmask(elementToUnmask)) {
                Object requestConstraint = this.getConstraintFor(request);
                return new DefaultCreateElementCommand(hostElement, gmParentNode, ctx, requestConstraint);
            }
            return null;
        }
        if (hostElement != null) {
            Class metaclassToCreate = MetaModelExpert.getMetaclass((String)ctx.getMetaclass());
            Class<?> hostMetaclass = hostElement.getClass();
            if (gmParentNode.canCreate(metaclassToCreate) && CreationExpertRegistry.getExpert(hostMetaclass).canOwn(metaclassToCreate)) {
                Object requestConstraint = this.getConstraintFor(request);
                return new DefaultCreateElementCommand(hostElement, gmParentNode, ctx, requestConstraint);
            }
        }
        return null;
    }

    protected GmCompositeNode getHostCompositeNode() {
        return (GmCompositeNode)this.getHost().getModel();
    }

    protected IElement getHostElement() {
        return this.getHostCompositeNode().getRelatedIElement();
    }

    protected Command getOrphanChildrenCommand(Request request) {
        return super.getOrphanChildrenCommand(request);
    }

    private EditPart getTargetEditPart(CreateRequest createRequest) {
        if (createRequest.getNewObject() instanceof ModelioCreationContext) {
            ModelioCreationContext ctx = (ModelioCreationContext)createRequest.getNewObject();
            if (ctx.getElementToUnmask() != null) {
                if (this.getHostCompositeNode().canUnmask(ctx.getElementToUnmask())) {
                    return this.getHost();
                }
                return null;
            }
            if (this.canHandle(MetaModelExpert.getMetaclass((String)ctx.getMetaclass()))) {
                return this.getHost();
            }
        }
        return null;
    }

    private EditPart getTargetEditPart(ChangeBoundsRequest changeBoundsRequest) {
        for (Object editPartObj : changeBoundsRequest.getEditParts()) {
            EditPart editPart = (EditPart)editPartObj;
            if (!(editPart.getModel() instanceof GmModel)) continue;
            GmModel gmModel = (GmModel)editPart.getModel();
            String metaclassName = gmModel.getRepresentedRef().mc;
            if (this.canHandle(MetaModelExpert.getMetaclass((String)metaclassName)) || editPart instanceof ConnectionEditPart) continue;
            return null;
        }
        return this.getHost();
    }

    private boolean isMove(ChangeBoundsRequest changeBoundsRequest) {
        if ("clone".equals(changeBoundsRequest.getType())) {
            return false;
        }
        for (Object o : changeBoundsRequest.getEditParts()) {
            EditPart editPart = (EditPart)o;
            if (editPart.getSelected() != 2) continue;
            if (editPart.getParent() == null || !editPart.getParent().equals(this.getHost())) break;
            return true;
        }
        return false;
    }

    protected Rectangle getEffectiveBounds(IFigure figure) {
        return figure instanceof HandleBounds ? ((HandleBounds)figure).getHandleBounds().getCopy() : figure.getBounds().getCopy();
    }

    protected Object getConstraintForClone(GraphicalEditPart part, ChangeBoundsRequest request) {
        IFigure figure = part.getFigure();
        PrecisionRectangle bounds = new PrecisionRectangle(this.getEffectiveBounds(figure));
        figure.translateToAbsolute((Translatable)bounds);
        bounds = request.getTransformedRectangle((Rectangle)bounds);
        ((GraphicalEditPart)this.getHost()).getContentPane().translateToRelative((Translatable)bounds);
        bounds.translate(this.getLayoutOrigin().getNegated());
        return this.getConstraintFor((Rectangle)bounds);
    }

    protected Object getConstraintFor(CreateRequest request) {
        Object constraint = super.getConstraintFor(request);
        if (constraint instanceof Rectangle) {
            Rectangle rectConstraint = (Rectangle)constraint;
            if (rectConstraint.width != -1 && rectConstraint.width < 8) {
                rectConstraint.width = 8;
            }
            if (rectConstraint.height != -1 && rectConstraint.height < 8) {
                rectConstraint.height = 8;
            }
        }
        return constraint;
    }

    protected Command getAddCommand(Request generic) {
        ChangeBoundsRequest request = (ChangeBoundsRequest)generic;
        List editParts = request.getEditParts();
        CompoundCommand command = new CompoundCommand();
        command.setDebugLabel("Add in ConstrainedLayoutEditPolicy");
        int i = 0;
        while (i < editParts.size()) {
            GraphicalEditPart child = (GraphicalEditPart)editParts.get(i);
            if (child instanceof ConnectionEditPart) {
                command.add(child.getCommand(generic));
            } else {
                command.add(this.createAddCommand(request, (EditPart)child, this.translateToModelConstraint(this.getConstraintFor(request, child))));
            }
            ++i;
        }
        return command.unwrap();
    }

    protected Rectangle getCurrentConstraintFor(GraphicalEditPart child) {
        IFigure fig = child.getFigure();
        Object constraint = fig.getParent().getLayoutManager().getConstraint(fig);
        if (constraint instanceof Rectangle) {
            return (Rectangle)constraint;
        }
        return null;
    }
}

