/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.common.freezone;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class FreeZoneLayout
extends XYLayout {
    protected void fitChildRectangleInClientArea(Rectangle clientArea, Rectangle childRectangle) {
        childRectangle.x = Math.min(childRectangle.right(), clientArea.right()) - childRectangle.width;
        childRectangle.y = Math.min(childRectangle.bottom(), clientArea.bottom()) - childRectangle.height;
        childRectangle.x = Math.max(childRectangle.x, clientArea.x);
        childRectangle.y = Math.max(childRectangle.y, clientArea.y);
        childRectangle.width = Math.min(childRectangle.width, clientArea.width);
        childRectangle.height = Math.min(childRectangle.height, clientArea.height);
        if (childRectangle.width < -1) {
            childRectangle.width = -1;
        }
        if (childRectangle.height < -1) {
            childRectangle.height = -1;
        }
    }

    public void layout(IFigure parent) {
        Iterator children = parent.getChildren().iterator();
        Point offset = this.getOrigin(parent);
        while (children.hasNext()) {
            IFigure f = (IFigure)children.next();
            Rectangle bounds = (Rectangle)this.getConstraint(f);
            if (bounds == null) continue;
            bounds = bounds.getCopy();
            if (bounds.width == -1 || bounds.height == -1) {
                Dimension childPreferredSize = f.getPreferredSize(bounds.width, bounds.height);
                if (bounds.width == -1) {
                    bounds.width = childPreferredSize.width;
                }
                if (bounds.height == -1) {
                    bounds.height = childPreferredSize.height;
                }
            }
            bounds = bounds.getTranslated(offset);
            this.fitChildRectangleInClientArea(parent.getClientArea(), bounds);
            f.setBounds(bounds);
        }
    }

    public Dimension getMinimumSize(IFigure container, int wHint, int hHint) {
        Rectangle rect = new Rectangle();
        ListIterator children = container.getChildren().listIterator();
        while (children.hasNext()) {
            IFigure child = (IFigure)children.next();
            Rectangle r = (Rectangle)this.constraints.get(child);
            if (r == null) continue;
            r = r.getCopy();
            if (r.width == -1 || r.height == -1) {
                Dimension childPreferredSize = child.getPreferredSize(r.width, r.height);
                if (r.width == -1) {
                    r.width = childPreferredSize.width;
                }
                if (r.height == -1) {
                    r.height = childPreferredSize.height;
                }
            }
            rect.union(r);
        }
        Dimension d = rect.getSize();
        Insets insets = container.getInsets();
        return new Dimension(d.width + insets.getWidth(), d.height + insets.getHeight()).union(this.getBorderPreferredSize(container));
    }
}

