/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.common.header;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITagParameter;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITaggedValue;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.model.IEditableText;
import com.modeliosoft.modelio.diagram.elements.core.model.IImageServices;
import com.modeliosoft.modelio.diagram.elements.core.node.GmSimpleNode;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public abstract class GmModelElementHeader
extends GmSimpleNode
implements IEditableText {
    private String label;
    private boolean showMetaclassIcon = false;
    private boolean showMetaclassKeyword = false;
    private boolean stackedStereotypes = false;
    private boolean showLabel = true;
    private final int minorVersion = 0;
    private static final int MAJOR_VERSION = 0;

    public GmModelElementHeader() {
    }

    public GmModelElementHeader(GmAbstractDiagram diagram, ObRef relatedRef) {
        super(diagram, relatedRef);
        this.init();
    }

    public abstract List<IStereotype> filterStereotypes(List<IStereotype> var1);

    public abstract List<ITaggedValue> filterTags(List<ITaggedValue> var1);

    public IEditableText getEditableText() {
        return this;
    }

    public List<Image> getStereotypeIcons() {
        if (this.getRelatedIElement() != null && this.getRelatedIElement().isValid()) {
            List stereotypes = this.filterStereotypes((List)this.getRelatedIElement().getExtension());
            ArrayList<Image> ret = new ArrayList<Image>();
            IImageServices ss = this.getDiagram().getImageServices();
            for (IStereotype s : stereotypes) {
                Image im = ss.getStereotypeIcon(s);
                if (im == null) continue;
                ret.add(im);
            }
            return ret;
        }
        return Collections.emptyList();
    }

    public List<String> getStereotypeLabels() {
        if (this.getRelatedIElement() != null && this.getRelatedIElement().isValid()) {
            List stereotypes = this.filterStereotypes((List)this.getRelatedIElement().getExtension());
            if (this.stackedStereotypes) {
                return this.getStackedStereotypeLabels(stereotypes);
            }
            return this.getLinedStereotypeLabels(stereotypes);
        }
        return Collections.emptyList();
    }

    public List<String> getTaggedValueLabels() {
        ArrayList<String> labels = new ArrayList<String>();
        if (this.getRelatedIElement() != null && this.getRelatedIElement().isValid()) {
            for (ITaggedValue tag : this.filterTags((List)this.getRelatedIElement().getTag())) {
                labels.add(this.makeTagLabel(tag));
            }
        }
        return labels;
    }

    public String getText() {
        IModelElement relatedIElement = this.getRelatedIElement();
        if (relatedIElement == null || !relatedIElement.isValid()) {
            return "?";
        }
        return relatedIElement.getName();
    }

    public boolean isShowMetaclassIcon() {
        return this.showMetaclassIcon;
    }

    public boolean isShowMetaclassKeyword() {
        return this.showMetaclassKeyword;
    }

    public void obElementAdded(IElement addedEl) {
        super.obElementAdded(addedEl);
        if (addedEl instanceof ITaggedValue || addedEl instanceof IStereotype) {
            this.refreshFromObModel();
        }
    }

    public void read(IDiagramReader in) {
        Object versionProperty = in.readProperty("GmModelElementHeader.version");
        int readVersion = versionProperty == null ? 0 : (Integer)versionProperty;
        switch (readVersion) {
            case 0: {
                this.read_0(in);
                break;
            }
            default: {
                assert (false) : "version number not covered!";
                this.read_0(in);
            }
        }
    }

    public void refreshFromObModel() {
        this.updateMainLabelFromObModel();
        this.firePropertyChange("Name", (Object)this, null);
    }

    public void setShowMetaclassIcon(boolean value) {
        this.showMetaclassIcon = value;
    }

    public void setShowMetaclassKeyword(boolean value) {
        this.showMetaclassKeyword = value;
    }

    public void setStackedStereotypes(boolean value) {
        this.stackedStereotypes = value;
    }

    public void setText(String newName) {
        this.getRelatedIElement().setName(newName);
    }

    protected String computeMainLabel() {
        return this.getRelatedIElement().getName();
    }

    protected boolean updateMainLabelFromObModel() {
        if (this.getRelatedIElement() != null && this.getRelatedIElement().isValid()) {
            String newName = this.computeMainLabel();
            if (this.label == null || !this.label.equals(newName)) {
                this.label = newName;
                return true;
            }
        }
        return false;
    }

    private List<String> getLinedStereotypeLabels(List<IStereotype> stereotypes) {
        ArrayList<String> labels = new ArrayList<String>();
        StringBuffer line = new StringBuffer();
        if (stereotypes.isEmpty()) {
            return labels;
        }
        line.append("<<");
        for (IStereotype s : stereotypes) {
            String aLabel = s.getLabel().isEmpty() ? s.getName() : s.getLabel();
            line.append(aLabel);
            line.append(", ");
        }
        line.delete(line.length() - 2, line.length());
        line.append(">>");
        labels.add(line.toString());
        return labels;
    }

    private List<String> getStackedStereotypeLabels(List<IStereotype> stereotypes) {
        ArrayList<String> labels = new ArrayList<String>();
        for (IStereotype s : stereotypes) {
            labels.add("<<" + (s.getLabel().isEmpty() ? s.getName() : s.getLabel()) + ">>");
        }
        return labels;
    }

    private void init() {
        if (this.getRelatedIElement() != null && this.getRelatedIElement().isValid()) {
            this.label = this.computeMainLabel();
        }
    }

    private String makeTagLabel(ITaggedValue tag) {
        StringBuffer buf = new StringBuffer();
        String tagLabel = tag.getDefinition().getLabel().isEmpty() ? tag.getDefinition().getName() : tag.getDefinition().getLabel();
        IStereotype s = tag.getDefinition().getOwnerStereotype();
        buf.append("{");
        if (s != null) {
            buf.append(s.getName());
            buf.append(".");
        }
        buf.append(tagLabel);
        if (tag.getActual().size() > 0) {
            buf.append("(");
            for (ITagParameter param : tag.getActual()) {
                buf.append(String.valueOf(param.getValue().toString()) + ", ");
            }
            buf.delete(buf.length() - 2, buf.length());
            buf.append(")");
        }
        buf.append("}");
        return buf.toString();
    }

    public void write(IDiagramWriter out) {
        super.write(out);
        out.writeProperty("show_icon", Boolean.valueOf(this.showMetaclassIcon));
        out.writeProperty("show_keyword", Boolean.valueOf(this.showMetaclassKeyword));
        out.writeProperty("stack_stereo", Boolean.valueOf(this.stackedStereotypes));
        out.writeProperty("show_label", Boolean.valueOf(this.showLabel));
        if (false) {
            out.writeProperty("GmModelElementHeader.version", (Object)0);
        }
    }

    public String getMainLabel() {
        if (this.label == null) {
            this.updateMainLabelFromObModel();
        }
        return this.label;
    }

    public IModelElement getRelatedIElement() {
        return (IModelElement)super.getRelatedIElement();
    }

    public boolean isShowLabel() {
        return this.showLabel;
    }

    public void setShowLabel(boolean value) {
        this.showLabel = value;
    }

    protected Image getMetaclassIcon() {
        return this.getDiagram().getImageServices().getMetaclassIcon((IElement)this.getRelatedIElement());
    }

    private void read_0(IDiagramReader in) {
        super.read(in);
        this.showMetaclassIcon = (Boolean)in.readProperty("show_icon");
        this.showMetaclassKeyword = (Boolean)in.readProperty("show_keyword");
        this.stackedStereotypes = (Boolean)in.readProperty("stack_stereo");
        this.showLabel = (Boolean)in.readProperty("show_label");
        this.init();
    }

    public int getMajorVersion() {
        return 0;
    }
}

