/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.common.header;

import com.modeliosoft.modelio.core.ui.CoreFontRegistry;
import com.modeliosoft.modelio.diagram.elements.common.header.GridLayoutFixed;
import com.modeliosoft.modelio.diagram.elements.common.header.HeaderFigure;
import com.modeliosoft.modelio.diagram.elements.core.figures.GradientFigure;
import com.modeliosoft.modelio.diagram.elements.core.figures.LabelFigure;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;

public class HeaderFigure
extends GradientFigure {
    protected Figure iconsArea;
    protected Figure leftIconsContainer;
    protected Figure rightIconsContainer;
    protected Label keywordLabel;
    protected Figure topLabelsArea;
    protected LabelFigure mainLabel;
    protected Figure bottomLabelsArea;
    protected Font stereotypeFont = null;
    protected Figure contentsArea;
    protected Font tagFont = null;
    protected Figure table;

    public HeaderFigure() {
        this.setLayoutManager((LayoutManager)new BorderLayout());
        this.iconsArea = new Figure();
        this.iconsArea.setLayoutManager((LayoutManager)new BorderLayout());
        this.add((IFigure)this.iconsArea, (Object)BorderLayout.TOP);
        this.leftIconsContainer = new Figure();
        ToolbarLayout leftIconAreaLayout = new ToolbarLayout(true);
        leftIconAreaLayout.setMinorAlignment(2);
        leftIconAreaLayout.setSpacing(1);
        this.leftIconsContainer.setLayoutManager((LayoutManager)leftIconAreaLayout);
        this.leftIconsContainer.setOpaque(false);
        this.iconsArea.add((IFigure)this.leftIconsContainer, (Object)BorderLayout.LEFT);
        this.rightIconsContainer = new Figure();
        ToolbarRLayout righIconAreaLayout = new ToolbarRLayout(true);
        righIconAreaLayout.setMinorAlignment(2);
        righIconAreaLayout.setSpacing(1);
        this.rightIconsContainer.setLayoutManager((LayoutManager)righIconAreaLayout);
        this.rightIconsContainer.setOpaque(false);
        this.iconsArea.add((IFigure)this.rightIconsContainer, (Object)BorderLayout.RIGHT);
        this.contentsArea = new Figure();
        GridLayoutFixed gl = new GridLayoutFixed(1, true);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        this.contentsArea.setLayoutManager((LayoutManager)gl);
        this.add((IFigure)this.contentsArea, (Object)BorderLayout.CENTER);
        this.table = new Figure();
        ToolbarLayout tbLayout = new ToolbarLayout(false);
        tbLayout.setStretchMinorAxis(true);
        tbLayout.setMinorAlignment(0);
        this.table.setLayoutManager((LayoutManager)tbLayout);
        GridData gd = new GridData(4, 0x1000000, true, true);
        this.contentsArea.add((IFigure)this.table, (Object)gd);
        this.keywordLabel = new Label("");
        this.keywordLabel.setLabelAlignment(2);
        this.keywordLabel.setOpaque(false);
        this.table.add((IFigure)this.keywordLabel, (Object)gd);
        this.topLabelsArea = new Figure();
        ToolbarLayout topAreaLayout = new ToolbarLayout(false);
        topAreaLayout.setSpacing(0);
        topAreaLayout.setMinorAlignment(0);
        topAreaLayout.setStretchMinorAxis(true);
        this.topLabelsArea.setLayoutManager((LayoutManager)topAreaLayout);
        this.topLabelsArea.setOpaque(false);
        this.table.add((IFigure)this.topLabelsArea);
        this.mainLabel = new LabelFigure();
        this.mainLabel.setLabelAlignment(2);
        this.mainLabel.setBorder((Border)new MarginBorder(2, 0, 4, 0));
        this.table.add((IFigure)this.mainLabel);
        this.bottomLabelsArea = new Figure();
        ToolbarLayout bottomAreaLayout = new ToolbarLayout(false);
        bottomAreaLayout.setSpacing(0);
        bottomAreaLayout.setMinorAlignment(0);
        bottomAreaLayout.setStretchMinorAxis(true);
        this.bottomLabelsArea.setLayoutManager((LayoutManager)bottomAreaLayout);
        this.bottomLabelsArea.setOpaque(false);
        this.table.add((IFigure)this.bottomLabelsArea);
    }

    public void setLeftIcons(List<Image> icons) {
        this.leftIconsContainer.removeAll();
        for (Image img : icons) {
            ImageFigure imgFigure = new ImageFigure(img);
            this.leftIconsContainer.add((IFigure)imgFigure);
        }
    }

    public void setRightIcons(List<Image> icons) {
        this.rightIconsContainer.removeAll();
        for (Image img : icons) {
            ImageFigure imgFigure = new ImageFigure(img);
            this.rightIconsContainer.add((IFigure)imgFigure);
        }
    }

    public void setKeywordLabel(String text) {
        if (text == null) {
            if (this.keywordLabel != null) {
                this.table.remove((IFigure)this.keywordLabel);
                this.keywordLabel = null;
            }
        } else if (this.keywordLabel != null) {
            this.keywordLabel.setText(text);
        } else {
            this.keywordLabel = new Label(text);
            this.keywordLabel.setLabelAlignment(2);
            this.keywordLabel.setOpaque(false);
            this.keywordLabel.setFont(this.stereotypeFont);
            this.table.add((IFigure)this.keywordLabel, 1);
        }
    }

    public void setTopLabels(List<String> topLabels) {
        this.topLabelsArea.removeAll();
        for (String s : topLabels) {
            Label labelFigure = new Label(s);
            labelFigure.setTextAlignment(2);
            this.topLabelsArea.add((IFigure)labelFigure);
        }
    }

    public void setMainLabel(String s) {
        this.mainLabel.setText(s);
    }

    public void setBottomLabels(List<String> bottomLabels) {
        this.bottomLabelsArea.removeAll();
        for (String s : bottomLabels) {
            Label labelFigure = new Label(s);
            labelFigure.setTextAlignment(2);
            this.bottomLabelsArea.add((IFigure)labelFigure);
        }
    }

    Label getMainLabelFigure() {
        return this.mainLabel;
    }

    public Color getTextColor() {
        return this.mainLabel.getForegroundColor();
    }

    public Font getTextFont() {
        return this.mainLabel.getFont();
    }

    public void setTextColor(Color textColor) {
        this.topLabelsArea.setForegroundColor(textColor);
        if (this.keywordLabel != null) {
            this.keywordLabel.setForegroundColor(textColor);
        }
        this.mainLabel.setForegroundColor(textColor);
        this.bottomLabelsArea.setForegroundColor(textColor);
    }

    public void setTextFont(Font textFont) {
        this.updateDerivedFonts(textFont);
        this.topLabelsArea.setFont(this.stereotypeFont);
        if (this.keywordLabel != null) {
            this.keywordLabel.setFont(this.stereotypeFont);
        }
        this.mainLabel.setFont(textFont);
        this.bottomLabelsArea.setFont(this.tagFont);
    }

    private void updateDerivedFonts(Font baseFont) {
        FontData[] fontData;
        if (this.mainLabel.getFont() == baseFont && this.tagFont != null && this.stereotypeFont != null) {
            return;
        }
        FontData[] fontDataArray = fontData = baseFont.getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData data = fontDataArray[n2];
            data.setHeight(this.deriveFontHeight(data.getHeight()));
            ++n2;
        }
        this.stereotypeFont = CoreFontRegistry.getFont((FontData[])fontData);
        this.tagFont = CoreFontRegistry.getModifiedFont((Font)this.stereotypeFont, (int)2);
    }

    public Color getLineColor() {
        return null;
    }

    public int getLineWidth() {
        return 0;
    }

    public void setLineColor(Color lineColor) {
    }

    public void setLineWidth(int lineWidth) {
    }

    private int deriveFontHeight(int height) {
        switch (height) {
            case 8: {
                return 7;
            }
            case 9: {
                return 7;
            }
            case 10: {
                return 8;
            }
            case 11: {
                return 8;
            }
            case 12: {
                return 9;
            }
            case 13: {
                return 10;
            }
            case 14: {
                return 10;
            }
        }
        if (height < 8) {
            return height;
        }
        return height * 10 / 14;
    }

    public Dimension getMinimumSize(int wHint, int hHint) {
        return super.getMinimumSize(wHint, -1);
    }

    public void setUnderline(boolean underline) {
        this.mainLabel.setUnderline(underline);
    }

    public void setStrikeThrough(boolean strikeThrough) {
        this.mainLabel.setStrikeThrough(strikeThrough);
    }
}

