/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.common.header;

import com.modeliosoft.modelio.core.ui.CoreFontRegistry;
import com.modeliosoft.modelio.diagram.elements.common.header.HeaderTextFlow;
import com.modeliosoft.modelio.diagram.elements.common.header.WrappedHeaderFigure;
import com.modeliosoft.modelio.diagram.elements.core.figures.GradientFigure;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.text.BlockFlow;
import org.eclipse.draw2d.text.FlowContext;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;

public class WrappedHeaderFigure
extends GradientFigure {
    protected Figure iconsArea;
    protected Figure leftIconsContainer;
    protected Figure rightIconsContainer;
    protected TextFlow keywordLabel;
    protected BlockFlow topLabelsArea;
    protected HeaderTextFlow mainLabel;
    protected BlockFlow bottomLabelsArea;
    protected Font stereotypeFont = null;
    protected Font tagFont = null;
    protected FlowPage table;

    public WrappedHeaderFigure() {
        WrappedHeaderFigure container = this;
        container.setLayoutManager((LayoutManager)new BorderLayout());
        this.iconsArea = new Figure();
        this.iconsArea.setLayoutManager((LayoutManager)new BorderLayout());
        container.add((IFigure)this.iconsArea, (Object)BorderLayout.TOP);
        this.leftIconsContainer = new Figure();
        ToolbarLayout leftIconAreaLayout = new ToolbarLayout(true);
        leftIconAreaLayout.setMinorAlignment(2);
        leftIconAreaLayout.setSpacing(1);
        this.leftIconsContainer.setLayoutManager((LayoutManager)leftIconAreaLayout);
        this.leftIconsContainer.setOpaque(false);
        this.iconsArea.add((IFigure)this.leftIconsContainer, (Object)BorderLayout.LEFT);
        this.rightIconsContainer = new Figure();
        ToolbarRLayout righIconAreaLayout = new ToolbarRLayout();
        righIconAreaLayout.setMinorAlignment(2);
        righIconAreaLayout.setSpacing(1);
        this.rightIconsContainer.setLayoutManager((LayoutManager)righIconAreaLayout);
        this.rightIconsContainer.setOpaque(false);
        this.iconsArea.add((IFigure)this.rightIconsContainer, (Object)BorderLayout.RIGHT);
        Figure contentArea = new Figure();
        container.add((IFigure)contentArea, (Object)BorderLayout.CENTER);
        contentArea.setLayoutManager((LayoutManager)new CenterAreaLayout());
        this.table = new FlowPage();
        contentArea.add((IFigure)this.table, (Object)new GridData(4, 0x1000000, true, true));
        BlockFlow keywordBlock = new BlockFlow();
        keywordBlock.setHorizontalAligment(2);
        this.keywordLabel = new TextFlow("");
        keywordBlock.add((IFigure)this.keywordLabel);
        this.table.add((IFigure)keywordBlock);
        this.topLabelsArea = new BlockFlow();
        this.topLabelsArea.setHorizontalAligment(2);
        this.table.add((IFigure)this.topLabelsArea);
        BlockFlow mainLabelBlock = new BlockFlow();
        mainLabelBlock.setHorizontalAligment(2);
        this.mainLabel = new HeaderTextFlow();
        mainLabelBlock.add((IFigure)this.mainLabel);
        mainLabelBlock.setBorder((Border)new MarginFlowBorder(new Insets(2, 0, 4, 0)));
        this.table.add((IFigure)mainLabelBlock);
    }

    public void setLeftIcons(List<Image> icons) {
        this.leftIconsContainer.removeAll();
        for (Image img : icons) {
            ImageFigure imgFigure = new ImageFigure(img);
            this.leftIconsContainer.add((IFigure)imgFigure);
        }
    }

    public void setRightIcons(List<Image> icons) {
        this.rightIconsContainer.removeAll();
        for (Image img : icons) {
            ImageFigure imgFigure = new ImageFigure(img);
            this.rightIconsContainer.add((IFigure)imgFigure);
        }
    }

    public void setKeywordLabel(String text) {
        if (text == null) {
            if (this.keywordLabel != null) {
                this.table.remove(this.keywordLabel.getParent());
                this.keywordLabel = null;
            }
        } else if (this.keywordLabel != null) {
            this.keywordLabel.setText(text);
        } else {
            BlockFlow keywordBlock = new BlockFlow();
            keywordBlock.setHorizontalAligment(2);
            this.keywordLabel = new TextFlow(text);
            this.keywordLabel.setOpaque(false);
            this.keywordLabel.setFont(this.stereotypeFont);
            keywordBlock.setFlowContext((FlowContext)this.table.getLayoutManager());
            this.table.add((IFigure)keywordBlock, 1);
            this.keywordLabel.setFlowContext((FlowContext)keywordBlock.getLayoutManager());
            keywordBlock.add((IFigure)this.keywordLabel);
        }
    }

    public void setTopLabels(List<String> topLabels) {
        this.topLabelsArea.removeAll();
        if (topLabels.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder(topLabels.size() * 20);
        for (String s : topLabels) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(s.replace(" ", "\u00a0"));
        }
        TextFlow labelFigure = new TextFlow(sb.toString());
        labelFigure.setFlowContext((FlowContext)this.topLabelsArea.getLayoutManager());
        this.topLabelsArea.add((IFigure)labelFigure);
    }

    public void setMainLabel(String s) {
        this.mainLabel.setText(s);
        this.revalidate();
    }

    public void setBottomLabels(List<String> bottomLabels) {
        if (bottomLabels == null || bottomLabels.isEmpty()) {
            if (this.bottomLabelsArea != null) {
                this.table.remove((IFigure)this.bottomLabelsArea);
                this.bottomLabelsArea = null;
            }
        } else {
            if (this.bottomLabelsArea == null) {
                this.bottomLabelsArea = new BlockFlow();
                this.bottomLabelsArea.setHorizontalAligment(2);
                this.bottomLabelsArea.setFont(this.tagFont);
                this.bottomLabelsArea.setForegroundColor(this.mainLabel.getForegroundColor());
                this.bottomLabelsArea.setFlowContext((FlowContext)this.table.getLayoutManager());
                this.table.add((IFigure)this.bottomLabelsArea);
            } else {
                this.bottomLabelsArea.removeAll();
            }
            StringBuilder sb = new StringBuilder(bottomLabels.size() * 20);
            for (String s : bottomLabels) {
                if (sb.length() != 0) {
                    sb.append("\n");
                }
                sb.append(s);
            }
            TextFlow labelFigure = new TextFlow(sb.toString());
            labelFigure.setFlowContext((FlowContext)this.bottomLabelsArea.getLayoutManager());
            this.bottomLabelsArea.add((IFigure)labelFigure);
        }
    }

    TextFlow getMainLabelFigure() {
        return this.mainLabel;
    }

    public Color getTextColor() {
        return this.mainLabel.getForegroundColor();
    }

    public Font getTextFont() {
        return this.mainLabel.getFont();
    }

    public void setTextColor(Color textColor) {
        this.topLabelsArea.setForegroundColor(textColor);
        if (this.keywordLabel != null) {
            this.keywordLabel.setForegroundColor(textColor);
        }
        this.mainLabel.setForegroundColor(textColor);
        if (this.bottomLabelsArea != null) {
            this.bottomLabelsArea.setForegroundColor(textColor);
        }
    }

    public void setTextFont(Font textFont) {
        this.updateDerivedFonts(textFont);
        this.topLabelsArea.setFont(this.stereotypeFont);
        if (this.keywordLabel != null) {
            this.keywordLabel.setFont(this.stereotypeFont);
        }
        this.mainLabel.setFont(textFont);
        if (this.bottomLabelsArea != null) {
            this.bottomLabelsArea.setFont(this.tagFont);
        }
    }

    private void updateDerivedFonts(Font baseFont) {
        FontData[] fontData;
        if (this.mainLabel.getFont() == baseFont && this.tagFont != null && this.stereotypeFont != null) {
            return;
        }
        FontData[] fontDataArray = fontData = baseFont.getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData data = fontDataArray[n2];
            data.setHeight(this.deriveFontHeight(data.getHeight()));
            ++n2;
        }
        this.stereotypeFont = CoreFontRegistry.getFont((FontData[])fontData);
        this.tagFont = CoreFontRegistry.getModifiedFont((Font)this.stereotypeFont, (int)2);
    }

    public Color getLineColor() {
        return null;
    }

    public int getLineWidth() {
        return 0;
    }

    public void setLineColor(Color lineColor) {
    }

    public void setLineWidth(int lineWidth) {
    }

    private int deriveFontHeight(int height) {
        switch (height) {
            case 8: {
                return 7;
            }
            case 9: {
                return 7;
            }
            case 10: {
                return 8;
            }
            case 11: {
                return 8;
            }
            case 12: {
                return 9;
            }
            case 13: {
                return 10;
            }
            case 14: {
                return 10;
            }
        }
        if (height < 8) {
            return height;
        }
        return height * 10 / 14;
    }

    public Dimension getMinimumSize(int wHint, int hHint) {
        return super.getMinimumSize(wHint, -1);
    }

    public void setUnderline(boolean underline) {
        this.mainLabel.setUnderline(underline);
    }

    public void setStrikeThrough(boolean strikeThrough) {
        this.mainLabel.setStrikeThrough(strikeThrough);
    }
}

