/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.common.label.modelelement;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITagParameter;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITagType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITaggedValue;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.common.label.base.GmElementLabel;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.core.model.IEditableText;
import com.modeliosoft.modelio.diagram.elements.core.model.IImageServices;
import com.modeliosoft.modelio.diagram.persistence.IDiagramReader;
import com.modeliosoft.modelio.diagram.persistence.IDiagramWriter;
import com.modeliosoft.modelio.diagram.styles.core.IStyle;
import com.modeliosoft.modelio.diagram.styles.core.MetaKey;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public abstract class GmModelElementFlatHeader
extends GmElementLabel {
    private boolean displayStereotypesAsStack = false;
    private boolean showLabel = true;
    private boolean showMetaclassIcon = false;
    private boolean showMetaclassKeyword = false;
    private final int minorVersion = 0;
    private static final int MAJOR_VERSION = 0;

    public GmModelElementFlatHeader(GmAbstractDiagram diagram, ObRef relatedRef) {
        super(diagram, relatedRef);
        this.init();
    }

    public GmModelElementFlatHeader() {
    }

    public abstract List<IStereotype> filterStereotypes(List<IStereotype> var1);

    public abstract List<ITaggedValue> filterTags(List<ITaggedValue> var1);

    public abstract IEditableText getEditableText();

    public IModelElement getRelatedIElement() {
        return (IModelElement)super.getRelatedIElement();
    }

    public List<Image> getStereotypeIcons() {
        if (this.getRelatedIElement() != null) {
            List stereotypes = this.filterStereotypes((List)this.getRelatedIElement().getExtension());
            ArrayList<Image> ret = new ArrayList<Image>(stereotypes.size());
            IImageServices ss = this.getDiagram().getImageServices();
            for (IStereotype s : stereotypes) {
                Image im = ss.getStereotypeIcon(s);
                if (im == null) continue;
                ret.add(im);
            }
            return ret;
        }
        return Collections.emptyList();
    }

    public String getStereotypesLabel() {
        if (this.getRelatedIElement() != null) {
            List stereotypes = this.filterStereotypes((List)this.getRelatedIElement().getExtension());
            if (this.displayStereotypesAsStack) {
                return this.getStackedStereotypesLabel(stereotypes);
            }
            return this.getLinedStereotypesLabel(stereotypes);
        }
        return "";
    }

    public String getTaggedValuesLabel() {
        StringBuilder labels = new StringBuilder();
        if (this.getRelatedIElement() != null) {
            for (ITaggedValue tag : this.filterTags((List)this.getRelatedIElement().getTag())) {
                this.makeTagLabel(tag, labels);
            }
        }
        return labels.toString();
    }

    public boolean isShowLabel() {
        return this.showLabel;
    }

    public boolean isShowMetaclassIcon() {
        return this.showMetaclassIcon;
    }

    public boolean isShowMetaclassKeyword() {
        return this.showMetaclassKeyword;
    }

    public void obElementAdded(IElement addedEl) {
        super.obElementAdded(addedEl);
        if (addedEl instanceof ITaggedValue || addedEl instanceof IStereotype) {
            this.refreshFromObModel();
        }
    }

    public void read(IDiagramReader in) {
        Object versionProperty = in.readProperty("GmModelElementFlatHeader.version");
        int readVersion = versionProperty == null ? 0 : (Integer)versionProperty;
        switch (readVersion) {
            case 0: {
                this.read_0(in);
                break;
            }
            default: {
                assert (false) : "version number not covered!";
                this.read_0(in);
            }
        }
    }

    public void refreshFromObModel() {
        super.refreshFromObModel();
        this.firePropertyChange("Name", (Object)this, null);
    }

    public void setDisplayStereotypesAsStack(boolean value) {
        this.displayStereotypesAsStack = value;
    }

    public void setShowLabel(boolean value) {
        this.showLabel = value;
    }

    public void setShowMetaclassIcon(boolean value) {
        this.showMetaclassIcon = value;
    }

    public void setShowMetaclassKeyword(boolean value) {
        this.showMetaclassKeyword = value;
    }

    public void styleChanged(IStyle changedStyle) {
        super.styleChanged(changedStyle);
        this.firePropertyChange("Name", (Object)this, null);
    }

    public void styleChanged(StyleKey property, Object newValue) {
        super.styleChanged(property, newValue);
        GmModel parent = this.getParent();
        if (parent != null) {
            StyleKey showStereotypesKey = parent.getStyleKey(MetaKey.SHOWSTEREOTYPES);
            StyleKey showTagKey = parent.getStyleKey(MetaKey.SHOWTAGS);
            if (showStereotypesKey != null && showStereotypesKey.equals((Object)property) || showTagKey != null && showTagKey.equals((Object)property)) {
                this.firePropertyChange("Name", (Object)this, null);
            }
        }
    }

    public void write(IDiagramWriter out) {
        super.write(out);
        out.writeProperty("show_icon", Boolean.valueOf(this.showMetaclassIcon));
        out.writeProperty("show_keyword", Boolean.valueOf(this.showMetaclassKeyword));
        out.writeProperty("stack_stereo", Boolean.valueOf(this.displayStereotypesAsStack));
        out.writeProperty("show_label", Boolean.valueOf(this.showLabel));
        if (false) {
            out.writeProperty("GmModelElementFlatHeader.version", (Object)0);
        }
    }

    private String getLinedStereotypesLabel(List<IStereotype> stereotypes) {
        StringBuffer line = new StringBuffer();
        if (stereotypes.isEmpty()) {
            return "";
        }
        line.append("<<");
        for (IStereotype s : stereotypes) {
            String aLabel = s.getLabel().isEmpty() ? s.getName() : s.getLabel();
            line.append(aLabel);
            line.append(", ");
        }
        line.delete(line.length() - 2, line.length());
        line.append(">>");
        return line.toString();
    }

    private String getStackedStereotypesLabel(List<IStereotype> stereotypes) {
        StringBuilder labels = new StringBuilder();
        for (IStereotype s : stereotypes) {
            labels.append("<<");
            labels.append(s.getLabel().isEmpty() ? s.getName() : s.getLabel());
            labels.append(">>");
        }
        return labels.toString();
    }

    private void init() {
        if (this.getRelatedIElement() != null) {
            this.label = this.computeLabel();
        }
    }

    private void makeTagLabel(ITaggedValue tag, StringBuilder buf) {
        String tagLabel;
        ITagType tagType = tag.getDefinition();
        buf.append("{");
        IStereotype s = tagType.getOwnerStereotype();
        if (s != null) {
            buf.append(s.getName());
            buf.append(".");
        }
        if ((tagLabel = tagType.getLabel()).isEmpty()) {
            tagLabel = tagType.getName();
        }
        buf.append(tagLabel);
        ObList tagParameters = tag.getActual();
        if (tagParameters.size() > 0) {
            buf.append("(");
            for (ITagParameter param : tagParameters) {
                buf.append(String.valueOf(param.getValue().toString()) + ", ");
            }
            buf.delete(buf.length() - 2, buf.length());
            buf.append(")");
        }
        buf.append("}");
    }

    protected Image getMetaclassIcon() {
        return this.getDiagram().getImageServices().getMetaclassIcon((IElement)this.getRelatedIElement());
    }

    private void read_0(IDiagramReader in) {
        super.read(in);
        this.showMetaclassIcon = (Boolean)in.readProperty("show_icon");
        this.showMetaclassKeyword = (Boolean)in.readProperty("show_keyword");
        this.displayStereotypesAsStack = (Boolean)in.readProperty("stack_stereo");
        this.showLabel = (Boolean)in.readProperty("show_label");
        this.init();
    }

    public int getMajorVersion() {
        return 0;
    }
}

