/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.common.linkednode;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.utils.exceptions.InvalidModelManipulationException;
import com.modeliosoft.modelio.core.factory.IElementInitializer;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.core.model.CompositionExpert;
import com.modeliosoft.modelio.core.model.Meta;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.common.linkednode.CreateLinkedNodeCommand;
import com.modeliosoft.modelio.diagram.elements.core.commands.ModelioCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.helpers.AnchorModelHelper;
import com.modeliosoft.modelio.diagram.elements.core.helpers.AuthHelper;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLink;
import com.modeliosoft.modelio.diagram.elements.core.link.GmPath;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLink;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLinkable;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreationFactory;

public class CreateLinkedNodeCommand
extends Command {
    protected final ModelioCreationContext context;
    protected Point location;
    protected IElement parentElement;
    protected IGmLinkable sourceNode;
    protected Dimension size = new Dimension(-1, -1);
    protected GmCompositeNode destNode;
    protected EditPart sourceEditPart;
    protected Object sourceAnchor;

    public CreateLinkedNodeCommand(ModelioCreationContext context) {
        this.context = context;
    }

    public void execute() {
        GmAbstractDiagram diagram = this.sourceNode.getDiagram();
        IElement newElement = this.context.getElementToUnmask();
        if (newElement == null && (newElement = this.createElement(diagram.getModelFactory(), diagram.getElementInitializer())) == null) {
            return;
        }
        Rectangle rect = this.size != null ? new Rectangle(this.location, this.size) : new Rectangle(this.location, new Dimension(-1, -1));
        GmNodeModel createdNode = diagram.unmask(this.destNode, newElement, (Object)rect);
        if (this.sourceNode != this.destNode) {
            CreateConnectionRequest connCreateRequest = this.getConnectionCreationRequest(createdNode);
            IGmLinkable linkTarget = (IGmLinkable)connCreateRequest.getTargetEditPart().getModel();
            GmLink gmlink = diagram.unmaskLink(newElement);
            linkTarget.addEndingLink((IGmLink)gmlink);
            this.sourceNode.addStartingLink((IGmLink)gmlink);
            GmPath path = new GmPath();
            path.setSourceAnchor(this.sourceAnchor);
            path.setTargetAnchor(AnchorModelHelper.getTargetAnchorModel((CreateConnectionRequest)connCreateRequest));
            path.setPathData(new ArrayList());
            gmlink.setLayoutData((Object)path);
        }
    }

    public void setDestinationNode(GmCompositeNode destNode) {
        this.destNode = destNode;
    }

    public void setNodeLocation(Point location) {
        this.location = location;
    }

    public void setNodeSize(Dimension size) {
        this.size = size;
    }

    public void setParentElement(IElement parentElement) {
        this.parentElement = parentElement;
    }

    public void setSource(EditPart source) {
        this.sourceEditPart = source;
        this.sourceNode = (IGmLinkable)this.sourceEditPart.getModel();
        this.parentElement = this.sourceNode.getRelatedIElement();
    }

    protected IElement createElement(IModelFactory modelFactory, IElementInitializer elementInitializer) {
        IElement newElement = modelFactory.createElement(this.context.getMetaclass());
        Meta meta = new Meta(this.parentElement);
        try {
            meta.appendToDependency(this.context.getDependency(), newElement);
        }
        catch (InvalidModelManipulationException e) {
            String compositionDep = CompositionExpert.getDefaultCompositionDep((IElement)this.parentElement, (IElement)newElement);
            if (compositionDep != null && !compositionDep.isEmpty()) {
                meta.appendToDependency(compositionDep, newElement);
            }
            modelFactory.deleteElement(newElement);
            return null;
        }
        if (this.context.getStereotype() != null && newElement instanceof IModelElement) {
            ((IModelElement)newElement).addExtension(this.context.getStereotype());
        }
        elementInitializer.initialize(newElement);
        return newElement;
    }

    public boolean canExecute() {
        if (!AuthHelper.canModifyDiagram((GmAbstractDiagram)this.sourceNode.getDiagram())) {
            return false;
        }
        IElement newElement = this.context.getElementToUnmask();
        if (newElement == null) {
            return AuthHelper.canAdd((IElement)this.parentElement, (String)this.context.getMetaclass());
        }
        return true;
    }

    public void setSourceAnchor(Object sourceAnchorModel) {
        this.sourceAnchor = sourceAnchorModel;
    }

    protected CreateConnectionRequest getConnectionCreationRequest(GmNodeModel createdNode) {
        EditPart targetPart = (EditPart)this.sourceEditPart.getViewer().getEditPartRegistry().get(createdNode);
        ((GraphicalEditPart)targetPart).getFigure().getUpdateManager().performValidation();
        CreateConnectionRequest request = new CreateConnectionRequest();
        request.setType((Object)"Linked node end");
        request.setLocation(this.location);
        request.setSourceEditPart(this.sourceEditPart);
        request.setTargetEditPart(targetPart);
        request.setFactory((CreationFactory)this.context);
        targetPart = targetPart.getTargetEditPart((Request)request);
        if (targetPart == null) {
            targetPart = this.findTargetAnchorEditPart(request);
        }
        if (targetPart != null) {
            request.setTargetEditPart(targetPart);
        }
        return request;
    }

    protected EditPart findTargetAnchorEditPart(CreateConnectionRequest request) {
        EditPartViewer viewer = request.getTargetEditPart().getViewer();
        1 conditional = new /* Unavailable Anonymous Inner Class!! */;
        EditPart ret = viewer.findObjectAtExcluding(request.getLocation(), Collections.emptyList(), (EditPartViewer.Conditional)conditional);
        if (ret != null) {
            ret = ret.getTargetEditPart((Request)request);
        }
        return ret;
    }
}

