/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.common.linkednode;

import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.diagram.elements.common.linkednode.AbstractLinkedNodeCreationEditPolicy;
import com.modeliosoft.modelio.diagram.elements.common.linkednode.CreateLinkedNodeCommand;
import com.modeliosoft.modelio.diagram.elements.core.commands.ModelioCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeEditPart;
import java.util.Map;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.DropRequest;

public class LinkedNodeFinishCreationEditPolicy
extends AbstractLinkedNodeCreationEditPolicy {
    private static final Object HIGHLIGHTKEY = "target feedback";
    private static final String FINISHPOLICYKEY = "finish_feedback_policy";

    protected void eraseTargetConnectionFeedback(DropRequest dropRequest) {
        super.eraseTargetConnectionFeedback(dropRequest);
        Request request = (Request)dropRequest;
        if (!"Linked node end".equals(request.getType())) {
            return;
        }
        GraphicalEditPolicy delegatePolicy = this.getDelegateFeedbackPolicy((CreateConnectionRequest)dropRequest, false);
        if (delegatePolicy != null) {
            delegatePolicy.showTargetFeedback((Request)dropRequest);
        } else {
            RectangleFigure highlight = (RectangleFigure)request.getExtendedData().get(HIGHLIGHTKEY);
            if (highlight != null) {
                IFigure feedbackLayer = this.getFeedbackLayer();
                if (highlight.getParent() == feedbackLayer) {
                    feedbackLayer.remove((IFigure)highlight);
                    request.getExtendedData().remove(HIGHLIGHTKEY);
                }
            }
        }
    }

    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        GmNodeEditPart nodeEditPart = (GmNodeEditPart)this.getHost();
        CreateLinkedNodeCommand startCommand = (CreateLinkedNodeCommand)request.getStartCommand();
        startCommand.setDestinationNode((GmCompositeNode)nodeEditPart.getModel());
        Point p = new Point(request.getLocation());
        this.getHostFigure().translateToRelative((Translatable)p);
        startCommand.setNodeLocation(p);
        if (request.getSize() != null) {
            Dimension d = new Dimension(request.getSize());
            this.getHostFigure().translateToRelative((Translatable)d);
            startCommand.setNodeSize(d);
        } else {
            startCommand.setNodeSize(null);
        }
        return startCommand;
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        return null;
    }

    protected void showTargetConnectionFeedback(DropRequest request) {
        super.showTargetConnectionFeedback(request);
        CreateConnectionRequest req = (CreateConnectionRequest)request;
        if (req.getType() != "Linked node end") {
            return;
        }
        GraphicalEditPolicy feedbackPolicy = this.getDelegateFeedbackPolicy(req, true);
        if (feedbackPolicy != null) {
            feedbackPolicy.showTargetFeedback((Request)req);
        } else {
            RectangleFigure highlight = (RectangleFigure)req.getExtendedData().get(HIGHLIGHTKEY);
            if (highlight == null) {
                highlight = this.createFeedBackFigure(req);
                IFigure feedbackLayer = this.getFeedbackLayer();
                feedbackLayer.add((IFigure)highlight);
                ((Request)request).getExtendedData().put(HIGHLIGHTKEY, highlight);
            }
            highlight.setBounds(new Rectangle(req.getLocation(), new Dimension(50, 50)));
        }
    }

    private RectangleFigure createFeedBackFigure(CreateConnectionRequest req) {
        RectangleFigure highlight = new RectangleFigure();
        highlight.setBorder((Border)new LineBorder(ColorConstants.black, 1));
        highlight.setFill(false);
        return highlight;
    }

    public EditPart getTargetEditPart(Request request) {
        if ("Linked node end".equals(request.getType())) {
            return this.getHost();
        }
        return null;
    }

    protected GraphicalEditPolicy getDelegateFeedbackPolicy(CreateConnectionRequest req, boolean createMissing) {
        GraphicalEditPolicy ret = null;
        Map data = req.getExtendedData();
        if (data.containsKey(FINISHPOLICYKEY)) {
            return (GraphicalEditPolicy)data.get(FINISHPOLICYKEY);
        }
        if (createMissing) {
            ModelioCreationContext context = (ModelioCreationContext)req.getNewObject();
            String policyClassName = (String)context.getProperties().get(FINISHPOLICYKEY);
            if (policyClassName != null) {
                try {
                    Class<?> c = Class.forName(policyClassName);
                    ret = (GraphicalEditPolicy)c.newInstance();
                    ret.setHost(this.getHost());
                    ret.activate();
                }
                catch (ClassNotFoundException e) {
                    LOG.error((String)"org.modelio.diagram.elements", (Throwable)e);
                }
                catch (InstantiationException e) {
                    LOG.error((String)"org.modelio.diagram.elements", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    LOG.error((String)"org.modelio.diagram.elements", (Throwable)e);
                }
            }
            data.put(FINISHPOLICYKEY, ret);
        }
        return ret;
    }

    protected boolean isHandled(Request req) {
        return "Linked node end".equals(req.getType());
    }
}

