/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.common.linkednode;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.model.MetaModelExpert;
import com.modeliosoft.modelio.core.model.expert.CreationExpertRegistry;
import com.modeliosoft.modelio.core.model.expert.ICreationExpert;
import com.modeliosoft.modelio.diagram.elements.common.linkednode.AbstractLinkedNodeCreationEditPolicy;
import com.modeliosoft.modelio.diagram.elements.common.linkednode.CreateLinkedNodeCommand;
import com.modeliosoft.modelio.diagram.elements.common.linkednode.IGmNodeLink;
import com.modeliosoft.modelio.diagram.elements.core.commands.ModelioCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.figures.FigureUtilities2;
import com.modeliosoft.modelio.diagram.elements.core.helpers.AnchorModelHelper;
import com.modeliosoft.modelio.diagram.elements.core.model.GmModel;
import com.modeliosoft.modelio.diagram.elements.umlcommon.externdocument.CreateExternDocumentCommand;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.ReconnectRequest;

public class LinkedNodeStartCreationEditPolicy
extends AbstractLinkedNodeCreationEditPolicy {
    private static final Object HIGHLIGHTKEY = "feedback source";

    public EditPart getTargetEditPart(Request request) {
        ReconnectRequest r;
        if ("Linked node start".equals(request.getType())) {
            ModelioCreationContext context = (ModelioCreationContext)((CreateConnectionRequest)request).getNewObject();
            Class linkMetaclass = MetaModelExpert.getMetaclass((String)context.getMetaclass());
            IElement sourceElement = ((GmModel)this.getHost().getModel()).getRelatedIElement();
            if (sourceElement == null) {
                return null;
            }
            ICreationExpert stereotypeExpert = CreationExpertRegistry.getExpert(sourceElement.getClass());
            if (stereotypeExpert.canOwn(sourceElement, linkMetaclass, null)) {
                return this.getHost();
            }
            stereotypeExpert = CreationExpertRegistry.getExpert((Class)linkMetaclass);
            if (stereotypeExpert.canLinkFrom(sourceElement, null)) {
                return this.getHost();
            }
            return null;
        }
        if ("Reconnection source".equals(request.getType()) && (r = (ReconnectRequest)request).getConnectionEditPart().getModel() instanceof IGmNodeLink) {
            return this.getHost();
        }
        return null;
    }

    protected void eraseTargetConnectionFeedback(DropRequest request) {
        super.eraseTargetConnectionFeedback(request);
        IFigure highlight = (IFigure)((Request)request).getExtendedData().get(HIGHLIGHTKEY);
        if (highlight != null) {
            IFigure feedbackLayer = this.getFeedbackLayer();
            if (highlight.getParent() == feedbackLayer) {
                feedbackLayer.remove(highlight);
                ((Request)request).getExtendedData().remove(HIGHLIGHTKEY);
            }
        }
    }

    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        return null;
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        ModelioCreationContext context = (ModelioCreationContext)request.getNewObject();
        Object cmd = null;
        cmd = "ExternDocument".equals(context.getMetaclass()) ? new CreateExternDocumentCommand(context) : new CreateLinkedNodeCommand(context);
        cmd.setSource(this.getHost());
        cmd.setSourceAnchor(AnchorModelHelper.getSourceAnchorModel((EditPart)request.getTargetEditPart(), (CreateConnectionRequest)request));
        request.setStartCommand((Command)cmd);
        return cmd;
    }

    protected void showTargetConnectionFeedback(DropRequest dropRequest) {
        Request request = (Request)dropRequest;
        if (request.getType() != "Linked node start") {
            return;
        }
        Command c = this.getCommand(request);
        FigureUtilities2.HighlightType hightlightType = FigureUtilities2.HighlightType.INFO;
        hightlightType = c == null ? FigureUtilities2.HighlightType.ERROR : (c.canExecute() ? FigureUtilities2.HighlightType.SUCCESS : FigureUtilities2.HighlightType.WARNING);
        IFigure highlight = (IFigure)request.getExtendedData().get(HIGHLIGHTKEY);
        if (highlight == null) {
            highlight = FigureUtilities2.createHighlightFigure((IFigure)this.getFeedbackLayer(), (IFigure)this.getHostFigure(), (FigureUtilities2.HighlightType)hightlightType);
            this.getFeedbackLayer().add(highlight);
            request.getExtendedData().put(HIGHLIGHTKEY, highlight);
        }
        FigureUtilities2.updateHighlightType((IFigure)highlight, (FigureUtilities2.HighlightType)hightlightType);
    }

    protected boolean isHandled(Request request) {
        if ("Linked node start".equals(request.getType())) {
            return true;
        }
        if ("Reconnection source".equals(request.getType())) {
            ReconnectRequest r = (ReconnectRequest)request;
            return r.getConnectionEditPart().getModel() instanceof IGmNodeLink;
        }
        return false;
    }

    protected void eraseCreationFeedback(CreateConnectionRequest request) {
        super.eraseCreationFeedback(request);
        this.eraseTargetConnectionFeedback((DropRequest)request);
    }
}

