/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.common.linktovoid;

import com.modeliosoft.modelio.diagram.elements.common.linktovoid.LinkToVoidConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.FeedbackHelper;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.ReconnectRequest;

public abstract class AbstractLinkToVoidCreationEditPolicy
extends GraphicalEditPolicy
implements LinkToVoidConstants {
    protected FeedbackHelper feedbackHelper;
    protected Connection connectionFeedback;

    public void deactivate() {
        if (this.connectionFeedback != null) {
            this.removeFeedback((IFigure)this.connectionFeedback);
            this.feedbackHelper = null;
            this.connectionFeedback = null;
        }
        super.deactivate();
    }

    public void eraseSourceFeedback(Request request) {
        if ("Link to void end".equals(request.getType())) {
            this.eraseCreationFeedback((CreateConnectionRequest)request);
        }
    }

    public void eraseTargetFeedback(Request request) {
        if ("Link to void start".equals(request.getType()) || "Link to void end".equals(request.getType()) || "Link to void reconnection source".equals(request.getType()) || "Link to void reconnection target".equals(request.getType())) {
            this.eraseTargetConnectionFeedback((DropRequest)request);
        }
    }

    public Command getCommand(Request request) {
        if ("Link to void start".equals(request.getType())) {
            return this.getConnectionCreateCommand((CreateConnectionRequest)request);
        }
        if ("Link to void end".equals(request.getType())) {
            return this.getConnectionCompleteCommand((CreateConnectionRequest)request);
        }
        if ("Link to void reconnection target".equals(request.getType())) {
            return this.getReconnectTargetCommand((ReconnectRequest)request);
        }
        return null;
    }

    public void showSourceFeedback(Request request) {
        if ("Link to void end".equals(request.getType())) {
            this.showCreationFeedback((CreateConnectionRequest)request);
        }
    }

    public void showTargetFeedback(Request request) {
        if ("Link to void start".equals(request.getType()) || "Link to void end".equals(request.getType()) || "Link to void reconnection source".equals(request.getType()) || "Link to void reconnection target".equals(request.getType())) {
            this.showTargetConnectionFeedback((DropRequest)request);
        }
    }

    protected Connection createDummyConnection(Request req) {
        return new PolylineConnection();
    }

    protected void eraseCreationFeedback(CreateConnectionRequest request) {
        if (this.connectionFeedback != null) {
            this.removeFeedback((IFigure)this.connectionFeedback);
            this.feedbackHelper = null;
            this.connectionFeedback = null;
        }
    }

    protected void eraseTargetConnectionFeedback(DropRequest request) {
    }

    protected abstract Command getConnectionCompleteCommand(CreateConnectionRequest var1);

    protected abstract Command getConnectionCreateCommand(CreateConnectionRequest var1);

    protected ConnectionRouter getDummyConnectionRouter(CreateConnectionRequest request) {
        return ((ConnectionLayer)this.getLayer((Object)"Connection Layer")).getConnectionRouter();
    }

    protected FeedbackHelper getFeedbackHelper(CreateConnectionRequest request) {
        if (this.feedbackHelper == null) {
            this.feedbackHelper = new FeedbackHelper();
            Point p = request.getLocation();
            this.connectionFeedback = this.createDummyConnection((Request)request);
            this.connectionFeedback.setConnectionRouter(this.getDummyConnectionRouter(request));
            this.connectionFeedback.setSourceAnchor(this.getSourceConnectionAnchor(request));
            this.feedbackHelper.setConnection(this.connectionFeedback);
            this.addFeedback((IFigure)this.connectionFeedback);
            this.feedbackHelper.update(null, p);
        }
        return this.feedbackHelper;
    }

    protected ConnectionAnchor getSourceConnectionAnchor(CreateConnectionRequest request) {
        EditPart source = request.getSourceEditPart();
        return source instanceof NodeEditPart ? ((NodeEditPart)source).getSourceConnectionAnchor((Request)request) : null;
    }

    protected ConnectionAnchor getTargetConnectionAnchor(CreateConnectionRequest request) {
        EditPart target = request.getTargetEditPart();
        return target instanceof NodeEditPart ? ((NodeEditPart)target).getTargetConnectionAnchor((Request)request) : null;
    }

    protected void showCreationFeedback(CreateConnectionRequest request) {
        FeedbackHelper helper = this.getFeedbackHelper(request);
        Point p = new Point(request.getLocation());
        helper.update(this.getTargetConnectionAnchor(request), p);
    }

    protected void showTargetConnectionFeedback(DropRequest request) {
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        return null;
    }
}

