/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.common.linktovoid;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.utils.exceptions.InvalidModelManipulationException;
import com.modeliosoft.modelio.core.factory.IElementInitializer;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.core.model.CompositionExpert;
import com.modeliosoft.modelio.core.model.Meta;
import com.modeliosoft.modelio.diagram.elements.common.abstractdiagram.GmAbstractDiagram;
import com.modeliosoft.modelio.diagram.elements.core.commands.ModelioCreationContext;
import com.modeliosoft.modelio.diagram.elements.core.helpers.AuthHelper;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLink;
import com.modeliosoft.modelio.diagram.elements.core.link.GmPath;
import com.modeliosoft.modelio.diagram.elements.core.link.anchors.GmSourceSatelliteAnchor;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmLink;
import com.modeliosoft.modelio.diagram.elements.core.node.GmCompositeNode;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import java.util.ArrayList;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.commands.Command;

public class CreateLinkToVoidCommand
extends Command {
    private final ModelioCreationContext context;
    private IElement parentElement;
    private GmNodeModel sourceNode;
    private GmCompositeNode destNode;
    private Dimension destinationLocation;
    private IElement createdElement;
    private Object srcAnchorModel;

    public CreateLinkToVoidCommand(ModelioCreationContext context) {
        this.context = context;
    }

    public void execute() {
        GmAbstractDiagram diagram = this.sourceNode.getDiagram();
        IElement newElement = this.context.getElementToUnmask();
        if (newElement == null) {
            newElement = this.createElement(diagram.getModelFactory(), diagram.getElementInitializer());
        }
        if (this.sourceNode != this.destNode) {
            GmLink gmlink = diagram.unmaskLink(newElement);
            GmPath path = new GmPath();
            path.setSourceAnchor(this.srcAnchorModel);
            path.setTargetAnchor((Object)new GmSourceSatelliteAnchor(this.destinationLocation));
            path.setPathData(new ArrayList());
            gmlink.setLayoutData((Object)path);
            this.sourceNode.addStartingLink((IGmLink)gmlink);
            diagram.addEndingLink((IGmLink)gmlink);
        }
    }

    public void setDestinationNode(GmCompositeNode destNode) {
        this.destNode = destNode;
    }

    public void setParentElement(IElement parentElement) {
        this.parentElement = parentElement;
    }

    public void setSourceNode(GmNodeModel sourceNode) {
        this.sourceNode = sourceNode;
        this.parentElement = sourceNode.getRelatedIElement();
    }

    protected IElement createElement(IModelFactory modelFactory, IElementInitializer elementInitializer) {
        this.createdElement = modelFactory.createElement(this.context.getMetaclass());
        Meta meta = new Meta(this.parentElement);
        try {
            meta.appendToDependency(this.context.getDependency(), this.createdElement);
        }
        catch (InvalidModelManipulationException e) {
            String compositionDep = CompositionExpert.getDefaultCompositionDep((IElement)this.parentElement, (IElement)this.createdElement);
            if (compositionDep != null && !compositionDep.isEmpty()) {
                meta.appendToDependency(compositionDep, this.createdElement);
            }
            modelFactory.deleteElement(this.createdElement);
            throw e;
        }
        if (this.context.getStereotype() != null && this.createdElement instanceof IModelElement) {
            ((IModelElement)this.createdElement).addExtension(this.context.getStereotype());
        }
        elementInitializer.initialize(this.createdElement);
        return this.createdElement;
    }

    public void setDestinationLocation(Dimension dimension) {
        this.destinationLocation = dimension;
    }

    public boolean canExecute() {
        if (!AuthHelper.canModifyDiagram((GmAbstractDiagram)this.sourceNode.getDiagram())) {
            return false;
        }
        IElement newElement = this.context.getElementToUnmask();
        if (newElement == null) {
            return AuthHelper.canAdd((IElement)this.parentElement, (String)this.context.getMetaclass());
        }
        return true;
    }

    protected GmCompositeNode getDestNode() {
        return this.destNode;
    }

    protected Dimension getDestinationLocation() {
        return this.destinationLocation;
    }

    protected GmNodeModel getSourceNode() {
        return this.sourceNode;
    }

    protected ModelioCreationContext getContext() {
        return this.context;
    }

    public IElement getParentElement() {
        return this.parentElement;
    }

    public IElement getCreatedElement() {
        return this.createdElement;
    }

    public void setSourceAnchor(Object srcAnchorModel) {
        this.srcAnchorModel = srcAnchorModel;
    }
}

