/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.common.linktovoid;

import com.modeliosoft.modelio.diagram.elements.core.figures.LinkFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.handles.ConnectionEndpointHandle;
import org.eclipse.gef.tools.ConnectionEndpointTracker;

public class LinkToVoidEndPointHandle
extends ConnectionEndpointHandle {
    private static final Rectangle DRAW_RECT = new Rectangle();

    public LinkToVoidEndPointHandle(ConnectionEditPart owner, int endPoint) {
        super(owner, endPoint);
        this.initPreferredSize();
    }

    private void initPreferredSize() {
        LinkFigure conn = (LinkFigure)this.getConnection();
        RotatableDecoration decoration = this.getEndPoint() == 2 ? conn.getSourceDecoration() : conn.getTargetDecoration();
        if (decoration != null) {
            Dimension decSize = decoration.getSize();
            decSize.expand(4, 4);
            conn.translateToAbsolute((Translatable)decSize);
            decSize.union(this.getPreferredSize());
            this.setPreferredSize(decSize);
        }
    }

    protected DragTracker createDragTracker() {
        if (this.isFixed()) {
            return null;
        }
        ConnectionEndpointTracker tracker = new ConnectionEndpointTracker((ConnectionEditPart)this.getOwner());
        if (this.getEndPoint() == 2) {
            tracker.setCommandName("Link to void reconnection source");
        } else {
            tracker.setCommandName("Link to void reconnection target");
        }
        tracker.setDefaultCursor(this.getCursor());
        return tracker;
    }

    protected int getBorderAlpha() {
        return this.isPrimary() ? 100 : 255;
    }

    protected int getFillAlpha() {
        return this.isPrimary() ? 255 : 100;
    }

    public void paintFigure(Graphics g) {
        DRAW_RECT.setBounds(this.getBounds());
        DRAW_RECT.resize(-1, -1);
        g.setForegroundColor(this.getBorderColor());
        g.setAlpha(this.getBorderAlpha());
        g.drawRectangle(DRAW_RECT);
        DRAW_RECT.shrink(1, 1);
        g.setForegroundColor(this.getFillColor());
        g.setAlpha(this.getFillAlpha());
        g.drawRectangle(DRAW_RECT);
        DRAW_RECT.shrink(1, 1);
        g.setForegroundColor(this.getFillColor());
        g.setAlpha(this.getFillAlpha());
        g.drawRectangle(DRAW_RECT);
    }
}

