/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.common.linktovoid;

import com.modeliosoft.modelio.diagram.elements.common.linktovoid.AbstractLinkToVoidCreationEditPolicy;
import com.modeliosoft.modelio.diagram.elements.common.linktovoid.CreateLinkToVoidCommand;
import com.modeliosoft.modelio.diagram.elements.common.linktovoid.LinkToVoidFinishCreationEditPolicy;
import com.modeliosoft.modelio.diagram.elements.core.link.GmLink;
import com.modeliosoft.modelio.diagram.elements.core.node.GmNodeModel;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.ReconnectRequest;

public class LinkToVoidFinishCreationEditPolicy
extends AbstractLinkToVoidCreationEditPolicy {
    private static final Object HIGHLIGHTKEY = "target feedback";

    protected void eraseTargetConnectionFeedback(DropRequest request) {
        super.eraseTargetConnectionFeedback(request);
        Request request2 = (Request)request;
        RectangleFigure highlight = (RectangleFigure)request2.getExtendedData().get(HIGHLIGHTKEY);
        if (highlight != null) {
            IFigure feedbackLayer = this.getFeedbackLayer();
            if (highlight.getParent() == feedbackLayer) {
                feedbackLayer.remove((IFigure)highlight);
                request2.getExtendedData().remove(HIGHLIGHTKEY);
            }
        }
    }

    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        CreateLinkToVoidCommand startCommand = (CreateLinkToVoidCommand)request.getStartCommand();
        IFigure srcFigure = ((AbstractGraphicalEditPart)request.getSourceEditPart()).getFigure();
        Dimension dist = this.computeDistance(srcFigure, request.getLocation());
        startCommand.setDestinationLocation(dist);
        return startCommand;
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        return null;
    }

    protected void showTargetConnectionFeedback(DropRequest request) {
        super.showTargetConnectionFeedback(request);
        Request req = (Request)request;
        if (req.getType() != "Link to void end") {
            return;
        }
        RectangleFigure highlight = (RectangleFigure)req.getExtendedData().get(HIGHLIGHTKEY);
        if (highlight == null) {
            highlight = this.createFeedBackFigure(request);
            this.getFeedbackLayer().add((IFigure)highlight);
            req.getExtendedData().put(HIGHLIGHTKEY, highlight);
        }
        Point location = request.getLocation().getCopy();
        highlight.translateToRelative((Translatable)location);
        highlight.setBounds(new Rectangle(location, new Dimension(10, 10)));
    }

    private RectangleFigure createFeedBackFigure(DropRequest req) {
        RectangleFigure highlight = new RectangleFigure();
        highlight.setBorder((Border)new LineBorder(ColorConstants.black, 1));
        highlight.setFill(false);
        return highlight;
    }

    public EditPart getTargetEditPart(Request request) {
        if ("Link to void end".equals(request.getType()) || "Link to void reconnection target".equals(request.getType())) {
            return this.getHost();
        }
        return null;
    }

    protected Dimension computeDistance(IFigure srcFigure, Point absoluteLoc) {
        Point loc = srcFigure.getBounds().getLocation();
        srcFigure.translateToAbsolute((Translatable)loc);
        Dimension dist = absoluteLoc.getDifference(loc);
        srcFigure.translateToRelative((Translatable)dist);
        return dist;
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        GmLink gmLink = (GmLink)request.getConnectionEditPart().getModel();
        GraphicalEditPart srcEditPart = (GraphicalEditPart)request.getConnectionEditPart().getSource();
        IFigure srcFigure = srcEditPart.getFigure();
        Dimension dist = this.computeDistance(srcFigure, request.getLocation());
        DisconnectLinkCommand cmd = new DisconnectLinkCommand(gmLink, (GmNodeModel)gmLink.getDiagram());
        cmd.setAnchorLocation(dist);
        return cmd;
    }
}

