/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.elements.common.portbordered;

import com.modeliosoft.modelio.diagram.elements.common.portbordered.PortContainerFigure;
import com.modeliosoft.modelio.diagram.elements.core.figures.GradientFigure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class PortBorderedFigure
extends GradientFigure {
    private PortContainerFigure portContainer;
    private Rectangle overallBounds = null;
    private IFigure primaryFigure = null;

    public PortBorderedFigure(IFigure primaryFigure) {
        this.primaryFigure = primaryFigure;
        this.portContainer = new PortContainerFigure();
        this.add(this.primaryFigure);
        this.add((IFigure)this.portContainer);
        this.setBounds(primaryFigure.getBounds().getCopy());
    }

    protected void layout() {
        if (!this.getBounds().equals((Object)this.primaryFigure.getBounds())) {
            this.primaryFigure.setBounds(this.getBounds().getCopy());
            this.portContainer.invalidateTree();
            this.erase();
        }
    }

    public void addPortFigure(IFigure figure) {
        this.portContainer.add(figure);
    }

    public Dimension getMinimumSize(int wHint, int hHint) {
        return this.primaryFigure.getMinimumSize(wHint, hHint);
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return this.primaryFigure.getPreferredSize(wHint, hHint);
    }

    public void repaint() {
        super.repaint();
        this.portContainer.repaint();
    }

    public void removePortFigure(IFigure figure) {
        this.portContainer.remove(figure);
    }

    public void addToPrimaryFigure(IFigure figure, int index) {
        this.primaryFigure.add(figure, index);
    }

    public void removeFromPrimaryFigure(IFigure figure) {
        this.primaryFigure.remove(figure);
    }

    public Rectangle getClientArea(Rectangle rect) {
        if (this.primaryFigure != null) {
            return this.primaryFigure.getClientArea(rect);
        }
        return super.getClientArea(rect);
    }

    public boolean containsPoint(int x, int y) {
        if (this.portContainer.containsPoint(x, y)) {
            return true;
        }
        return super.containsPoint(x, y);
    }

    protected void primTranslate(int dx, int dy) {
        super.primTranslate(dx, dy);
        this.erase();
    }

    public void erase() {
        super.erase();
        this.portContainer.erase();
    }

    public IFigure findFigureAt(int x, int y, TreeSearch search) {
        if (search.prune((IFigure)this)) {
            return null;
        }
        IFigure result = this.portContainer.findFigureAt(x, y, search);
        if (result != null) {
            return result;
        }
        return this.primaryFigure.findFigureAt(x, y, search);
    }

    public IFigure findMouseEventTargetAt(int x, int y) {
        IFigure borderItemFigure = this.portContainer.findMouseEventTargetAt(x, y);
        if (borderItemFigure != null) {
            return borderItemFigure;
        }
        return super.findMouseEventTargetAt(x, y);
    }

    public boolean intersects(Rectangle rect) {
        if (this.getOverallBounds().intersects(rect)) {
            return true;
        }
        return super.intersects(rect);
    }

    public Rectangle getOverallBounds() {
        if (this.overallBounds == null) {
            Rectangle rect = this.getBounds().getCopy();
            if (this.portContainer != null) {
                rect = rect.union(this.portContainer.getOverallBounds());
            }
            this.overallBounds = rect;
        }
        return this.overallBounds;
    }

    public void invalidate() {
        this.overallBounds = null;
        super.invalidate();
    }

    public void validate() {
        this.overallBounds = null;
        super.validate();
    }

    protected void fireFigureMoved() {
        super.fireFigureMoved();
        this.overallBounds = null;
    }

    public Rectangle getHandleBounds() {
        return super.getHandleBounds();
    }

    public IFigure getPrimaryFigure() {
        return this.primaryFigure;
    }
}

